/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators.ldap;

import com.luna.insight.client.security.ldap.LDAPAuthenticationSearchImpl;
import com.luna.insight.client.security.ldap.SearchAttributes;
import com.lunaimaging.insight.core.domain.authenticators.ldap.LdapSearchMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapCredentialsMap
extends LDAPAuthenticationSearchImpl
implements LdapSearchMap {
    protected List<String> conditions = null;
    protected List<String> mappedValues = null;
    protected Pattern conditionPattern = null;
    protected List<Pattern> conditionValuePatterns = null;
    public final Log logger = LogFactory.getLog(this.getClass());

    public LdapCredentialsMap() {
        this.conditionPattern = Pattern.compile("\\s*([\\S&&[^=]]+)\\s*=\\s*(.+)\\s*");
    }

    @Override
    public List<String> getConditions() {
        return this.conditions;
    }

    @Override
    public List<String> getMappedValues() {
        return this.mappedValues;
    }

    @Override
    public void setConditions(List<String> conditions) {
        this.conditions = conditions;
    }

    @Override
    public void setMappedValues(List<String> values) {
        this.mappedValues = values;
    }

    protected String[] getConditionAttributeValue(int i) {
        this.logger.debug((Object)"getConditionAttributeValue(..)");
        String attr = null;
        String value = null;
        String c = this.conditions.get(i);
        this.logger.debug((Object)("getConditionAttributeValue: condition c = " + c));
        Matcher m = this.conditionPattern.matcher(c);
        if (m.find()) {
            attr = m.group(1);
            if (attr != null) {
                attr.trim();
            }
            if ((value = m.group(2)) != null) {
                value.trim();
            }
            this.logger.debug((Object)("getConditionAttributeValue(..): attr = " + attr + " value = " + value));
        } else {
            this.logger.debug((Object)("getConditionAttributeValue(..): could not find the pattern: " + this.conditionPattern.pattern()));
        }
        String[] pair = new String[]{attr, value};
        return pair;
    }

    protected synchronized void createConditionValuePatterns() {
        if (this.conditionValuePatterns == null) {
            this.conditionValuePatterns = new ArrayList<Pattern>();
            for (int i = 0; i < this.conditions.size(); ++i) {
                String[] pair = this.getConditionAttributeValue(i);
                String conditionValue = pair[1];
                Pattern p = Pattern.compile(conditionValue);
                this.conditionValuePatterns.add(p);
            }
        }
    }

    @Override
    public Object mapValue(String username, String password, String dn) {
        this.logger.debug((Object)"mapValue(..)");
        this.createConditionValuePatterns();
        Object mapValue = -1;
        Hashtable<String, String> initialEnv = new Hashtable<String, String>();
        ArrayList searchAttributesList = new ArrayList();
        this.populateSearchConditions(searchAttributesList, username);
        this.initEnvForLogin(username, password, this.activeDirectory, initialEnv);
        if (dn != null && dn.length() > 0) {
            initialEnv.put("java.naming.security.principal", dn);
        }
        try {
            this.precedingSearches(searchAttributesList, initialEnv);
            SearchAttributes searchAttrs = this.getLastSearchAttributes(searchAttributesList);
            this.logger.debug((Object)("mapValue(..): conditions.size() = " + this.conditions.size()));
            for (int i = 0; i < this.conditions.size(); ++i) {
                String[] pair = this.getConditionAttributeValue(i);
                String conditionAttr = pair[0];
                String conditionValue = pair[1];
                this.logger.debug((Object)("mapValue condition attribute = " + conditionAttr + ", condition Value = " + conditionValue));
                if (conditionAttr == null || !searchAttrs.hasAttributeValue(conditionAttr, this.conditionValuePatterns.get(i))) continue;
                mapValue = this.mappedValues.get(i);
                break;
            }
        }
        catch (IndexOutOfBoundsException ie) {
            this.logger.error((Object)("mapValue(..): Error: Check ldapCredentialsMap's conditions of the configuration file, message = " + ie.getMessage()));
            ie.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)("mapValue(..): Error: message = " + e.getMessage()));
            e.printStackTrace();
        }
        this.logger.debug((Object)("mapValue(..): mapValue = " + mapValue));
        return mapValue;
    }
}

