/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators;

import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUserClient;
import com.luna.insight.server.TrinityCollectionInfo;
import com.lunaimaging.insight.core.dao.legacy.LegacyCollectionRunner;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.authenticators.AbstractAuthenticator;
import com.lunaimaging.insight.core.domain.cache.IntUnboundCache;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.MediaCollectionUtils;
import com.lunaimaging.security.IpAddressUsernamePasswordToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class LegacyUserAuthenticator
extends AbstractAuthenticator {
    protected String serverName;

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public Credentials authenticate(String username, String password, IntUnboundCache credentialsCache) {
        boolean auth;
        InsightUserClient iuc = this.constructInsightUserClient();
        if (iuc.isConnectionGood() && (auth = iuc.authenticateUsernameAndPassword(username, password))) {
            Vector collections = iuc.getAvailableCollections(username, password);
            return this.generateCredentials(collections);
        }
        return null;
    }

    public Credentials authenticate(IpAddressUsernamePasswordToken token, IntUnboundCache credentialsCache, List<MediaCollection> mediaCollections) {
        String pwd = token.getPassword() != null ? new String(token.getPassword()) : null;
        return this.authenticate(token.getUsername(), pwd, credentialsCache, mediaCollections);
    }

    public Credentials authenticate(String username, String password, IntUnboundCache credentialsCache, List<MediaCollection> mediaCollections) {
        boolean auth;
        InsightUserClient iuc = this.constructInsightUserClient();
        if (iuc.isConnectionGood() && (auth = iuc.authenticateUsernameAndPassword(username, password))) {
            Vector collections = iuc.getAvailableCollections(username, password);
            MediaCollectionUtils.removeNonExistingInsightCollections(mediaCollections, collections);
            return this.generateCredentials(collections);
        }
        return null;
    }

    protected Credentials generateCredentials(Vector collections) {
        Credentials cred = new Credentials();
        ArrayList<Integer> maxResolutions = new ArrayList<Integer>();
        ArrayList<Integer> maxExportResolutions = new ArrayList<Integer>();
        ArrayList<String> authCollectionIds = new ArrayList<String>();
        boolean exportAllowed = true;
        for (int i = 0; i < collections.size(); ++i) {
            exportAllowed = true;
            TrinityCollectionInfo tci = (TrinityCollectionInfo)collections.get(i);
            InsightSmartClient isc = this.getInsightSmartClient(tci);
            if (isc == null) continue;
            isc.startSessions();
            tci = isc.getConfigurationInfo(tci, null);
            String constructedCollectionId = InsightCoreUtils.constructMediaCollectionId(tci.getInstitutionID(), String.valueOf(tci.getCollectionID()), String.valueOf(tci.getUniqueCollectionID()));
            if (!authCollectionIds.contains(constructedCollectionId)) {
                authCollectionIds.add(constructedCollectionId);
                maxResolutions.add(tci.maxViewableSize);
                maxExportResolutions.add(tci.exportMaxResolution);
            }
            if (tci.exportMaxResolution > 0 || tci.presentationExportMaxResolution > 0) continue;
            exportAllowed = false;
        }
        cred.setName("domainAuthenticatedCredential");
        cred.setMaxResolutions(maxResolutions);
        cred.setMaxExportResolutions(maxExportResolutions);
        cred.setUseAsDefault(false);
        cred.setExportAllowed(exportAllowed);
        cred.setAuthorizedCollectionIds(authCollectionIds);
        return cred;
    }

    protected InsightSmartClient getInsightSmartClient(TrinityCollectionInfo key) {
        LegacyCollectionRunner lcr = new LegacyCollectionRunner();
        lcr.setTci(key);
        Thread t = new Thread(lcr);
        t.start();
        long endTimeMillis = System.currentTimeMillis() + 10000L;
        do {
            if (!t.isAlive() || System.currentTimeMillis() <= endTimeMillis) continue;
            t.interrupt();
            return null;
        } while (t.isAlive());
        InsightSmartClient isc = new InsightSmartClient(key);
        return isc;
    }

    protected InsightUserClient constructInsightUserClient() {
        InsightUserClient iuc = new InsightUserClient(this.serverName);
        return iuc;
    }

    @Override
    public boolean isUniqueUsername(String username) {
        return true;
    }
}

