/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators;

import com.luna.insight.client.security.ldap.LDAPAuthenticationSearch;
import com.luna.insight.server.InsightUserClient;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.authenticators.LdapAuthenticator;
import com.lunaimaging.insight.core.domain.authenticators.ldap.LdapSearch;
import com.lunaimaging.insight.core.domain.authenticators.ldap.LdapSearchMap;
import com.lunaimaging.insight.core.domain.cache.IntUnboundCache;
import com.lunaimaging.insight.core.utils.MediaCollectionUtils;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapSearchAuthenticator
extends LdapAuthenticator
implements LdapSearch {
    public final Log logger = LogFactory.getLog(this.getClass());
    protected LDAPAuthenticationSearch ldapAuthenticationSearch = null;
    protected LdapSearchMap ldapSearchMap = null;

    @Override
    public void setLdapAuthenticationSearch(LDAPAuthenticationSearch search) {
        this.ldapAuthenticationSearch = search;
    }

    @Override
    public LDAPAuthenticationSearch getLdapAuthenticationSearch() {
        return this.ldapAuthenticationSearch;
    }

    protected Credentials credentialsWithSearchMap(String username, String password, IntUnboundCache credentialsCache, String dn) {
        Credentials c = null;
        this.ldapSearchMap.setLdapUserAttribute(this.ldapAuthenticationSearch.getLdapUserAttribute());
        this.ldapSearchMap.setLdapURL(this.ldapAuthenticationSearch.getLdapURL());
        this.ldapSearchMap.setBaseDN(this.ldapAuthenticationSearch.getBaseDN());
        this.ldapSearchMap.setLoginSSL(this.ldapAuthenticationSearch.getLoginSSL());
        this.ldapSearchMap.setTrustStorePath(this.ldapAuthenticationSearch.getTrustStorePath());
        this.ldapSearchMap.setActiveDirectory(this.ldapAuthenticationSearch.getActiveDirectory());
        Object obj = this.ldapSearchMap.mapValue(username, password, dn);
        this.logger.debug((Object)("credentialsWithSearchMap(..) mapValue = " + obj));
        if (obj != null) {
            try {
                int key = Integer.parseInt(obj.toString());
                Object keyObj = credentialsCache.get(key);
                if (keyObj != null) {
                    c = (Credentials)keyObj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return c;
    }

    @Override
    public Credentials authenticate(String username, String password, IntUnboundCache credentialsCache) {
        Credentials c = null;
        StringBuffer dnBuf = new StringBuffer();
        try {
            boolean authenticated = this.ldapAuthenticationSearch.authenticate(username, password, dnBuf);
            this.logger.info((Object)("authenticate(..): authenticated = " + authenticated));
            if (authenticated) {
                if (this.serverName != null) {
                    InsightUserClient iuc = this.constructInsightUserClient();
                    if (iuc.isConnectionGood()) {
                        Vector collections = iuc.getAvailableCollections(username, null);
                        return this.generateCredentials(collections);
                    }
                } else {
                    c = this.credentialsWithSearchMap(username, password, credentialsCache, dnBuf.toString());
                    if (c == null) {
                        c = this.defaultCredentials;
                    }
                    this.logger.info((Object)("authenticate(..): returning Credentials with id: " + c.getId()));
                }
            } else {
                this.logger.error((Object)"authenticate(..): authentication failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    @Override
    public Credentials authenticate(String username, String password, IntUnboundCache credentialsCache, List<MediaCollection> mediaCollections) {
        Credentials c = null;
        StringBuffer dnBuf = new StringBuffer();
        try {
            boolean authenticated = this.ldapAuthenticationSearch.authenticate(username, password, dnBuf);
            this.logger.info((Object)("authenticate(..): authenticated = " + authenticated));
            if (authenticated) {
                if (this.serverName != null) {
                    InsightUserClient iuc = this.constructInsightUserClient();
                    if (iuc.isConnectionGood()) {
                        Vector collections = iuc.getAvailableCollections(username, null);
                        MediaCollectionUtils.removeNonExistingInsightCollections(mediaCollections, collections);
                        return this.generateCredentials(collections);
                    }
                } else {
                    c = this.credentialsWithSearchMap(username, password, credentialsCache, dnBuf.toString());
                    if (c == null) {
                        c = this.defaultCredentials;
                    }
                    this.logger.info((Object)("authenticate(..): returning Credentials with id: " + c.getId()));
                }
            } else {
                this.logger.error((Object)"authenticate(..): authentication failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    @Override
    public LdapSearchMap getLdapSearchMap() {
        return this.ldapSearchMap;
    }

    @Override
    public void setLdapSearchMap(LdapSearchMap map) {
        this.ldapSearchMap = map;
    }
}

