/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators;

import com.luna.insight.server.InsightUserClient;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.authenticators.LegacyUserAuthenticator;
import com.lunaimaging.insight.core.domain.cache.IntUnboundCache;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapAuthenticator
extends LegacyUserAuthenticator {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String ldapHost;
    protected int ldapPort = 389;
    protected int ldapVersion = 3;
    protected String[] organizationUnits;
    protected String domainComponent;

    public String getDomainComponent() {
        return this.domainComponent;
    }

    public void setDomainComponent(String domainComponent) {
        this.domainComponent = domainComponent;
    }

    public String[] getOrganizationUnits() {
        return this.organizationUnits;
    }

    public void setOrganizationUnits(String[] organizationUnits) {
        this.organizationUnits = organizationUnits;
    }

    public int getLdapVersion() {
        return this.ldapVersion;
    }

    public void setLdapVersion(int ldapVersion) {
        this.ldapVersion = ldapVersion;
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials authenticate(String username, String password, IntUnboundCache credentialsCache) {
        String loginDN = this.generateUsableDN(username);
        LDAPConnection lc = new LDAPConnection();
        try {
            lc.connect(this.ldapHost, this.ldapPort);
            lc.bind(this.ldapVersion, loginDN, password.getBytes("UTF8"));
            if (lc.isBound()) {
                LDAPEntry myEntry = lc.read(loginDN);
                String ldapUsername = myEntry.getAttribute("cn").getStringValue();
                InsightUserClient iuc = this.constructInsightUserClient();
                if (iuc.isConnectionGood()) {
                    Vector collections = iuc.getAvailableCollections(ldapUsername, null);
                    Credentials credentials = this.generateCredentials(collections);
                    return credentials;
                }
            }
        }
        catch (LDAPException e) {
            this.log.debug((Object)"LDAP authenticator exception with the LoginContext", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.debug((Object)"LDAP authenticator exception with the password.getBytes('UTF8') method", (Throwable)e);
        }
        finally {
            try {
                lc.disconnect();
            }
            catch (LDAPException e) {
                this.log.debug((Object)"LDAP authenticator exception with the LoginContext.disconnect() method", (Throwable)e);
            }
        }
        return null;
    }

    private String generateUsableDN(String username) {
        String[] dcSplit = StringUtils.split((String)this.domainComponent, (String)".");
        String dcList = "";
        for (String part : dcSplit) {
            dcList = dcList + ",DC=" + part;
        }
        String ouList = "";
        for (String part : this.organizationUnits) {
            ouList = ouList + ",OU=" + part;
        }
        String toReturn = "CN=" + username + ouList + dcList;
        return toReturn;
    }

    @Override
    public boolean isUniqueUsername(String username) {
        return true;
    }
}

