/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators;

import com.luna.insight.server.Debug;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class KerberosProxyCallbackHandler
implements CallbackHandler {
    protected String username;
    protected String password;

    public static void debugOut(String s) {
        KerberosProxyCallbackHandler.debugOut(s, 2);
    }

    public static void debugOut(String s, int level) {
        Debug.debugOut((String)("KerberosProxyCallbackHandler: " + s), (int)level);
    }

    public KerberosProxyCallbackHandler(String un, String pw) {
        this.username = un;
        this.password = pw;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                cb = (PasswordCallback)callbacks[i];
                String pw = this.password;
                char[] passwd = new char[pw.length()];
                pw.getChars(0, passwd.length, passwd, 0);
                ((PasswordCallback)cb).setPassword(passwd);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

