/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators;

import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.authenticators.KerberosProxyCallbackHandler;
import com.lunaimaging.insight.core.domain.authenticators.LdapAuthenticator;
import com.lunaimaging.insight.core.domain.cache.IntUnboundCache;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KerberosAuthenticator
extends LdapAuthenticator {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String confFile = "";
    protected String realm = "";
    protected String kdcServer = "";
    protected String userDomain = "";
    protected String filterAttributeName = "userPrincipalName";

    @Override
    public Credentials authenticate(String username, String password, IntUnboundCache credentialsCache) {
        System.setProperty("java.security.krb5.realm", this.realm);
        System.setProperty("java.security.krb5.kdc", this.kdcServer);
        try {
            NameCallback nc = new NameCallback("do not prompt");
            nc.setName(username + this.userDomain);
            PasswordCallback pc = new PasswordCallback("do not prompt", false);
            pc.setPassword(password.toCharArray());
            Callback[] cb = new Callback[]{nc, pc};
            KerberosProxyCallbackHandler kp = new KerberosProxyCallbackHandler(username + this.userDomain, password);
            kp.handle(cb);
            LoginContext context = new LoginContext(this.confFile, kp);
            context.login();
            String displayName = this.findDisplayName(username);
            Credentials credentials = super.authenticate(displayName, password, null);
            return credentials;
        }
        catch (Exception e) {
            this.log.debug((Object)"Kerberos authenticator exception with the KerberosProxyCallbackHandler.handle( callback ) method", (Throwable)e);
            return null;
        }
    }

    private String findDisplayName(String username) {
        String toReturn = "";
        try {
            Attribute displayName;
            Attributes attrs;
            SearchResult sr;
            String filter = "(" + this.filterAttributeName + "=" + username + this.userDomain + ")";
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + this.ldapHost);
            InitialDirContext ctx = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            String baseDN = this.generateBaseDN(username);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, filter, sc);
            if (answer.hasMore() && (sr = answer.next()) != null && (attrs = sr.getAttributes()) != null && (displayName = attrs.get("displayName")) != null && displayName.get() != null) {
                toReturn = String.valueOf(displayName.get());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to locate displayName", (Throwable)e);
        }
        return toReturn;
    }

    private String generateBaseDN(String username) {
        String[] dcSplit = StringUtils.split((String)this.domainComponent, (String)".");
        String dcList = "";
        for (String part : dcSplit) {
            dcList = dcList + ",DC=" + part;
        }
        String ouList = "";
        for (String part : this.organizationUnits) {
            ouList = ouList + ",OU=" + part;
        }
        String toReturn = ouList + dcList;
        toReturn = toReturn.substring(1);
        return toReturn;
    }

    @Override
    public boolean isUniqueUsername(String username) {
        return true;
    }

    public String getConfFile() {
        return this.confFile;
    }

    public void setConfFile(String conf_file) {
        this.confFile = conf_file;
    }

    public String getKdcServer() {
        return this.kdcServer;
    }

    public void setKdcServer(String kdc_server) {
        this.kdcServer = kdc_server;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String r) {
        this.realm = r;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public void setUserDomain(String userDomain) {
        this.userDomain = userDomain;
    }

    public void setFilterAttributeName(String filterAttributeName) {
        this.filterAttributeName = filterAttributeName;
    }
}

