/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.authenticators;

import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.authenticators.Authenticator;
import com.lunaimaging.insight.core.domain.cache.IntUnboundCache;
import com.lunaimaging.security.IpAddressUsernamePasswordToken;

public abstract class AbstractAuthenticator
implements Authenticator {
    protected Credentials defaultCredentials = null;
    protected int defaultCredentialsId = 1;

    @Override
    public Credentials authenticate(IpAddressUsernamePasswordToken token, IntUnboundCache credentialsCache) {
        String pwd = token.getPassword() != null ? new String(token.getPassword()) : null;
        return this.authenticate(token.getUsername(), pwd, credentialsCache);
    }

    @Override
    public Credentials getDefaultCredentals() {
        return this.defaultCredentials;
    }

    @Override
    public int getDefaultCredentialsId() {
        return this.defaultCredentialsId;
    }

    @Override
    public boolean isUniqueUsername(String username) {
        return true;
    }

    @Override
    public void setDefaultCredentals(Credentials c) {
        this.defaultCredentials = c;
    }

    @Override
    public void setDefaultCredentialsId(int id) {
        this.defaultCredentialsId = id;
    }
}

