/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.annotation;

import com.luna.insight.server.SimpleDate;
import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.logic.InsightFacade;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.MediaCollectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnnotationImporter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected List<MediaCollection> lc = null;
    protected User user = null;
    protected String annotationDirPath1 = null;
    protected String annotationDirPath2 = null;
    protected String annotationDirPath3 = null;
    protected String annotationDirPath4 = null;
    protected String annotationDirPath5 = null;
    protected String annotationDirPath6 = null;
    protected String annotationDirPath7 = null;
    protected String annotationDirPath8 = null;
    protected String mediaListDirPath = null;
    protected String[] supportedExtensions = new String[]{"annotations"};
    private InsightFacade insight = null;
    protected String source = null;
    protected String sourceToDelete = null;
    protected boolean isReplace = true;

    public AnnotationImporter() {
    }

    public AnnotationImporter(List<MediaCollection> lc, String source, User user) {
        this.lc = lc;
        this.source = source;
        this.user = user;
    }

    public void rebuildParentDocs() {
        String[] ext = new String[]{"txt", "csv"};
        if (this.mediaListDirPath != null) {
            Collection files = FileUtils.listFiles((File)new File(this.mediaListDirPath), (String[])ext, (boolean)true);
            for (File mediaListFile : files) {
                this.logger.warn((Object)("Opening file: " + mediaListFile));
                try {
                    List lines = FileUtils.readLines((File)mediaListFile, (String)"UTF-8");
                    for (String line : lines) {
                        String mediaId = StringUtils.trim((String)line);
                        this.logger.warn((Object)("Updating parent doc for media: " + mediaId));
                        this.insight.updateAnnotationParentDoc(mediaId);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int importAnnotations() {
        File doneLckFile;
        File workingLckFile;
        File annotationDir;
        boolean isRunning = false;
        if (this.annotationDirPath1 != null) {
            annotationDir = new File(this.annotationDirPath1);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath2 != null) {
            annotationDir = new File(this.annotationDirPath2);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath3 != null) {
            annotationDir = new File(this.annotationDirPath3);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath4 != null) {
            annotationDir = new File(this.annotationDirPath4);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath5 != null) {
            annotationDir = new File(this.annotationDirPath5);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath6 != null) {
            annotationDir = new File(this.annotationDirPath6);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath7 != null) {
            annotationDir = new File(this.annotationDirPath7);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        if (!isRunning && this.annotationDirPath8 != null) {
            annotationDir = new File(this.annotationDirPath8);
            workingLckFile = new File(annotationDir, ".working");
            doneLckFile = new File(annotationDir, ".done");
            if (!workingLckFile.exists() && !doneLckFile.exists()) {
                isRunning = true;
                return this.importAnnotationBatch(annotationDir);
            }
        }
        return 0;
    }

    public int importAnnotations(File annotationDir) {
        int total = 0;
        ArrayList<String> folderNameList = new ArrayList<String>();
        ArrayList<String> mediaIdsDeleted = new ArrayList<String>();
        if (annotationDir != null) {
            File workingLckFile = new File(annotationDir, ".working");
            try {
                FileUtils.write((File)workingLckFile, (CharSequence)"1");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Collection files = FileUtils.listFiles((File)annotationDir, (String[])this.supportedExtensions, (boolean)true);
            int fileCount = files != null ? files.size() : 0;
            int currentCount = 0;
            this.logger.info((Object)("Total number of annotation list files: " + fileCount));
            for (File annotListFile : files) {
                String folderName = annotListFile.getParentFile().getName();
                if (!folderNameList.contains(folderName)) {
                    folderNameList.add(folderName);
                }
                this.logger.info((Object)("Processing: " + ++currentCount + " of " + fileCount + " file: " + annotListFile.getAbsolutePath() + " visited folders: " + Arrays.toString(folderNameList.toArray())));
                ArrayList<String> mediaIdList = new ArrayList<String>();
                try {
                    FileInputStream fis = new FileInputStream(annotListFile);
                    ArrayList annotList = (ArrayList)SerializationUtils.deserialize((InputStream)fis);
                    if (annotList != null) {
                        long startTime = System.currentTimeMillis();
                        int count = 0;
                        ArrayList<Annotation> processList = new ArrayList<Annotation>();
                        for (Annotation a : annotList) {
                            if (this.isReplace && (StringUtils.isNotBlank((CharSequence)this.sourceToDelete) || StringUtils.isNotBlank((CharSequence)this.source)) && !mediaIdsDeleted.contains(a.getMediaId())) {
                                mediaIdsDeleted.add(a.getMediaId());
                                this.insight.deleteAnnotationsBySource(a.getMediaId(), StringUtils.isNotBlank((CharSequence)this.sourceToDelete) ? this.sourceToDelete : this.source);
                            }
                            String cid = InsightCoreUtils.getCollectionIdFromLunaMediaId(a.getMediaId());
                            if (!mediaIdList.contains(a.getMediaId())) {
                                mediaIdList.add(a.getMediaId());
                            }
                            if (MediaCollectionUtils.getSelectedCollections(this.lc, cid) == null) {
                                this.logger.error((Object)("User not allowed to save this annotation: [MediaId:" + a.getMediaId() + " Text:" + a.getAnnotation() + "]"));
                                continue;
                            }
                            SimpleDate now = new SimpleDate(new Date());
                            a.setModifiedTimestamp(now.toString());
                            if (this.user != null) {
                                a.setUserId(this.user.getId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)this.source)) {
                                a.setSource(this.source);
                            }
                            try {
                                processList.add(a);
                                ++total;
                                if (++count % 1000 == 0) {
                                    this.insight.saveAnnotations(processList, this.user, false, false);
                                    processList.clear();
                                }
                                if (count % 100 != 0) continue;
                                this.logger.info((Object)("Progress: " + count + "/" + annotList.size()));
                            }
                            catch (Exception e) {
                                this.logger.error((Object)("Could not save annotation " + a.getId()), (Throwable)e);
                            }
                        }
                        if (processList.size() > 0) {
                            this.insight.saveAnnotations(processList, this.user, false, false);
                        }
                        this.logger.debug((Object)("   Time to save: " + (System.currentTimeMillis() - startTime) + "ms. Count: " + count));
                    }
                    fis.close();
                    for (String mediaId : mediaIdList) {
                        this.insight.updateAnnotationParentDoc(mediaId);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed processing " + annotListFile.getAbsolutePath()), (Throwable)e);
                }
            }
            FileUtils.deleteQuietly((File)workingLckFile);
            File doneLckFile = new File(annotationDir, ".done");
            try {
                FileUtils.write((File)doneLckFile, (CharSequence)"1");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return total;
    }

    public int importAnnotationBatch(File annotationDir) {
        int total = 0;
        ArrayList<String> folderNameList = new ArrayList<String>();
        if (annotationDir != null) {
            File workingLckFile = new File(annotationDir, ".working");
            try {
                FileUtils.write((File)workingLckFile, (CharSequence)"1");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Collection files = FileUtils.listFiles((File)annotationDir, (String[])this.supportedExtensions, (boolean)true);
            int fileCount = files != null ? files.size() : 0;
            int currentCount = 0;
            this.logger.info((Object)("Total number of annotation list files: " + fileCount));
            for (File annotListFile : files) {
                ArrayList<String> mediaIdList = new ArrayList<String>();
                ArrayList<String> mediaIdsDeleted = new ArrayList<String>();
                String folderName = annotListFile.getParentFile().getName();
                if (!folderNameList.contains(folderName)) {
                    folderNameList.add(folderName);
                }
                this.logger.info((Object)("Processing: " + ++currentCount + " of " + fileCount + " file: " + annotListFile.getAbsolutePath() + " visited folders: " + Arrays.toString(folderNameList.toArray())));
                try {
                    FileInputStream fis = new FileInputStream(annotListFile);
                    ArrayList annotList = (ArrayList)SerializationUtils.deserialize((InputStream)fis);
                    if (annotList != null) {
                        long startTime = System.currentTimeMillis();
                        int count = 0;
                        ArrayList<Annotation> processList = new ArrayList<Annotation>();
                        for (Annotation a : annotList) {
                            if (this.isReplace && (StringUtils.isNotBlank((CharSequence)this.sourceToDelete) || StringUtils.isNotBlank((CharSequence)this.source)) && !mediaIdsDeleted.contains(a.getMediaId())) {
                                mediaIdsDeleted.add(a.getMediaId());
                                this.insight.deleteAnnotationsBySource(a.getMediaId(), StringUtils.isNotBlank((CharSequence)this.sourceToDelete) ? this.sourceToDelete : this.source);
                            }
                            String cid = InsightCoreUtils.getCollectionIdFromLunaMediaId(a.getMediaId());
                            if (!mediaIdList.contains(a.getMediaId())) {
                                mediaIdList.add(a.getMediaId());
                            }
                            if (MediaCollectionUtils.getSelectedCollections(this.lc, cid) == null) {
                                this.logger.error((Object)("User not allowed to save this annotation: [MediaId:" + a.getMediaId() + " Text:" + a.getAnnotation() + "]"));
                                continue;
                            }
                            SimpleDate now = new SimpleDate(new Date());
                            a.setModifiedTimestamp(now.toString());
                            if (this.user != null) {
                                a.setUserId(this.user.getId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)this.source)) {
                                a.setSource(this.source);
                            }
                            try {
                                processList.add(a);
                                ++total;
                                if (++count % 100 != 0) continue;
                                this.logger.info((Object)("Progress: " + count + "/" + annotList.size()));
                            }
                            catch (Exception e) {
                                this.logger.error((Object)("Could not save annotation " + a.getId()), (Throwable)e);
                            }
                        }
                        if (processList.size() > 0) {
                            this.insight.saveAnnotationBatch(processList, (String)mediaIdList.get(0), this.user, false, this.source);
                        }
                        if (mediaIdList.size() > 1) {
                            this.logger.error((Object)"WARNING There are more than 1 media ID in this batch, please check for errors. [[[[[[[[[[[[[[[[[[[[[[[[[[[]]]]]]]]]]]]]]]");
                        }
                        long timeToSave = System.currentTimeMillis() - startTime;
                        if (count > 0) {
                            this.logger.debug((Object)("   Time to save: " + timeToSave + "ms. Count: " + count + " time/count: " + timeToSave / (long)count + "ms"));
                        } else {
                            this.logger.debug((Object)("   Time to save: " + timeToSave + "ms. Count: " + count));
                        }
                    }
                    fis.close();
                    for (String mediaId : mediaIdList) {
                        this.insight.updateAnnotationParentDoc(mediaId);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed processing " + annotListFile.getAbsolutePath()), (Throwable)e);
                }
            }
            FileUtils.deleteQuietly((File)workingLckFile);
            File doneLckFile = new File(annotationDir, ".done");
            try {
                FileUtils.write((File)doneLckFile, (CharSequence)"1");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return total;
    }

    public void setInsight(InsightFacade insight) {
        this.insight = insight;
    }

    public void setSupportedExtensions(String[] supportedExtensions) {
        this.supportedExtensions = supportedExtensions;
    }

    public void setLc(List<MediaCollection> lc) {
        this.lc = lc;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isReplace() {
        return this.isReplace;
    }

    public void setReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public void setAnnotationDirPath1(String annotationDirPath1) {
        this.annotationDirPath1 = annotationDirPath1;
    }

    public void setAnnotationDirPath2(String annotationDirPath2) {
        this.annotationDirPath2 = annotationDirPath2;
    }

    public void setAnnotationDirPath3(String annotationDirPath3) {
        this.annotationDirPath3 = annotationDirPath3;
    }

    public void setAnnotationDirPath4(String annotationDirPath4) {
        this.annotationDirPath4 = annotationDirPath4;
    }

    public void setAnnotationDirPath5(String annotationDirPath5) {
        this.annotationDirPath5 = annotationDirPath5;
    }

    public void setAnnotationDirPath6(String annotationDirPath6) {
        this.annotationDirPath6 = annotationDirPath6;
    }

    public void setAnnotationDirPath7(String annotationDirPath7) {
        this.annotationDirPath7 = annotationDirPath7;
    }

    public void setAnnotationDirPath8(String annotationDirPath8) {
        this.annotationDirPath8 = annotationDirPath8;
    }

    public void setMediaListDirPath(String mediaListDirPath) {
        this.mediaListDirPath = mediaListDirPath;
    }

    public void setSourceToDelete(String sourceToDelete) {
        this.sourceToDelete = sourceToDelete;
    }
}

