/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.Folder;
import com.lunaimaging.insight.core.domain.FolderTree;
import com.lunaimaging.insight.core.domain.IpRange;
import com.lunaimaging.insight.core.domain.MediaCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class User
implements Authenticable,
Serializable {
    protected Log log = LogFactory.getLog(this.getClass());
    protected int id;
    protected int credentialsId;
    protected boolean enabled;
    protected String username;
    protected String password;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected int defaultPageSize;
    protected int defaultThumbnailSize;
    protected int defaultGroupId;
    protected int defaultPresentationId;
    protected boolean domainAuthenticationRequired;
    protected String authenticatorType;
    protected static boolean DOMAIN_AUTHENTICATION_REQUIRED = false;
    protected static String AUTHENTICATOR_TYPE = "";
    protected ArrayList<MediaCollection> mediaCollections;
    protected ArrayList<MediaCollection> defaultMediaCollections;
    protected ArrayList defaultCollectionIds;
    protected Credentials credentials;
    protected Credentials domainCredentials;
    protected Credentials mergedCredentials;
    protected IpRange ipRange;
    protected String displayHelpfulTips;
    protected boolean minimalClientSide = true;
    protected FolderTree folderTree;
    private static final long serialVersionUID = 7L;

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public void setCredentialsId(int credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getDefaultGroupId() {
        return this.defaultGroupId;
    }

    public void setDefaultGroupId(int defaultGroupId) {
        this.defaultGroupId = defaultGroupId;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public int getDefaultPresentationId() {
        return this.defaultPresentationId;
    }

    public void setDefaultPresentationId(int defaultPresentationId) {
        this.defaultPresentationId = defaultPresentationId;
    }

    public int getDefaultThumbnailSize() {
        return this.defaultThumbnailSize;
    }

    public void setDefaultThumbnailSize(int defaultThumbnailSize) {
        this.defaultThumbnailSize = defaultThumbnailSize;
    }

    @Override
    public Credentials getCredentials() {
        if ((this.ipRange != null || this.domainCredentials != null) && this.mergedCredentials != null) {
            return this.mergedCredentials;
        }
        return this.credentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getDomainCredentials() {
        return this.domainCredentials;
    }

    public void setDomainCredentials(Credentials credentials) {
        this.domainCredentials = credentials;
    }

    @Override
    public ArrayList<MediaCollection> getMediaCollections() {
        return this.mediaCollections;
    }

    @Override
    public ArrayList getDefaultCollectionIds() {
        if (this.defaultCollectionIds == null) {
            this.defaultCollectionIds = new ArrayList(0);
        }
        return this.defaultCollectionIds;
    }

    @Override
    public void setDefaultCollectionIds(ArrayList defaultCollectionIds) {
        this.defaultCollectionIds = defaultCollectionIds;
    }

    @Override
    public void setMediaCollections(ArrayList<MediaCollection> mediaCollections) {
        this.mediaCollections = mediaCollections;
    }

    @Override
    public ArrayList<MediaCollection> getDefaultMediaCollections() {
        return this.defaultMediaCollections;
    }

    @Override
    public void setDefaultMediaCollections(ArrayList<MediaCollection> defaultMediaCollections) {
        this.defaultMediaCollections = defaultMediaCollections;
    }

    public String toString() {
        return "User[" + this.id + "]: " + StringUtils.defaultIfEmpty((String)this.username, (String)"");
    }

    public IpRange getIpRange() {
        return this.ipRange;
    }

    public void setIpRange(IpRange ipRange) {
        this.ipRange = ipRange;
    }

    public Credentials getMergedCredentials() {
        return this.mergedCredentials;
    }

    public void setMergedCredentials(Credentials mergedCredentials) {
        this.mergedCredentials = mergedCredentials;
    }

    public List<Folder> getFolders() {
        return this.getFolderTree().getFolders();
    }

    public void setFolders(List<Folder> folders) {
        this.getFolderTree().setFolders(folders);
    }

    public FolderTree getFolderTree() {
        if (this.folderTree == null) {
            this.folderTree = new FolderTree();
        }
        return this.folderTree;
    }

    public void setFolderTree(FolderTree folderTree) {
        this.folderTree = folderTree;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        Boolean bool = new Boolean(enabled);
        this.enabled = bool.equals(null) || bool.equals(true);
    }

    @Override
    public boolean isMinimalClientSide() {
        return this.minimalClientSide;
    }

    @Override
    public void setMinimalClientSide(boolean minimalClientSide) {
        Boolean bool = new Boolean(minimalClientSide);
        this.minimalClientSide = bool.equals(null) || bool.equals(true);
    }

    public String getDisplayHelpfulTips() {
        return this.displayHelpfulTips;
    }

    public void setDisplayHelpfulTips(String displayHelpfulTips) {
        this.displayHelpfulTips = displayHelpfulTips;
    }

    public String getAuthenticatorType() {
        return AUTHENTICATOR_TYPE;
    }

    public void setAuthenticatorType(String s) {
        this.authenticatorType = AUTHENTICATOR_TYPE;
    }

    public boolean isDomainAuthenticationRequired() {
        return DOMAIN_AUTHENTICATION_REQUIRED;
    }

    public void setDomainAuthenticationRequired(boolean b) {
        this.domainAuthenticationRequired = DOMAIN_AUTHENTICATION_REQUIRED;
    }
}

