/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class StructuredData {
    private String contentUrl;
    private String creator;
    private String creditText;
    private String copyrightNotice;
    private String license;
    private HashSet<String> fieldNames;
    private HashMap<String, String> fieldValueMap;

    public StructuredData(Media media) {
        this.contentUrl = media.getUrlSize4();
        if (media.getFieldValues() != null && media instanceof LunaMedia) {
            for (MediaFieldValue mfv : ((LunaMedia)media).getFieldValues()) {
                if (mfv == null || mfv.getField() == null || mfv.getField().getFieldName() == null || mfv.getValue() == null) continue;
                String name = mfv.getField().getFieldName();
                String value = String.valueOf(mfv.getValue());
                if (this.fieldNames == null) {
                    this.fieldNames = new HashSet();
                }
                if (StringUtils.isNotBlank((String)name)) {
                    this.fieldNames.add(name);
                }
                if (this.fieldValueMap == null) {
                    this.fieldValueMap = new HashMap();
                }
                this.fieldValueMap.put(name, value);
            }
            if (this.fieldNames != null && !this.fieldNames.isEmpty()) {
                if (this.fieldNames.contains("creator")) {
                    this.creator = this.fieldValueMap.get("creator");
                }
                if (this.fieldNames.contains("creditText")) {
                    this.creditText = this.fieldValueMap.get("creditText");
                }
                if (this.fieldNames.contains("copyrightNotice")) {
                    this.copyrightNotice = this.fieldValueMap.get("copyrightNotice");
                }
                if (this.fieldNames.contains("license")) {
                    this.license = this.fieldValueMap.get("license");
                }
                for (String fieldName : this.fieldNames) {
                    if (this.creator == null) {
                        if (StringUtils.containsIgnoreCase((String)fieldName, (String)"creator")) {
                            this.creator = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"author")) {
                            this.creator = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"artist")) {
                            this.creator = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"painter")) {
                            this.creator = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"maker")) {
                            this.creator = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"agent")) {
                            this.creator = this.fieldValueMap.get(fieldName);
                        }
                    }
                    if (this.creditText == null) {
                        if (StringUtils.containsIgnoreCase((String)fieldName, (String)"creditText")) {
                            this.creditText = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"credit")) {
                            this.creditText = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"credits")) {
                            this.creditText = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"attributor")) {
                            this.creditText = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"attribution")) {
                            this.creditText = this.fieldValueMap.get(fieldName);
                        }
                    }
                    if (this.copyrightNotice == null) {
                        if (StringUtils.containsIgnoreCase((String)fieldName, (String)"copyrightNotice")) {
                            this.copyrightNotice = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"copyright")) {
                            this.copyrightNotice = this.fieldValueMap.get(fieldName);
                        } else if (StringUtils.containsIgnoreCase((String)fieldName, (String)"rights")) {
                            this.copyrightNotice = this.fieldValueMap.get(fieldName);
                        }
                    }
                    if (this.license != null) continue;
                    if (StringUtils.containsIgnoreCase((String)fieldName, (String)"license") && this.isValidUrl(this.fieldValueMap.get(fieldName))) {
                        this.license = this.fieldValueMap.get(fieldName);
                        continue;
                    }
                    if (!StringUtils.containsIgnoreCase((String)fieldName, (String)"licenses") || !this.isValidUrl(this.fieldValueMap.get(fieldName))) continue;
                    this.license = this.fieldValueMap.get(fieldName);
                }
            }
        }
    }

    private boolean isValidUrl(String urlString) {
        return urlString.matches("^(https?|ftp)://[^\\s/$.?#].[^\\s]*$");
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreditText() {
        return this.creditText;
    }

    public void setCreditText(String creditText) {
        this.creditText = creditText;
    }

    public String getCopyrightNotice() {
        return this.copyrightNotice;
    }

    public void setCopyrightNotice(String copyrightNotice) {
        this.copyrightNotice = copyrightNotice;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }
}

