/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.SlideImage;
import com.lunaimaging.insight.core.domain.SlideMedia;
import com.lunaimaging.insight.core.utils.SlideUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlideImageState {
    protected static final Log log = LogFactory.getLog(SlideImageState.class);
    protected SlideMedia slideImage;
    protected Dimension canvasDimensions = new Dimension();
    protected Point position = new Point();
    protected Dimension panelDimensions = new Dimension();
    protected Point2D.Double scaleFactor = new Point2D.Double();
    protected Point centerPoint = new Point();
    protected Dimension actualImageSize = new Dimension();
    protected int stackOrder;
    protected int level;

    public SlideImageState() {
    }

    public SlideImageState(SlideImage slideImage, int canvasWidth, int canvasHeight) {
        this();
        this.deriveState(slideImage, canvasWidth, canvasHeight);
    }

    public void deriveState(SlideImage slideImage, int canvasWidth, int canvasHeight) {
        this.reset();
        if (slideImage != null && canvasWidth > 0 && canvasHeight > 0) {
            this.slideImage = slideImage;
            this.canvasDimensions.width = canvasWidth;
            this.canvasDimensions.height = canvasHeight;
            this.stackOrder = slideImage.getStackOrder();
            this.position.x = (int)Math.round((double)slideImage.getPositionX() / (double)slideImage.workspaceWidth * (double)canvasWidth);
            this.position.y = (int)Math.round((double)slideImage.getPositionY() / (double)slideImage.workspaceHeight * (double)canvasHeight);
            this.panelDimensions.width = (int)Math.round((double)slideImage.panelWidth / (double)slideImage.workspaceWidth * (double)canvasWidth);
            this.panelDimensions.height = (int)Math.round((double)slideImage.panelHeight / (double)slideImage.workspaceHeight * (double)canvasHeight);
            this.actualImageSize.width = (int)Math.round((double)slideImage.actualImageSizeWidth / (double)slideImage.workspaceWidth * (double)canvasWidth);
            this.actualImageSize.height = (int)Math.round((double)slideImage.actualImageSizeHeight / (double)slideImage.workspaceHeight * (double)canvasHeight);
            this.centerPoint.x = (int)Math.round((double)slideImage.centerPointX / (double)slideImage.actualImageSizeWidth * (double)this.actualImageSize.width);
            this.centerPoint.y = (int)Math.round((double)slideImage.centerPointY / (double)slideImage.actualImageSizeHeight * (double)this.actualImageSize.height);
            if (slideImage.getMedia() instanceof LunaMedia && ((LunaMedia)slideImage.getMedia()).getMaxLevel() > 4 && ((LunaMedia)slideImage.getMedia()).getMaxWidth() > 0 && ((LunaMedia)slideImage.getMedia()).getMaxHeight() > 0) {
                LunaMedia media = (LunaMedia)slideImage.getMedia();
                double ais = this.actualImageSize.width;
                double longSide = media.getMaxWidth();
                if (media.getMaxHeight() > media.getMaxWidth()) {
                    ais = this.actualImageSize.height;
                    longSide = media.getMaxHeight();
                }
                this.level = (int)Math.round(Math.log(2.0) * Math.log(longSide / ais));
                this.scaleFactor.x = (double)this.actualImageSize.width * Math.pow(2.0, this.level) / (double)media.getMaxWidth();
                this.scaleFactor.y = (double)this.actualImageSize.height * Math.pow(2.0, this.level) / (double)media.getMaxHeight();
            } else {
                try {
                    Media media = slideImage.getMedia();
                    String url = media.getUrlSize4();
                    if (StringUtils.isEmpty((String)url)) {
                        url = media.getLargestUrlAvailable();
                    }
                    BufferedImage image = ImageIO.read(new URL(url));
                    Dimension baseRatio = SlideUtils.calculateExternalMediaBaseRatio(image.getWidth(), image.getHeight());
                    double ais = this.actualImageSize.width;
                    double longSide = baseRatio.width;
                    if (baseRatio.height > baseRatio.width) {
                        ais = this.actualImageSize.height;
                        longSide = baseRatio.height;
                    }
                    this.level = (int)Math.round(Math.log(2.0) * Math.log(longSide / ais));
                    this.scaleFactor.x = (double)this.actualImageSize.width * Math.pow(2.0, this.level) / (double)baseRatio.width;
                    this.scaleFactor.y = (double)this.actualImageSize.height * Math.pow(2.0, this.level) / (double)baseRatio.height;
                }
                catch (Exception e) {
                    log.debug((Object)"deriveState: ", (Throwable)e);
                }
            }
        }
    }

    public void reset() {
        this.slideImage = null;
        this.canvasDimensions.width = 0;
        this.canvasDimensions.height = 0;
        this.position.x = 0;
        this.position.y = 0;
        this.panelDimensions.width = 0;
        this.panelDimensions.height = 0;
        this.scaleFactor.x = 0.0;
        this.scaleFactor.y = 0.0;
        this.centerPoint.x = 0;
        this.centerPoint.y = 0;
        this.level = -1;
    }

    public Dimension getCanvasDimensions() {
        return this.canvasDimensions;
    }

    public void setCanvasDimensions(Dimension canvasDimensions) {
        this.canvasDimensions = canvasDimensions;
    }

    public Dimension getPanelDimensions() {
        return this.panelDimensions;
    }

    public void setPanelDimensions(Dimension dimensions) {
        this.panelDimensions = dimensions;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point pan) {
        this.centerPoint = pan;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Point2D.Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Point2D.Double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public SlideMedia getSlideImage() {
        return this.slideImage;
    }

    public void setSlideImage(SlideMedia slideImage) {
        this.slideImage = slideImage;
    }

    public Dimension getActualImageSize() {
        return this.actualImageSize;
    }

    public void setActualImageSize(Dimension actualImageSize) {
        this.actualImageSize = actualImageSize;
    }

    public int getStackOrder() {
        return this.stackOrder;
    }

    public void setStackOrder(int stackOrder) {
        this.stackOrder = stackOrder;
    }
}

