/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.Displayable;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.springframework.dao.DataRetrievalFailureException;

public class MediaGroup
implements Displayable,
Serializable {
    private int id;
    private int userId;
    private String username;
    private int folderId;
    private String displayName;
    private String password;
    private String description;
    private boolean publiclyViewable;
    private ArrayList mediaIds;
    private ArrayList mediaSequences;
    private static final long serialVersionUID = 70000L;

    public void moveMedia(String sourceId, String targetId) throws DataRetrievalFailureException {
        if (this.mediaIds.contains(sourceId) && (this.mediaIds.contains(targetId) || targetId == null)) {
            this.mediaIds.remove(sourceId);
            int insertIndex = targetId == null ? 0 : 1 + this.mediaIds.lastIndexOf(targetId);
            this.mediaIds.add(insertIndex, sourceId);
            return;
        }
        throw new DataRetrievalFailureException("PublisherMedia Not Moved");
    }

    public void removeMedia(List removeMediaIds) {
        for (Object id : removeMediaIds) {
            this.mediaIds.remove(id);
        }
    }

    public List<String> getMediaGroupMediaIdsByCollectionId(String collectionId) {
        Iterator iter = this.mediaIds.iterator();
        ArrayList<String> toReturn = new ArrayList<String>();
        while (iter.hasNext()) {
            Object mediaId = iter.next();
            if (!InsightCoreUtils.getCollectionIdFromLunaMediaId((String)mediaId).equals(collectionId)) continue;
            toReturn.add((String)mediaId);
        }
        return toReturn;
    }

    public void removeMedia(Object removeMediaId) {
        ArrayList removeMediaIds = new ArrayList();
        this.mediaIds.add(removeMediaId);
        this.removeMedia(removeMediaIds);
    }

    public void addMedia(List addMediaIds) {
        for (Object obj : addMediaIds) {
            this.addMedia(obj);
        }
    }

    public void addMedia(Object mediaId) {
        if (!this.mediaIds.contains(mediaId)) {
            this.mediaIds.add(mediaId);
        }
    }

    public void sortMediaIds() {
        TreeMap sortedMediaIds = new TreeMap();
        for (int i = 0; i < this.mediaSequences.size(); ++i) {
            sortedMediaIds.put(this.mediaSequences.get(i), this.mediaIds.get(i));
        }
        this.mediaIds = new ArrayList(sortedMediaIds.values());
    }

    public void setSortedMediaIds(ArrayList mediaIds) {
        this.mediaIds = mediaIds;
    }

    public void setMediaIds(ArrayList mediaIds) {
        this.mediaIds = mediaIds;
        if (this.mediaSequences != null) {
            this.sortMediaIds();
        }
    }

    public ArrayList getMediaIds() {
        if (this.mediaIds == null) {
            this.mediaIds = new ArrayList(0);
        }
        return this.mediaIds;
    }

    public ArrayList getMediaSequences() {
        ArrayList<Integer> sequences = new ArrayList<Integer>();
        if (this.mediaIds != null) {
            for (int i = 0; i < this.mediaIds.size(); ++i) {
                sequences.add(i);
            }
        }
        return sequences;
    }

    public void setMediaSequences(ArrayList mediaSequences) {
        this.mediaSequences = mediaSequences;
        if (this.mediaIds != null) {
            this.sortMediaIds();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public void setFolderId(int folderId) {
        this.folderId = folderId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPubliclyViewable() {
        return this.publiclyViewable;
    }

    public void setPubliclyViewable(boolean publiclyViewable) {
        this.publiclyViewable = publiclyViewable;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return "PublisherMedia Group[" + this.id + "]: " + this.displayName;
    }
}

