/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.MediaField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MediaFieldValue
implements Comparable<MediaFieldValue>,
Serializable {
    private static final long serialVersionUID = 4685703108481881518L;
    protected Object value;
    protected MediaField field;
    protected boolean isMetaData;
    protected List<Object> valueList = null;

    public MediaFieldValue(MediaField field, Object value) {
        this.setField(field);
        this.setValue(value);
        this.valueList = new ArrayList<Object>();
        if (value instanceof List) {
            this.valueList.addAll((List)value);
        } else {
            this.valueList.add(value);
        }
    }

    public MediaFieldValue(Object value) {
        this(null, value);
    }

    public MediaFieldValue() {
        this(null);
    }

    public MediaField getField() {
        return this.field;
    }

    public void setField(MediaField field) {
        this.field = field;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isMetaData() {
        return this.isMetaData;
    }

    public void setMetaData(boolean isMetaData) {
        this.isMetaData = isMetaData;
    }

    @Override
    public int compareTo(MediaFieldValue obj) {
        if (obj instanceof MediaFieldValue) {
            int order = obj.getField().getDisplayOrder();
            if (order == this.getField().getDisplayOrder()) {
                boolean isMetaData = obj.isMetaData();
                if (!isMetaData && this.isMetaData) {
                    return -1;
                }
                if (isMetaData && !this.isMetaData) {
                    return 1;
                }
            } else {
                if (order < this.getField().getDisplayOrder()) {
                    return 1;
                }
                if (order > this.getField().getDisplayOrder()) {
                    return -1;
                }
            }
        }
        return 0;
    }

    public int getPreviewFieldSort() {
        if (this.field != null) {
            return this.field.getPreviewFieldSort();
        }
        return 0;
    }

    public int getSummaryDescriptionFieldSort() {
        if (this.field != null) {
            return this.field.getSummaryDescriptionFieldSort();
        }
        return 0;
    }

    public List<Object> getValueList() {
        return this.valueList;
    }

    public void addToValueList(Object v) {
        this.valueList.add(v);
    }
}

