/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MediaField
implements Comparable<MediaField>,
Serializable {
    private static final long serialVersionUID = 3L;
    protected String institutionId;
    protected int uniqueCollectionId;
    protected int collectionId;
    protected int fieldId;
    protected int fieldType;
    protected String fieldName;
    protected String displayName;
    protected String parentName;
    protected String w4Type;
    protected boolean sortable;
    protected boolean searchable;
    protected boolean previewField;
    protected boolean summaryDescriptionField;
    protected int displayOrder;
    protected boolean dateField;
    protected boolean defaultDateField;
    protected boolean isDisplayTitleField;
    protected boolean isRelatedItemField;
    protected boolean isFacetField;
    protected boolean isFacetAlphaSorted;
    protected boolean expandableString = false;
    protected fieldGroupType fieldGrp = fieldGroupType.DEFAULT;
    protected int summaryDescriptionFieldSort;
    protected int previewFieldSort;
    protected int defaultCollectionSort;
    protected int facetFieldOrder = -1;
    protected String facetCustomName;
    protected boolean isRequired = false;
    protected boolean isMultivalued = false;
    protected int maxValueLength = 255;
    protected int minValueLength = 0;
    protected String fieldRef = null;

    public MediaField(int id, int type, String name, String displayName, int displayOrder) {
        this(id, type, name, displayName, displayOrder, null);
    }

    public MediaField(int id, int type, String name, String displayName, int displayOrder, String parentName) {
        this.setFieldId(id);
        this.setFieldType(type);
        this.setFieldName(name);
        this.setDisplayName(displayName);
        this.setDisplayOrder(displayOrder);
        this.setParentName(parentName);
    }

    public MediaField(int id, int type, String name, String displayName, int displayOrder, String parentName, fieldGroupType fieldGrp) {
        this(id, type, name, displayName, displayOrder, parentName);
        this.fieldGrp = fieldGrp;
    }

    @JsonIgnore
    public fieldGroupType getFieldGrp() {
        return this.fieldGrp;
    }

    @JsonIgnore
    public String getFieldGrpString() {
        return this.fieldGrp.toString();
    }

    public void setFieldGrp(fieldGroupType fieldGrp) {
        this.fieldGrp = fieldGrp;
    }

    @JsonIgnore
    public boolean isDefaultFldGrp() {
        return this.fieldGrp == fieldGroupType.DEFAULT;
    }

    public MediaField() {
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public int getUniqueCollectionId() {
        return this.uniqueCollectionId;
    }

    public void setUniqueCollectionId(int uniqueCollectionId) {
        this.uniqueCollectionId = uniqueCollectionId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof MediaField && StringUtils.equalsIgnoreCase((String)this.fieldName, (String)((MediaField)o).fieldName) && StringUtils.equalsIgnoreCase((String)InsightCoreUtils.getCollectionIdFromMediaField(this), (String)InsightCoreUtils.getCollectionIdFromMediaField((MediaField)o));
    }

    public String getW4Type() {
        return this.w4Type;
    }

    public void setW4Type(String w4Type) {
        this.w4Type = w4Type;
    }

    public void String(String type) {
        this.w4Type = type;
    }

    @JsonIgnore
    public W4Type getType() {
        try {
            return W4Type.valueOf(this.w4Type);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean isDateField() {
        return this.dateField;
    }

    public void setDateField(boolean date) {
        this.dateField = date;
    }

    public String toString() {
        return "MediaField[" + this.fieldId + "]:" + StringUtils.defaultIfEmpty((String)this.displayName, (String)"");
    }

    public boolean isPreviewField() {
        return this.previewField;
    }

    public void setPreviewField(boolean previewField) {
        this.previewField = previewField;
    }

    public boolean isSummaryDescriptionField() {
        return this.summaryDescriptionField;
    }

    public void setSummaryDescriptionField(boolean summaryDescriptionField) {
        this.summaryDescriptionField = summaryDescriptionField;
    }

    public boolean isDisplayTitleField() {
        return this.isDisplayTitleField;
    }

    public void setDisplayTitleField(boolean isDisplayTitleField) {
        this.isDisplayTitleField = isDisplayTitleField;
    }

    public int getPreviewFieldSort() {
        return this.previewFieldSort;
    }

    public void setPreviewFieldSort(int previewFieldSort) {
        this.previewFieldSort = previewFieldSort;
    }

    public int getSummaryDescriptionFieldSort() {
        return this.summaryDescriptionFieldSort;
    }

    public void setSummaryDescriptionFieldSort(int summaryDescriptionFieldSort) {
        this.summaryDescriptionFieldSort = summaryDescriptionFieldSort;
    }

    public int getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(int collectionId) {
        this.collectionId = collectionId;
    }

    public int getDefaultCollectionSort() {
        return this.defaultCollectionSort;
    }

    public void setDefaultCollectionSort(int defaultCollectionSort) {
        this.defaultCollectionSort = defaultCollectionSort;
    }

    @Override
    public int compareTo(MediaField o) {
        return this.defaultCollectionSort - o.defaultCollectionSort;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getFieldRef() {
        return this.fieldRef;
    }

    public void setFieldRef(String ref) {
        this.fieldRef = ref;
    }

    public boolean getRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean b) {
        this.isRequired = b;
    }

    public int getMaxValueLength() {
        return this.maxValueLength;
    }

    public void setMaxValueLength(int i) {
        this.maxValueLength = i;
    }

    @JsonIgnore
    public boolean isExpandableString() {
        return this.expandableString;
    }

    public void setExpandableString(boolean isExpandableString) {
        this.expandableString = isExpandableString;
    }

    public boolean getMultivalued() {
        return this.isMultivalued;
    }

    public void setMultivalued(boolean isMultivalued) {
        this.isMultivalued = isMultivalued;
    }

    public boolean isRelatedItemField() {
        return this.isRelatedItemField;
    }

    public void setRelatedItemField(boolean isRelatedItemField) {
        this.isRelatedItemField = isRelatedItemField;
    }

    public boolean isFacetField() {
        return this.isFacetField;
    }

    public void setFacetField(boolean isFacetField) {
        this.isFacetField = isFacetField;
    }

    public int getFacetFieldOrder() {
        return this.facetFieldOrder;
    }

    public void setFacetFieldOrder(int facetFieldOrder) {
        this.facetFieldOrder = facetFieldOrder;
    }

    public String getFacetCustomName() {
        return this.facetCustomName;
    }

    public void setFacetCustomName(String facetCustomName) {
        this.facetCustomName = facetCustomName;
    }

    public boolean isFacetAlphaSorted() {
        return this.isFacetAlphaSorted;
    }

    public void setFacetAlphaSorted(boolean isFacetAlphaSorted) {
        this.isFacetAlphaSorted = isFacetAlphaSorted;
    }

    public boolean isDefaultDateField() {
        return this.defaultDateField;
    }

    public void setDefaultDateField(boolean defaultDateField) {
        this.defaultDateField = defaultDateField;
    }

    public static enum W4Type {
        WHO,
        WHAT,
        WHERE,
        WHEN;


        public String getDisplayName() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }

    public static enum fieldGroupType {
        MEDIA_CUSTOM,
        MEDIA_EXIF,
        MEDIA_XMP,
        MEDIA_IPTC,
        DEFAULT;


        public String toString() {
            switch (this) {
                case MEDIA_CUSTOM: {
                    return "custom";
                }
                case MEDIA_EXIF: {
                    return "exif";
                }
                case MEDIA_IPTC: {
                    return "iptc";
                }
                case MEDIA_XMP: {
                    return "xmp";
                }
            }
            return "default";
        }
    }
}

