/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.lunaimaging.insight.core.domain.ExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.MediaField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.util.CollectionUtils;

@XmlRootElement(name="mediaCollection")
@JsonIgnoreProperties(ignoreUnknown=true)
public class MediaCollection
implements Serializable {
    protected String id;
    protected int serverId;
    protected int uniqueCollectionId;
    protected String vcId;
    protected String institutionId;
    protected int serverPort;
    protected String serverAddress;
    protected int type;
    protected int sortOrder;
    protected int userCollection;
    protected int profileId;
    protected int userId;
    protected String userName;
    protected String groupName;
    protected String groupKeyCode;
    protected int groupProfileId;
    protected String collectionId;
    protected String standardName;
    protected String abbreviatedName;
    protected String collectionName;
    protected String shortDescription;
    protected String copyrightStatement;
    protected String languageCode;
    protected String countryCode;
    protected boolean virtualCollection;
    protected boolean medeEnabled;
    protected boolean publicCollection;
    protected boolean shared;
    protected String sessionCodeKey;
    protected String sessionGroupName;
    protected ExtendedCollectionProperties extendedCollectionProperties;
    protected List<MediaField> mediaFields;
    protected List<MediaField> w4MediaFields;
    protected List<MediaField> previewMediaFields;
    protected List<MediaField> summaryDescriptionMediaFields;
    protected List<MediaField> defaultCollectionSortFields;
    protected List<MediaField> relatedItemMediaFields;
    protected List<MediaField> facetMediaFields;
    protected List<MediaField> dateFields;
    protected String collectionType = CollectionType.legacy.toString();
    public static final int DEFAULT_COLLECTION_ID = 0;
    public static final String DEFAULT_LUNA_COLLECTION_ID = "DEFAULT~0~0";
    protected int totalMediaCount;
    private static final long serialVersionUID = 70000L;

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public List<MediaField> getDefaultCollectionSortFields() {
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.defaultCollectionSortFields)) {
            this.defaultCollectionSortFields = new ArrayList<MediaField>();
            for (MediaField mf : this.mediaFields) {
                if (mf.getDefaultCollectionSort() <= 0) continue;
                this.defaultCollectionSortFields.add(mf);
            }
            if (this.defaultCollectionSortFields.size() > 0) {
                Collections.sort(this.defaultCollectionSortFields);
            }
        }
        return this.defaultCollectionSortFields;
    }

    public List<MediaField> getDefaultCollectionSortFields(int size) {
        List<MediaField> list = null;
        List<MediaField> temp = this.getDefaultCollectionSortFields();
        if (temp != null) {
            list = size <= temp.size() ? temp.subList(0, size) : temp;
        }
        return list;
    }

    public void setDefaultCollectionSortFields(List<MediaField> mfs) {
        this.defaultCollectionSortFields = mfs;
    }

    public List<MediaField> getW4MediaFields() {
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.w4MediaFields)) {
            this.w4MediaFields = new ArrayList<MediaField>();
            for (MediaField mf : this.mediaFields) {
                if (mf.getW4Type() == null) continue;
                this.w4MediaFields.add(mf);
            }
        }
        return this.w4MediaFields;
    }

    public void setW4MediaFields(List<MediaField> mfs) {
        this.w4MediaFields = mfs;
    }

    public List<MediaField> getPreviewMediaFields() {
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.previewMediaFields)) {
            this.previewMediaFields = new ArrayList<MediaField>();
            for (MediaField mf : this.mediaFields) {
                if (!mf.isPreviewField()) continue;
                this.previewMediaFields.add(mf);
            }
        }
        return this.previewMediaFields;
    }

    public void setPreviewMediaFields(List<MediaField> mfs) {
        this.previewMediaFields = mfs;
    }

    public List<MediaField> getSummaryDescriptionMediaFields() {
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.summaryDescriptionMediaFields)) {
            this.summaryDescriptionMediaFields = new ArrayList<MediaField>();
            for (MediaField mf : this.mediaFields) {
                if (!mf.isSummaryDescriptionField()) continue;
                this.summaryDescriptionMediaFields.add(mf);
            }
        }
        return this.summaryDescriptionMediaFields;
    }

    public void setSummaryDescriptionMediaFields(List<MediaField> mfs) {
        this.summaryDescriptionMediaFields = mfs;
    }

    public List<MediaField> getRelatedItemMediaFields() {
        if (this.relatedItemMediaFields == null) {
            this.relatedItemMediaFields = new ArrayList<MediaField>();
        }
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.relatedItemMediaFields)) {
            for (MediaField mf : this.mediaFields) {
                if (!mf.isRelatedItemField()) continue;
                this.relatedItemMediaFields.add(mf);
            }
        }
        return this.relatedItemMediaFields;
    }

    public void setRelatedItemFields(List<MediaField> mfs) {
        this.relatedItemMediaFields = mfs;
    }

    public List<MediaField> getFacetMediaFields() {
        if (this.facetMediaFields == null) {
            this.facetMediaFields = new ArrayList<MediaField>();
        }
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.facetMediaFields)) {
            for (MediaField mf : this.mediaFields) {
                if (!mf.isFacetField()) continue;
                this.facetMediaFields.add(mf);
            }
        }
        return this.facetMediaFields;
    }

    public void setFacetFields(List<MediaField> mfs) {
        this.facetMediaFields = mfs;
    }

    public List<MediaField> getMediaFields() {
        return this.mediaFields;
    }

    public List<MediaField> getInsightMediaFields() {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (this.mediaFields != null) {
            for (MediaField mf : this.mediaFields) {
                if (mf.getDisplayName() == null || mf.getFieldName() == null || mf.getDisplayName().startsWith("_") || mf.getFieldName().startsWith("_")) continue;
                toReturn.add(mf);
            }
        }
        return toReturn;
    }

    public void setMediaFields(List<MediaField> mediaFields) {
        this.mediaFields = mediaFields;
    }

    public String getStandardName() {
        return this.standardName;
    }

    public void setStandardName(String standardName) {
        this.standardName = standardName;
    }

    public int getGroupProfileId() {
        return this.groupProfileId;
    }

    public void setGroupProfileId(int groupProfileId) {
        this.groupProfileId = groupProfileId;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }

    public void setAbbreviatedName(String abbreviatedName) {
        this.abbreviatedName = abbreviatedName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCopyrightStatement() {
        return this.copyrightStatement;
    }

    public void setCopyrightStatement(String copyrightStatement) {
        this.copyrightStatement = copyrightStatement;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public ExtendedCollectionProperties getExtendedCollectionProperties() {
        return this.extendedCollectionProperties;
    }

    public void setExtendedCollectionProperties(ExtendedCollectionProperties extendedCollectionProperties) {
        this.extendedCollectionProperties = extendedCollectionProperties;
    }

    public String getGroupKeyCode() {
        return this.groupKeyCode;
    }

    public void setGroupKeyCode(String groupKeyCode) {
        this.groupKeyCode = groupKeyCode;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public boolean isMedeEnabled() {
        return this.medeEnabled;
    }

    public void setMedeEnabled(boolean medeEnabled) {
        this.medeEnabled = medeEnabled;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getUniqueCollectionId() {
        return this.uniqueCollectionId;
    }

    public void setUniqueCollectionId(int uniqueCollectionId) {
        this.uniqueCollectionId = uniqueCollectionId;
    }

    public String getVcId() {
        return this.vcId;
    }

    public void setVcId(String vcId) {
        this.vcId = vcId;
    }

    public boolean isVirtualCollection() {
        return this.virtualCollection;
    }

    public void setVirtualCollection(boolean virtualCollection) {
        this.virtualCollection = virtualCollection;
    }

    public String toString() {
        return "MediaCollection[" + this.id + "]" + this.getCollectionName();
    }

    public boolean isPublicCollection() {
        return this.publicCollection;
    }

    public void setPublicCollection(boolean publicCollection) {
        this.publicCollection = publicCollection;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public void setProfileId(int profileId) {
        this.profileId = profileId;
    }

    public int getUserCollection() {
        return this.userCollection;
    }

    public void setUserCollection(int userCollection) {
        this.userCollection = userCollection;
    }

    public String getSessionCodeKey() {
        return this.sessionCodeKey;
    }

    public void setSessionCodeKey(String sessionCodeKey) {
        this.sessionCodeKey = sessionCodeKey;
    }

    public String getSessionGroupName() {
        return this.sessionGroupName;
    }

    public void setSessionGroupName(String sessionGroupName) {
        this.sessionGroupName = sessionGroupName;
    }

    public int getTotalMediaCount() {
        return this.totalMediaCount;
    }

    public void setTotalMediaCount(int totalMediaCount) {
        this.totalMediaCount = totalMediaCount;
    }

    public boolean equals(Object o) {
        if (o instanceof MediaCollection) {
            MediaCollection mc = (MediaCollection)o;
            if (this.id != null && this.id.equalsIgnoreCase(mc.id)) {
                return true;
            }
        }
        return false;
    }

    public List<MediaField> getDateFields() {
        if (this.dateFields == null) {
            this.dateFields = new ArrayList<MediaField>();
        }
        if (this.mediaFields != null && CollectionUtils.isEmpty(this.dateFields)) {
            for (MediaField mf : this.mediaFields) {
                if (!mf.isDateField()) continue;
                this.dateFields.add(mf);
            }
        }
        return this.dateFields;
    }

    public void setDateFields(List<MediaField> dateFields) {
        this.dateFields = dateFields;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public static enum CollectionType {
        legacy,
        distribution,
        lunaLibrary;

    }
}

