/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.domain.search.MediaResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class Media
implements MediaResult,
Serializable {
    private static final long serialVersionUID = 760834387943952553L;
    public static final int STATUS_INDEX_PENDING = 1;
    public static final int STATUS_INDEX_RECORD_COLLECTION_MANAGER_FAILURE = 3;
    public static final int STATUS_INDEX_RECORD_COLLECTED = 5;
    public static final int STATUS_INDEX_RECORD_ARCHIVED = 6;
    public static final int STATUS_INDEX_ERROR_DOCUMENT = 9;
    public static final int STATUS_INDEXED = 10;
    protected String uniqueCollectionId;
    protected int mediaId;
    protected String urlSize0;
    protected String urlSize1;
    protected String urlSize2;
    protected String urlSize3;
    protected String urlSize4;
    protected String urlSize5;
    protected String urlSize6;
    protected String urlSize7;
    protected String urlSize8;
    protected String uri;
    protected String displayTitle;
    protected String mediaType;
    protected MediaType type;
    protected List<String> fullImageUrls;
    protected int recache = 0;
    protected int status = 1;
    protected boolean indexInitiated = false;
    protected List<MediaFieldValue> fieldValues;
    protected int sourceMediaGroupId = -1;
    private String mediaFormat;

    public String getUniqueCollectionId() {
        return this.uniqueCollectionId;
    }

    public void setUniqueCollectionId(String collectionId) {
        this.uniqueCollectionId = collectionId;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(String title) {
        this.displayTitle = title;
    }

    public int getMediaId() {
        return this.mediaId;
    }

    public int getSourceMediaGroupId() {
        return this.sourceMediaGroupId;
    }

    public void setMediaId(int mediaId) {
        this.mediaId = mediaId;
    }

    public void setSourceMediaGroupId(int mgid) {
        this.sourceMediaGroupId = mgid;
    }

    @Override
    public String getUrlSize0() {
        return this.urlSize0;
    }

    public void setUrlSize0(String urlSize0) {
        this.urlSize0 = urlSize0;
    }

    @Override
    public String getUrlSize1() {
        return this.urlSize1;
    }

    public void setUrlSize1(String urlSize1) {
        this.urlSize1 = urlSize1;
    }

    @Override
    public String getUrlSize2() {
        return this.urlSize2;
    }

    public void setUrlSize2(String urlSize2) {
        this.urlSize2 = urlSize2;
    }

    @Override
    public String getUrlSize3() {
        return this.urlSize3;
    }

    @Override
    public void setUrlSize3(String urlSize3) {
        this.urlSize3 = urlSize3;
    }

    @Override
    public String getUrlSize4() {
        return this.urlSize4;
    }

    @Override
    public void setUrlSize4(String urlSize4) {
        this.urlSize4 = urlSize4;
    }

    public String getUrlSize5() {
        return this.urlSize5;
    }

    public void setUrlSize5(String urlSize5) {
        this.urlSize5 = urlSize5;
    }

    public String getUrlSize6() {
        return this.urlSize6;
    }

    public void setUrlSize6(String urlSize6) {
        this.urlSize6 = urlSize6;
    }

    public String getUrlSize7() {
        return this.urlSize7;
    }

    public void setUrlSize7(String urlSize7) {
        this.urlSize7 = urlSize7;
    }

    public String getUrlSize8() {
        return this.urlSize8;
    }

    public void setUrlSize8(String urlSize8) {
        this.urlSize8 = urlSize8;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUrl(int size) {
        switch (size) {
            case 0: {
                return this.getUrlSize0();
            }
            case 1: {
                return this.getUrlSize1();
            }
            case 2: {
                return this.getUrlSize2();
            }
            case 3: {
                return this.getUrlSize3();
            }
            case 4: {
                return this.getUrlSize4();
            }
            case 5: {
                return this.getUrlSize5();
            }
            case 6: {
                return this.getUrlSize6();
            }
            case 7: {
                return this.getUrlSize7();
            }
        }
        return this.getLargestUrlAvailable();
    }

    public String getLargestUrlAvailable() {
        String largest = "";
        if (!StringUtils.isEmpty((String)this.getUrlSize8())) {
            largest = this.getUrlSize8();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize7())) {
            largest = this.getUrlSize7();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize6())) {
            largest = this.getUrlSize6();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize5())) {
            largest = this.getUrlSize5();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize4())) {
            largest = this.getUrlSize4();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize3())) {
            largest = this.getUrlSize3();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize2())) {
            largest = this.getUrlSize2();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize1())) {
            largest = this.getUrlSize1();
        } else if (!StringUtils.isEmpty((String)this.getUrlSize0())) {
            largest = this.getUrlSize0();
        }
        return largest;
    }

    @Override
    public String getDisplayName() {
        return this.displayTitle;
    }

    @Override
    public String getDescription() {
        return "";
    }

    public abstract MediaCollection getCollection();

    public abstract List getFieldValues();

    public abstract void setFieldValues(List<MediaFieldValue> var1);

    @Override
    public abstract List getSummaryFieldValues();

    @Override
    public abstract List getPreviewFieldValues();

    public void setMediaType(String mediaType) {
        this.type = null;
        this.mediaType = mediaType;
        try {
            if (mediaType != null) {
                this.type = MediaType.valueOf(mediaType.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            this.type = null;
            this.mediaType = null;
        }
    }

    public void setType(String mediaType) {
        this.setMediaType(mediaType);
    }

    @Override
    public String getMediaType() {
        if (this.mediaType == null && this.type != null) {
            this.setMediaType(this.type.toString());
        } else if (this.mediaType == null) {
            this.mediaType = "";
        }
        return this.mediaType;
    }

    public MediaType getType() {
        if (this.type == null && this.mediaType != null) {
            this.setMediaType(this.mediaType);
        }
        return this.type;
    }

    @Override
    public boolean isImage() {
        return this.type == MediaType.IMAGE;
    }

    @Override
    public boolean isVideo() {
        return this.type == MediaType.VIDEO;
    }

    @Override
    public boolean isAudio() {
        return this.type == MediaType.AUDIO;
    }

    @Override
    public boolean isMisc() {
        return this.type == MediaType.MISC;
    }

    @Override
    public boolean isBook() {
        return this.type == MediaType.BOOK;
    }

    public boolean isPdf() {
        if (this.isMisc()) {
            if (this.urlSize2 != null && this.urlSize2.toLowerCase().endsWith(".pdf")) {
                return true;
            }
            if (this.urlSize1 != null && this.urlSize1.toLowerCase().endsWith(".pdf")) {
                return true;
            }
            if (this.urlSize0 != null && this.urlSize0.toLowerCase().endsWith(".pdf")) {
                return true;
            }
        }
        return false;
    }

    public void addFullImageUrl(String url) {
        if (this.fullImageUrls == null) {
            this.fullImageUrls = new ArrayList<String>();
        }
        this.fullImageUrls.add(url);
    }

    public void setFullImageUrls(List<String> fullImageUrls) {
        this.fullImageUrls = fullImageUrls;
    }

    public List<String> getFullImageUrls() {
        if (this.fullImageUrls == null) {
            this.fullImageUrls = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.getUrlSize0())) {
                this.fullImageUrls.add(this.getUrlSize0());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize1())) {
                this.fullImageUrls.add(this.getUrlSize1());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize2())) {
                this.fullImageUrls.add(this.getUrlSize2());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize3())) {
                this.fullImageUrls.add(this.getUrlSize3());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize4())) {
                this.fullImageUrls.add(this.getUrlSize4());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize5())) {
                this.fullImageUrls.add(this.getUrlSize5());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize6())) {
                this.fullImageUrls.add(this.getUrlSize6());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize7())) {
                this.fullImageUrls.add(this.getUrlSize7());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize8())) {
                this.fullImageUrls.add(this.getUrlSize8());
            }
        }
        return this.fullImageUrls;
    }

    public int getRecache() {
        return this.recache;
    }

    public void setRecache(int b) {
        this.recache = b;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public boolean getIndexInitiated() {
        return this.indexInitiated;
    }

    public void setIndexInitiated(boolean b) {
        this.indexInitiated = b;
    }

    public void setFormat(String format) {
        this.mediaFormat = format;
    }

    public String getFormat() {
        return this.mediaFormat;
    }

    public static enum MediaType {
        IMAGE,
        VIDEO,
        AUDIO,
        MISC,
        BOOK;

        private static Map<Integer, MediaType> mediaTypeMap;
        private static Map<String, Integer> imageFileMediaTypeMap;

        public static MediaType toMediaType(int imageFileTypeValue) {
            MediaType type = mediaTypeMap.get(imageFileTypeValue);
            if (type == null) {
                type = MISC;
            }
            return type;
        }

        public static int toImageFileMediaType(String mediaTypeString) {
            Integer type = null;
            if (mediaTypeString != null) {
                type = imageFileMediaTypeMap.get(mediaTypeString.toUpperCase());
            }
            if (type == null) {
                type = 5;
            }
            return type;
        }

        static {
            mediaTypeMap = new HashMap<Integer, MediaType>();
            imageFileMediaTypeMap = new HashMap<String, Integer>();
            mediaTypeMap.put(1, IMAGE);
            mediaTypeMap.put(3, VIDEO);
            mediaTypeMap.put(4, VIDEO);
            mediaTypeMap.put(2, AUDIO);
            mediaTypeMap.put(5, MISC);
            mediaTypeMap.put(7, BOOK);
            imageFileMediaTypeMap.put(IMAGE.toString().toUpperCase(), 1);
            imageFileMediaTypeMap.put(VIDEO.toString().toUpperCase(), 3);
            imageFileMediaTypeMap.put(AUDIO.toString().toUpperCase(), 2);
            imageFileMediaTypeMap.put(MISC.toString().toUpperCase(), 5);
            imageFileMediaTypeMap.put(BOOK.toString().toUpperCase(), 7);
        }
    }
}

