/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.luna.insight.server.Debug;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.security.permission.PermissionManager;
import com.lunaimaging.security.util.SubjectUtils;
import com.techempower.ReflectiveComparator;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class LunaMedia
extends Media
implements Serializable {
    private static final long serialVersionUID = 6033195798874540147L;
    public static final int MAX_JPEG_RESOLUTION_SIZE = 4;
    protected int objectId;
    protected String id;
    protected String urlSource;
    protected String urlRefMedia;
    protected String institutionId;
    protected int maxLevel;
    protected int maxWidth;
    protected int maxHeight;
    protected Dimension refImageDim;
    protected String uri;
    protected MediaCollection collection;
    protected String collectionOwner = "";
    protected List<String> permittedUsers;

    public static void debugOut(String s) {
        LunaMedia.debugOut(s, 2);
    }

    public static void debugOut(String s, int level) {
        Debug.debugOut((String)("XMLConverter: " + s), (int)level);
    }

    public LunaMedia(String uniqueCollectionId, int objectId, int mediaId, List<MediaFieldValue> fieldValues) {
        this.setUniqueCollectionId(uniqueCollectionId);
        this.setObjectId(objectId);
        this.setMediaId(mediaId);
        this.setFieldValues(fieldValues);
    }

    public LunaMedia() {
        this("", 0, 0, null);
    }

    @Override
    public String getUniqueCollectionId() {
        String mcid = super.getUniqueCollectionId();
        if (StringUtils.isEmpty((String)mcid) && this.id != null) {
            this.setUniqueCollectionId(InsightCoreUtils.getUniqueCollectionIdFromLunaMediaId(this.id));
        }
        return mcid;
    }

    @Override
    public int getMediaId() {
        int mediaIdTemp = super.getMediaId();
        if (mediaIdTemp < 1 && this.id != null) {
            this.setMediaId(InsightCoreUtils.getMediaIdFromLunaMediaId(this.id));
        }
        return this.mediaId;
    }

    public int getObjectId() {
        if (this.objectId < 1 && this.id != null) {
            this.setObjectId(InsightCoreUtils.getObjectIdFromLunaMediaId(this.id));
        }
        return this.objectId;
    }

    public void add(MediaFieldValue fieldValue) {
        if (fieldValue != null) {
            this.fieldValues.add(fieldValue);
        }
    }

    @Override
    public List<MediaFieldValue> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public void setFieldValues(List<MediaFieldValue> fieldValues) {
        this.fieldValues = fieldValues;
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList();
        }
    }

    @Override
    public String getDisplayTitle() {
        if (super.getDisplayTitle() == null && CollectionUtils.isNotEmpty((Collection)this.fieldValues)) {
            for (MediaFieldValue mfv : this.fieldValues) {
                if (!mfv.getField().isDisplayTitleField() || mfv.getValue() == null) continue;
                super.setDisplayTitle(String.valueOf(mfv.getValue()));
            }
        }
        return super.getDisplayTitle();
    }

    @Override
    public List getSummaryFieldValues() {
        ArrayList<MediaFieldValue> mediaSummaryFieldValues = new ArrayList<MediaFieldValue>();
        for (MediaFieldValue mfv : this.fieldValues) {
            if (mfv == null || !mfv.getField().isSummaryDescriptionField()) continue;
            mediaSummaryFieldValues.add(mfv);
        }
        Collections.sort(mediaSummaryFieldValues, new ReflectiveComparator("getSummaryDescriptionFieldSort", 2));
        return mediaSummaryFieldValues;
    }

    @Override
    public List getPreviewFieldValues() {
        ArrayList<MediaFieldValue> fieldValues = new ArrayList<MediaFieldValue>();
        for (MediaFieldValue mfv : fieldValues) {
            if (mfv == null || !mfv.getField().isPreviewField()) continue;
            fieldValues.add(mfv);
        }
        Collections.sort(fieldValues, new ReflectiveComparator("getPreviewFieldSort", 2));
        return fieldValues;
    }

    public List getRelatedItemFieldValues() {
        ArrayList<MediaFieldValue> fvs = new ArrayList<MediaFieldValue>();
        for (MediaFieldValue mfv : this.fieldValues) {
            if (mfv == null || !mfv.getField().isRelatedItemField()) continue;
            fvs.add(mfv);
        }
        return fvs;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof LunaMedia) {
            LunaMedia m = (LunaMedia)o;
            if (this.uniqueCollectionId == m.uniqueCollectionId && this.objectId == m.objectId) {
                return true;
            }
        }
        return false;
    }

    public Object findFieldValue(int fieldId) {
        for (MediaFieldValue mfv : this.fieldValues) {
            if (mfv.getField().getFieldId() != fieldId) continue;
            return mfv.getValue();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Object getIdentity() {
        return this.getId();
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUrl(int size) {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrl(size);
    }

    @Override
    public String getUrlSize0() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize0();
    }

    @Override
    public String getUrlSize1() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize1();
    }

    @Override
    public String getUrlSize2() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize2();
    }

    @Override
    public String getUrlSize3() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize3();
    }

    @Override
    public String getUrlSize4() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize4();
    }

    @Override
    public String getUrlSize5() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize5();
    }

    @Override
    public String getUrlSize6() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize6();
    }

    @Override
    public String getUrlSize7() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize7();
    }

    @Override
    public String getUrlSize8() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getUrlSize8();
    }

    public String getUrlSource() {
        try {
            if (!this.isPermitted()) {
                return "/luna/images/luna-media-icons/restricted-thumbnail.gif";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.urlSource;
    }

    public void setUrlSource(String urlSource) {
        this.urlSource = urlSource;
    }

    public String toString() {
        return "PublisherMedia[" + this.id + "]:" + StringUtils.defaultIfEmpty((String)this.displayTitle, (String)"");
    }

    @Override
    public MediaCollection getCollection() {
        return this.collection;
    }

    public void setCollection(MediaCollection collection) {
        this.collection = collection;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getMediaCollectionId() {
        if (this.collection != null) {
            return this.collection.getId();
        }
        return InsightCoreUtils.getCollectionIdFromLunaMedia(this);
    }

    @Override
    public void removeFieldValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void trimAttributes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIiifManifestUrl(String url) {
    }

    public String getUrlRefMedia() {
        return this.urlRefMedia;
    }

    public void setUrlRefMedia(String urlRefMedia) {
        this.urlRefMedia = urlRefMedia;
    }

    public String getCollectionOwner() {
        return this.collectionOwner;
    }

    public void setCollectionOwner(String collectionOwner) {
        this.collectionOwner = collectionOwner;
    }

    public boolean isPermitted() throws Exception {
        boolean isPermitted = false;
        if (this.permittedUsers != null && this.permittedUsers != null && this.permittedUsers.size() > 0) {
            Subject subject = SecurityUtils.getSubject();
            int credentialsId = SubjectUtils.getCredentialsId((Subject)subject);
            if (subject != null) {
                Session s;
                Object credId;
                String thisUser;
                String string = thisUser = subject.getPrincipal() == null ? "" : subject.getPrincipal().toString();
                if (subject.hasRole(PermissionManager.getRoleSuperAdmin()) || this.permittedUsers.contains(thisUser) || StringUtils.isNotEmpty((String)this.collectionOwner) && this.collectionOwner.equals(thisUser) || this.permittedUsers.contains(String.valueOf(credentialsId))) {
                    isPermitted = true;
                }
                if (!subject.isAuthenticated() && (credId = (s = subject.getSession()).getAttribute((Object)"IPRANGE_DEFAULT_CREDENTIAL_ID")) != null && this.permittedUsers != null && this.permittedUsers.contains(String.valueOf(credId))) {
                    isPermitted = true;
                }
            }
        } else {
            isPermitted = true;
        }
        return isPermitted;
    }

    public List<String> getPermittedUsers() {
        return this.permittedUsers;
    }

    public void setPermittedUsers(List<String> permittedUsers) {
        this.permittedUsers = permittedUsers;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    public Dimension getRefImageDim() {
        return this.refImageDim;
    }

    public void setRefImageDim(Dimension refImageDim) {
        this.refImageDim = refImageDim;
    }
}

