/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.dao.exceptions.IpValidationException;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.MediaCollection;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IpRange
implements Authenticable,
Serializable {
    protected int id;
    protected int credentialsId;
    protected String location;
    protected String description;
    protected String startIp;
    protected String endIp;
    protected Boolean setAsDefault;
    protected long startIpLong;
    protected long endIpLong;
    protected Credentials credentials;
    protected ArrayList<MediaCollection> mediaCollections;
    protected ArrayList<MediaCollection> defaultMediaCollections;
    protected ArrayList defaultCollectionIds;
    protected boolean minimalClientSide;
    protected Log log = LogFactory.getLog(this.getClass());

    public boolean contains(String ip) {
        long ipLong = this.convertStringToLong(ip);
        return this.setAsDefault == false && ipLong >= this.startIpLong && ipLong <= this.endIpLong;
    }

    private void validateIps() throws IpValidationException {
        if (this.setAsDefault != null && !this.setAsDefault.booleanValue() && this.startIp != null && this.endIp != null) {
            try {
                this.startIpLong = this.convertStringToLong(this.startIp);
                this.endIpLong = this.convertStringToLong(this.endIp);
            }
            catch (NumberFormatException nfe) {
                this.startIpLong = -1L;
            }
            if (this.startIpLong == -1L || this.endIpLong == -1L) {
                String msg = "Error: malformed IP in IP range - startIp=" + this.startIp + ", endIp=" + this.endIp;
                this.log.info((Object)msg);
                throw new IpValidationException(msg);
            }
        }
    }

    private long convertStringToLong(String ip) {
        long ipnum = -1L;
        String[] quads = ip.split("\\.");
        if (quads.length == 4 && this.areIpChunksValid(quads)) {
            ipnum = 0x1000000L * Long.parseLong(quads[0]) + 65536L * Long.parseLong(quads[1]) + 256L * Long.parseLong(quads[2]) + 1L * Long.parseLong(quads[3]);
        }
        return ipnum;
    }

    private boolean areIpChunksValid(String[] chunks) {
        for (String s : chunks) {
            long num = Long.parseLong(s);
            if (num >= 0L && num <= 255L) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public int getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public void setCredentialsId(int credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStartIp() {
        return this.startIp;
    }

    public void setStartIp(String startIp) throws IpValidationException {
        this.startIp = startIp;
        this.validateIps();
    }

    public String getEndIp() {
        return this.endIp;
    }

    public void setEndIp(String endIp) throws IpValidationException {
        this.endIp = endIp;
        this.validateIps();
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public boolean isSetAsDefault() {
        return this.setAsDefault;
    }

    public void setSetAsDefault(boolean setAsDefault) throws IpValidationException {
        this.setAsDefault = setAsDefault;
        this.validateIps();
    }

    @Override
    public ArrayList<MediaCollection> getMediaCollections() {
        return this.mediaCollections;
    }

    @Override
    public void setMediaCollections(ArrayList<MediaCollection> mediaCollections) {
        this.mediaCollections = mediaCollections;
    }

    @Override
    public ArrayList<MediaCollection> getDefaultMediaCollections() {
        return this.defaultMediaCollections;
    }

    @Override
    public void setDefaultMediaCollections(ArrayList<MediaCollection> defaultMediaCollections) {
        this.defaultMediaCollections = defaultMediaCollections;
    }

    @Override
    public ArrayList getDefaultCollectionIds() {
        return this.defaultCollectionIds;
    }

    @Override
    public void setDefaultCollectionIds(ArrayList defaultCollectionIds) {
        this.defaultCollectionIds = defaultCollectionIds;
    }

    @Override
    public boolean isMinimalClientSide() {
        return this.minimalClientSide;
    }

    @Override
    public void setMinimalClientSide(boolean minimalClientSide) {
        this.minimalClientSide = minimalClientSide;
    }

    public String toString() {
        return "IpRange[" + this.id + "][" + this.startIp + "-" + this.endIp + "]\n";
    }
}

