/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.WebUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ExternalMedia
extends Media
implements Serializable {
    protected String objectId;
    protected String objectOwnerId;
    protected int mediaId;
    protected String urlSize5;
    protected String urlSize6;
    protected String urlSize7;
    protected String urlSize8;
    protected String urlSize9;
    protected String urlSize10;
    protected String urlSource;
    protected String originatingUrl;
    protected String copyright;
    protected int groupId;
    protected String description;
    protected String mediaSource;
    private static final long serialVersionUID = 2904257123012297644L;
    public static final String MEDIA_SOURCE_FLICKER = "Flicker";
    public static final String MEDIA_SOURCE_LUNA = "Luna";
    public static final String MEDIA_SOURCE_INTERNET_ARCHIVE = "Archive";
    private static final int TITLE_LIMIT = 80;
    private static final int OBJECT_ID_LIMIT = 40;
    private static final int OBJECT_OWNER_ID_LIMIT = 40;
    private static final int URL_SIZE_LIMIT = 800;
    private static final int ORIGINATING_URL_LIMIT = 3200;
    private static final int COPYRIGHT_LIMIT = 400;
    private static final int DESCRIPTION_LIMIT = 800;

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectOwnerId() {
        return this.objectOwnerId;
    }

    @Override
    public String getUrlSize5() {
        return this.urlSize5;
    }

    @Override
    public String getUrlSize6() {
        return this.urlSize6;
    }

    @Override
    public String getUrlSize7() {
        return this.urlSize7;
    }

    @Override
    public String getUrlSize8() {
        return this.urlSize8;
    }

    public String getUrlSize9() {
        return this.urlSize9;
    }

    public String getUrlSize10() {
        return this.urlSize10;
    }

    public String getOriginatingUrl() {
        return this.originatingUrl;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public int getGroupId() {
        return this.groupId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setObjectOwnerId(String objectOwnerId) {
        this.objectOwnerId = objectOwnerId;
    }

    @Override
    public void setUrlSize5(String urlSize5) {
        this.urlSize5 = urlSize5;
    }

    @Override
    public void setUrlSize6(String urlSize6) {
        this.urlSize6 = urlSize6;
    }

    @Override
    public void setUrlSize7(String urlSize7) {
        this.urlSize7 = urlSize7;
    }

    @Override
    public void setUrlSize8(String urlSize8) {
        this.urlSize8 = urlSize8;
    }

    public void setUrlSize9(String urlSize9) {
        this.urlSize9 = urlSize9;
    }

    public void setUrlSize10(String urlSize10) {
        this.urlSize10 = urlSize10;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setOriginatingUrl(String originatingUrl) {
        this.originatingUrl = originatingUrl;
    }

    @Override
    public int getMediaId() {
        return this.mediaId;
    }

    @Override
    public void setMediaId(int mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public Object getIdentity() {
        if (StringUtils.isNotEmpty((String)this.objectId) && "DEFAULT~0~0".equals(InsightCoreUtils.getCollectionIdFromLunaMediaId(this.objectId))) {
            return this.objectId;
        }
        return this.getMediaId();
    }

    public Object getId() {
        return this.mediaId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List getFieldValues() {
        if (CollectionUtils.isEmpty((Collection)this.fieldValues) && (StringUtils.isNotEmpty((String)this.displayTitle) || StringUtils.isNotEmpty((String)this.copyright) || StringUtils.isNotEmpty((String)this.originatingUrl) || StringUtils.isNotEmpty((String)this.description))) {
            this.fieldValues = new ArrayList();
            if (StringUtils.isNotEmpty((String)this.displayTitle)) {
                MediaField titleField = new MediaField();
                titleField.setDisplayName("Title");
                titleField.setSummaryDescriptionField(true);
                titleField.setPreviewFieldSort(0);
                MediaFieldValue titleMF = new MediaFieldValue(titleField, this.displayTitle);
                this.fieldValues.add(titleMF);
            }
            if (StringUtils.isNotEmpty((String)this.description)) {
                MediaField descriptionField = new MediaField();
                descriptionField.setDisplayName("Description");
                descriptionField.setSummaryDescriptionField(true);
                descriptionField.setDisplayTitleField(true);
                descriptionField.setPreviewFieldSort(2);
                MediaFieldValue descriptionMF = new MediaFieldValue(descriptionField, this.description);
                this.fieldValues.add(descriptionMF);
            }
            if (StringUtils.isNotEmpty((String)this.originatingUrl)) {
                MediaField orginatingUrlField = new MediaField();
                orginatingUrlField.setDisplayName("Originating Url");
                orginatingUrlField.setSummaryDescriptionField(true);
                orginatingUrlField.setPreviewFieldSort(3);
                MediaFieldValue orginatingUrlMF = null;
                orginatingUrlMF = MEDIA_SOURCE_INTERNET_ARCHIVE.equals(this.mediaSource) || MEDIA_SOURCE_LUNA.equals(this.mediaSource) ? new MediaFieldValue(orginatingUrlField, "<a target='_blank' href='" + this.originatingUrl + "' >Open this Book</a><br>") : new MediaFieldValue(orginatingUrlField, this.originatingUrl);
                this.fieldValues.add(orginatingUrlMF);
            }
            if (StringUtils.isNotEmpty((String)this.copyright)) {
                MediaField copyrightField = new MediaField();
                copyrightField.setDisplayName("Copyright");
                copyrightField.setSummaryDescriptionField(true);
                copyrightField.setPreviewFieldSort(4);
                MediaFieldValue copyrightMF = new MediaFieldValue(copyrightField, this.copyright);
                this.fieldValues.add(copyrightMF);
            }
        }
        return this.fieldValues;
    }

    @Override
    public List getSummaryFieldValues() {
        return this.getFieldValues();
    }

    @Override
    public List getPreviewFieldValues() {
        return this.getFieldValues();
    }

    @Override
    public MediaCollection getCollection() {
        return null;
    }

    @Override
    public void setFieldValues(List<MediaFieldValue> fieldValues) {
        if (fieldValues == null) {
            fieldValues = new ArrayList<MediaFieldValue>();
        }
        this.fieldValues = fieldValues;
    }

    private String getLargestUrl() {
        String largest = "";
        largest = !StringUtils.isEmpty((String)this.getUrlSize10()) ? this.getUrlSize10() : (!StringUtils.isEmpty((String)this.getUrlSize9()) ? this.getUrlSize9() : (!StringUtils.isEmpty((String)this.getUrlSize8()) ? this.getUrlSize8() : (!StringUtils.isEmpty((String)this.getUrlSize7()) ? this.getUrlSize7() : (!StringUtils.isEmpty((String)this.getUrlSize6()) ? this.getUrlSize6() : (!StringUtils.isEmpty((String)this.getUrlSize5()) ? this.getUrlSize5() : this.getLargestUrlAvailable())))));
        return largest;
    }

    @Override
    public List<String> getFullImageUrls() {
        if (this.fullImageUrls == null) {
            this.fullImageUrls = new ArrayList();
            if (!StringUtils.isEmpty((String)this.getUrlSize0())) {
                this.fullImageUrls.add(this.getUrlSize0());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize1())) {
                this.fullImageUrls.add(this.getUrlSize1());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize2())) {
                this.fullImageUrls.add(this.getUrlSize2());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize3())) {
                this.fullImageUrls.add(this.getUrlSize3());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize4())) {
                this.fullImageUrls.add(this.getUrlSize4());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize5())) {
                this.fullImageUrls.add(this.getUrlSize5());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize6())) {
                this.fullImageUrls.add(this.getUrlSize6());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize7())) {
                this.fullImageUrls.add(this.getUrlSize7());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize8())) {
                this.fullImageUrls.add(this.getUrlSize8());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize9())) {
                this.fullImageUrls.add(this.getUrlSize9());
            }
            if (!StringUtils.isEmpty((String)this.getUrlSize10())) {
                this.fullImageUrls.add(this.getUrlSize10());
            }
        }
        return this.fullImageUrls;
    }

    public void truncateAndSetValues(String title, String objectId, String objectOwnerId, String urlSize0, String urlSize1, String urlSize2, String urlSize3, String urlSize4, String originatingUrl, String copyright, int groupId, String type, String description) {
        this.truncateAndSetValues(title, objectId, objectOwnerId, urlSize0, urlSize1, urlSize2, urlSize3, urlSize4, null, null, null, null, originatingUrl, copyright, groupId, type, description, MEDIA_SOURCE_FLICKER, null);
    }

    public void truncateAndSetValues(String title, String objectId, String objectOwnerId, String urlSize0, String urlSize1, String urlSize2, String urlSize3, String urlSize4, String urlSize5, String urlSize6, String urlSize7, String urlsSize8, String originatingUrl, String copyright, int groupId, String type, String description, String externalMediaSource, String id) {
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        if (objectId.length() > 40) {
            objectId = objectId.substring(0, 40);
        }
        if (objectOwnerId.length() > 40) {
            objectOwnerId = objectOwnerId.substring(0, 40);
        }
        if (copyright.length() > 400) {
            copyright = copyright.substring(0, 400);
        }
        if (description.length() > 800) {
            description = description.substring(0, 800);
        }
        originatingUrl = WebUtils.getUrlAddressFromAnchorTag(originatingUrl);
        this.setDisplayTitle(StringEscapeUtils.escapeHtml((String)title));
        this.setObjectId(objectId);
        this.setObjectOwnerId(objectOwnerId);
        if (StringUtils.isNotBlank((String)urlSize0)) {
            if (urlSize0.length() > 800) {
                urlSize0 = urlSize0.substring(0, 800);
            }
            this.setUrlSize0(urlSize0);
        }
        if (StringUtils.isNotBlank((String)urlSize1)) {
            if (urlSize1.length() > 800) {
                urlSize1 = urlSize1.substring(0, 800);
            }
            this.setUrlSize1(urlSize1);
        }
        if (StringUtils.isNotBlank((String)urlSize2)) {
            if (urlSize2.length() > 800) {
                urlSize2 = urlSize2.substring(0, 800);
            }
            this.setUrlSize2(urlSize2);
        }
        if (StringUtils.isNotBlank((String)urlSize3)) {
            if (urlSize3.length() > 800) {
                urlSize3 = urlSize3.substring(0, 800);
            }
            this.setUrlSize3(urlSize3);
        }
        if (StringUtils.isNotBlank((String)urlSize4)) {
            if (urlSize4.length() > 800) {
                urlSize4 = urlSize4.substring(0, 800);
            }
            this.setUrlSize4(urlSize4);
        }
        if (StringUtils.isNotBlank((String)urlSize5)) {
            if (urlSize5.length() > 800) {
                urlSize5 = urlSize5.substring(0, 800);
            }
            this.setUrlSize5(urlSize5);
        }
        if (StringUtils.isNotBlank((String)urlSize6)) {
            if (urlSize6.length() > 800) {
                urlSize6 = urlSize6.substring(0, 800);
            }
            this.setUrlSize6(urlSize6);
        }
        if (StringUtils.isNotBlank((String)urlSize7)) {
            if (urlSize7.length() > 800) {
                urlSize7 = urlSize7.substring(0, 800);
            }
            this.setUrlSize7(urlSize7);
        }
        if (StringUtils.isNotBlank((String)this.urlSize8)) {
            if (this.urlSize8.length() > 800) {
                this.urlSize8 = this.urlSize8.substring(0, 800);
            }
            this.setUrlSize8(this.urlSize8);
        }
        if (StringUtils.isNotBlank((String)originatingUrl)) {
            if (originatingUrl.length() > 3200) {
                originatingUrl = originatingUrl.substring(0, 3200);
            }
            this.setOriginatingUrl(originatingUrl);
        }
        this.setCopyright(StringEscapeUtils.escapeHtml((String)copyright));
        this.setGroupId(groupId);
        this.setMediaType(type);
        this.setDescription(StringEscapeUtils.escapeHtml((String)description));
        this.setMediaSource(externalMediaSource);
        this.setFieldValues(new ArrayList<MediaFieldValue>());
    }

    public String getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(String mediaSource) {
        this.mediaSource = mediaSource;
    }

    public int getMaxLevel() {
        int largest = 0;
        if (!StringUtils.isEmpty((String)this.getUrlSize10())) {
            largest = 10;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize9())) {
            largest = 9;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize8())) {
            largest = 8;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize7())) {
            largest = 7;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize6())) {
            largest = 6;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize5())) {
            largest = 5;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize4())) {
            largest = 4;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize3())) {
            largest = 3;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize2())) {
            largest = 2;
        } else if (!StringUtils.isEmpty((String)this.getUrlSize1())) {
            largest = 1;
        }
        return largest;
    }

    public String getMaxWidth() {
        String url = this.getLargestUrl();
        String width = null;
        if (this.mediaSource != null && this.mediaSource.equals(MEDIA_SOURCE_LUNA)) {
            int indexOfWidth = url.lastIndexOf("&width=");
            int indexOfEndOfWidth = url.indexOf("&", indexOfWidth + 1);
            if (indexOfEndOfWidth == -1) {
                indexOfEndOfWidth = url.length();
            }
            if (indexOfWidth >= 0) {
                width = url.substring(indexOfWidth + 7, indexOfEndOfWidth);
            }
        }
        return width;
    }

    public String getMaxHeight() {
        String url = this.getLargestUrl();
        String height = null;
        if (this.mediaSource != null && this.mediaSource.equals(MEDIA_SOURCE_LUNA)) {
            int indexOfHeight = url.lastIndexOf("&height=");
            int indexOfEndOfHeight = url.indexOf("&", indexOfHeight + 1);
            if (indexOfEndOfHeight == -1) {
                indexOfEndOfHeight = url.length();
            }
            if (indexOfHeight >= 0) {
                height = url.substring(indexOfHeight + 8, indexOfEndOfHeight);
            }
        }
        return height;
    }

    public String getUrlSource() {
        String urlSource = null;
        if (this.mediaSource != null && this.mediaSource.equals(MEDIA_SOURCE_LUNA)) {
            if (!this.isImage()) {
                urlSource = this.getUrlSize3();
                if (urlSource == null) {
                    urlSource = this.getUrlSize2();
                }
            } else if (this.getMaxLevel() > 4) {
                urlSource = this.getLargestUrl();
            }
        }
        return urlSource;
    }

    @Override
    public String getUrlSize0() {
        String url = this.urlSize0;
        if (StringUtils.isEmpty((String)url)) {
            String srcUrl = this.urlSize3;
            if (StringUtils.isEmpty((String)srcUrl)) {
                srcUrl = this.urlSize2;
            }
            if (StringUtils.isNotEmpty((String)srcUrl)) {
                String ext = srcUrl.substring(srcUrl.lastIndexOf(".") + 1);
                url = "/luna/images/luna-media-icons/" + ext + "-thumbnail.gif";
            }
        }
        return url;
    }

    public void setUrlSize0() {
        String srcUrl;
        if (StringUtils.isEmpty((String)this.urlSize0) && StringUtils.isNotEmpty((String)(srcUrl = this.urlSize3))) {
            String ext = srcUrl.substring(srcUrl.lastIndexOf(".") + 1);
            this.urlSize0 = "/luna/images/luna-media-icons/" + ext + "-thumbnail.gif";
        }
    }

    @Override
    public String getUrlSize1() {
        String url = this.urlSize1;
        if (StringUtils.isEmpty((String)url)) {
            String srcUrl = this.urlSize3;
            if (StringUtils.isEmpty((String)srcUrl)) {
                srcUrl = this.urlSize2;
            }
            if (StringUtils.isNotEmpty((String)srcUrl)) {
                String ext = srcUrl.substring(srcUrl.lastIndexOf(".") + 1);
                url = "/luna/images/luna-media-icons/" + ext + "-thumbnail.gif";
            }
        }
        return url;
    }

    public void setUrlSize1() {
        String srcUrl;
        if (StringUtils.isEmpty((String)this.urlSize1) && StringUtils.isNotEmpty((String)(srcUrl = this.urlSize3))) {
            String ext = srcUrl.substring(srcUrl.lastIndexOf(".") + 1);
            this.urlSize1 = "/luna/images/luna-media-icons/" + ext + "-thumbnail.gif";
        }
    }

    @Override
    public String getUrlSize2() {
        String srcUrl;
        String url = this.urlSize2;
        if (StringUtils.isEmpty((String)url) && !this.isImage() && StringUtils.isNotEmpty((String)(srcUrl = this.urlSize3))) {
            String ext = srcUrl.substring(srcUrl.lastIndexOf(".") + 1);
            url = "/luna/images/luna-media-icons/" + ext + "-thumbnail.gif";
        }
        return url;
    }

    public void setUrlSize2() {
        String srcUrl;
        if (StringUtils.isEmpty((String)this.urlSize2) && !this.isImage() && StringUtils.isNotEmpty((String)(srcUrl = this.urlSize3))) {
            String ext = srcUrl.substring(srcUrl.lastIndexOf(".") + 1);
            this.urlSize2 = "/luna/images/luna-media-icons/" + ext + "-thumbnail.gif";
        }
    }

    @Override
    public void removeFieldValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void trimAttributes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIiifManifestUrl(String url) {
    }

    public void setUrl(int size, String url) {
        switch (size) {
            case 0: {
                this.setUrlSize0(url);
            }
            case 1: {
                this.setUrlSize1(url);
            }
            case 2: {
                this.setUrlSize2(url);
            }
            case 3: {
                this.setUrlSize3(url);
            }
            case 4: {
                this.setUrlSize4(url);
            }
            case 5: {
                this.setUrlSize5(url);
            }
            case 6: {
                this.setUrlSize6(url);
            }
            case 7: {
                this.setUrlSize7(url);
            }
        }
    }

    public void setUrlSource(String urlSource) {
        this.urlSource = urlSource;
    }

    @Override
    public String getUri() {
        return null;
    }
}

