/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class Credentials
implements Serializable {
    private int id;
    private boolean exportAllowed;
    private boolean publicContentAllowed;
    private String name;
    private String description;
    private boolean useAsDefault;
    private boolean uploadAllowed;
    private String supportedUploadFormats;
    private boolean facetsRestricted;
    private ArrayList authorizedCollectionIds = new ArrayList();
    private ArrayList maxResolutions = new ArrayList();
    private ArrayList maxExportResolutions = new ArrayList();
    private ArrayList annotationEnabled = new ArrayList();
    private static final long serialVersionUID = 7L;

    public Credentials() {
    }

    public Credentials(Credentials c) {
        this();
        this.setAuthorizedCollectionIds(c.getAuthorizedCollectionIds());
        this.setMaxResolutions(c.getMaxResolutions());
        this.setMaxExportResolutions(c.getMaxExportResolutions());
        this.setAnnotationEnabled(c.getAnnotationEnabled());
        this.exportAllowed = c.isExportAllowed();
        this.name = c.getName();
        this.description = c.getDescription();
        this.useAsDefault = c.isUseAsDefault();
        this.uploadAllowed = c.isUploadAllowed();
        this.facetsRestricted = c.isFacetsRestricted();
    }

    public void updateMaxResolution(String collectionId, int maxResolution) {
        ParsingUtils.setValueOnLinkedArrays(this.authorizedCollectionIds, this.maxResolutions, collectionId, maxResolution);
    }

    public void updateMaxExportResolution(String collectionId, int maxExportResolution) {
        ParsingUtils.setValueOnLinkedArrays(this.authorizedCollectionIds, this.maxExportResolutions, collectionId, maxExportResolution);
    }

    public void addCollection(String collectionId, int maxResolution) {
        this.updateMaxResolution(collectionId, maxResolution);
    }

    public int retrieveMaxResolution(String collectionId) {
        Object returnValue = ParsingUtils.getValueFromLinkedArrays(this.authorizedCollectionIds, this.maxResolutions, collectionId);
        if (returnValue instanceof Number) {
            return ((Number)returnValue).intValue();
        }
        return -1;
    }

    public int retrieveMaxExportResolution(String collectionId) {
        Object returnValue = ParsingUtils.getValueFromLinkedArrays(this.authorizedCollectionIds, this.maxExportResolutions, collectionId);
        if (returnValue instanceof Number) {
            return ((Number)returnValue).intValue();
        }
        return -1;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isExportAllowed() {
        return this.exportAllowed;
    }

    public void setExportAllowed(boolean exportAllowed) {
        this.exportAllowed = exportAllowed;
    }

    public ArrayList getMaxResolutions() {
        return this.maxResolutions;
    }

    public void setMaxResolutions(ArrayList maxResolutions) {
        this.maxResolutions.clear();
        if (maxResolutions != null) {
            for (Object mr : maxResolutions) {
                this.maxResolutions.add(mr);
            }
        }
    }

    public ArrayList getMaxExportResolutions() {
        return this.maxExportResolutions;
    }

    public void setMaxExportResolutions(ArrayList maxExportResolutions) {
        this.maxExportResolutions.clear();
        if (maxExportResolutions != null) {
            for (Object mr : maxExportResolutions) {
                this.maxExportResolutions.add(mr);
            }
        }
    }

    public ArrayList getAuthorizedCollectionIds() {
        return this.authorizedCollectionIds;
    }

    public void setAuthorizedCollectionIds(ArrayList authorizedCollectionIds) {
        this.authorizedCollectionIds.clear();
        if (authorizedCollectionIds != null) {
            for (Object ac : authorizedCollectionIds) {
                this.authorizedCollectionIds.add(ac);
            }
        }
    }

    public ArrayList getAnnotationEnabled() {
        return this.annotationEnabled;
    }

    public void setAnnotationEnabled(ArrayList annotationEnabled) {
        this.annotationEnabled.clear();
        if (annotationEnabled != null) {
            for (Object ae : annotationEnabled) {
                this.annotationEnabled.add(Boolean.parseBoolean(ae.toString()));
            }
        }
    }

    public String toString() {
        return "Credentials[" + this.id + "]:" + this.authorizedCollectionIds;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUseAsDefault() {
        return this.useAsDefault;
    }

    public void setUseAsDefault(boolean default1) {
        this.useAsDefault = default1;
    }

    public boolean isPublicContentAllowed() {
        return this.publicContentAllowed;
    }

    public void setPublicContentAllowed(boolean publicContentAllowed) {
        this.publicContentAllowed = publicContentAllowed;
    }

    public boolean isUploadAllowed() {
        return this.uploadAllowed;
    }

    public void setUploadAllowed(boolean uploadAllowed) {
        this.uploadAllowed = uploadAllowed;
    }

    public String getSupportedUploadFormats() {
        return this.supportedUploadFormats;
    }

    public void setSupportedUploadFormats(String supportedUploadFormats) {
        this.supportedUploadFormats = supportedUploadFormats;
    }

    public boolean isFacetsRestricted() {
        return this.facetsRestricted;
    }

    public void setFacetsRestricted(boolean facetsRestricted) {
        this.facetsRestricted = facetsRestricted;
    }
}

