/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ApplicationConfiguration
implements Serializable {
    protected boolean adsEnabled = false;
    protected boolean sslEnabled = false;
    protected boolean rssEnabled = false;
    protected boolean alternateSearchEnabled = false;
    protected boolean registrationEnabled = false;
    protected boolean publicContentDistributor = false;
    protected List<String> contentDistributionUrls = null;
    protected Map<String, String> mapInstitutionIdToGuid = null;
    protected String maintenanceGuid;
    protected String fetchExternalPublicContentGuid;
    protected String publishDistributedContentGuid;
    protected Map<String, String> mapCollectionIdToUniqueFieldName = null;
    protected String buyLinkBaseUrl = null;
    protected Map<String, String> metaKeywords = new HashMap<String, String>();
    protected Map<String, String> metaDescription = new HashMap<String, String>();
    protected Map<String, String> thumbnailFacetLabel = new HashMap<String, String>();
    protected Vector<String> buyLinkParamName = null;
    protected Vector<String> buyLinkParamSrcField = null;
    protected Vector<String> buyLinkCollectionId = null;
    protected Vector<String> buyButtonCustomText = null;
    protected Vector<String> buyButtonCollectionId = null;
    protected Vector<String> buyButtonBaseUrl = null;
    protected String oaiRepositoryName = null;
    protected String oaiRepositoryAdminEmail = null;
    protected String oaiAdditionalIdentifiers = "detailView";
    protected Vector<String> oaiOrderedStandardName = null;
    protected Vector<String> oaiOrderedDCField = null;
    protected Vector<String> oaiOrderedStandardFields = null;
    protected int linkSearchShowDelayMilliSec = 0;
    protected int linkSearchHideDelayMilliSec = 3000;
    protected boolean linkSearchEnabled = true;
    protected String linkSearchExcludedFields = null;
    protected boolean analyticsEnabled = false;
    protected boolean validateRequestBeforeExport = false;
    protected boolean validateExportByIP = false;
    protected int validateExportSize = 5;
    protected int validateExportInterval = 60;
    protected String recaptchaPublicKey = null;
    protected String recaptchaPrivateKey = null;
    protected int recaptchaAllowedFailedAttempts = 3;
    protected String georeferencerBaseUrl = null;
    protected String georeferencerIdField = null;
    protected String thumbnailDisplay = null;
    protected String hashTags = null;
    protected String twitterHandle = null;
    protected String imageViewer = null;
    protected String externalScriptUrl = null;
    protected String layoutType = null;
    protected boolean recaptchaV3Enabled = false;
    protected String recaptchaV3SiteKey;
    protected String recaptchaV3SecretKey;
    protected String recaptchaV3WhiteListRegex;
    private static final long serialVersionUID = -375525249084592396L;

    public ApplicationConfiguration() {
        this.contentDistributionUrls = new ArrayList<String>();
        this.mapInstitutionIdToGuid = new HashMap<String, String>();
        this.mapCollectionIdToUniqueFieldName = new HashMap<String, String>();
        this.buyLinkParamName = new Vector();
        this.buyLinkParamSrcField = new Vector();
        this.buyLinkCollectionId = new Vector();
        this.buyButtonCustomText = new Vector();
        this.buyButtonCollectionId = new Vector();
        this.buyButtonBaseUrl = new Vector();
        this.oaiOrderedStandardName = new Vector();
        this.oaiOrderedDCField = new Vector();
        this.oaiOrderedStandardFields = new Vector();
    }

    public boolean isRegistrationEnabled() {
        return this.registrationEnabled;
    }

    public void setRegistrationEnabled(boolean registrationEnabled) {
        this.registrationEnabled = registrationEnabled;
    }

    public boolean isAdsEnabled() {
        return this.adsEnabled;
    }

    public void setAdsEnabled(boolean adsEnabled) {
        this.adsEnabled = adsEnabled;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isRssEnabled() {
        return this.rssEnabled;
    }

    public void setRssEnabled(boolean rssEnabled) {
        this.rssEnabled = rssEnabled;
    }

    public boolean isAlternateSearchEnabled() {
        return this.alternateSearchEnabled;
    }

    public void setAlternateSearchEnabled(boolean alternateSearchEnabled) {
        this.alternateSearchEnabled = alternateSearchEnabled;
    }

    public boolean isLinkSearchEnabled() {
        return this.linkSearchEnabled;
    }

    public void setLinkSearchEnabled(boolean linkSearchEnabled) {
        this.linkSearchEnabled = linkSearchEnabled;
    }

    public List<String> getContentDistributionUrls() {
        return this.contentDistributionUrls;
    }

    public void setContentDistributionUrls(List<String> contentDistributionUrls) {
        this.contentDistributionUrls = contentDistributionUrls;
    }

    public void addContentDistributionUrl(String url) {
        if (url != null) {
            this.contentDistributionUrls.add(url);
        }
    }

    public void addPublicContentRecipient(String institutionId, String guid) {
        if (StringUtils.isNotEmpty((String)institutionId) && StringUtils.isNotEmpty((String)guid)) {
            this.mapInstitutionIdToGuid.put(institutionId, guid);
        }
    }

    public Map getPublicContentRecipients() {
        return this.mapInstitutionIdToGuid;
    }

    public boolean isKnowPublicContentRecipient(String institutionId, String guid) {
        boolean knowRecipient = false;
        if (StringUtils.isNotEmpty((String)institutionId) && StringUtils.isNotEmpty((String)guid) && this.mapInstitutionIdToGuid.containsKey(institutionId) && StringUtils.equals((String)this.mapInstitutionIdToGuid.get(institutionId), (String)guid)) {
            knowRecipient = true;
        }
        return knowRecipient;
    }

    public Map<String, String> getMapInstitutionIdToGuid() {
        return this.mapInstitutionIdToGuid;
    }

    public void setMapInstitutionIdToGuid(Map<String, String> mapInstitutionIdToGuid) {
        this.mapInstitutionIdToGuid = mapInstitutionIdToGuid;
    }

    public void setMaintenanceGuid(String maintenanceGuid) {
        this.maintenanceGuid = maintenanceGuid;
    }

    public String getMaintenanceGuid() {
        return this.maintenanceGuid;
    }

    public String getFetchExternalPublicContentGuid() {
        return this.fetchExternalPublicContentGuid;
    }

    public String getPublishDistributedContentGuid() {
        return this.publishDistributedContentGuid;
    }

    public void setPublishDistributedContentGuid(String publishDistributedContentGuid) {
        this.publishDistributedContentGuid = publishDistributedContentGuid;
    }

    public void setFetchExternalPublicContentGuid(String fetchExternalPublicContentGuid) {
        this.fetchExternalPublicContentGuid = fetchExternalPublicContentGuid;
    }

    public boolean isPublicContentDistributor() {
        return this.publicContentDistributor;
    }

    public void setPublicContentDistributor(boolean publicContentDistributor) {
        this.publicContentDistributor = publicContentDistributor;
    }

    public Map<String, String> getMapCollectionIdToUniqueFieldName() {
        return this.mapCollectionIdToUniqueFieldName;
    }

    public void addCollectionIdToUniqueFieldNameMap(String collectionId, String fieldDisplayName) {
        if (StringUtils.isNotEmpty((String)collectionId) && StringUtils.isNotEmpty((String)fieldDisplayName)) {
            this.mapCollectionIdToUniqueFieldName.put(collectionId, fieldDisplayName);
        }
    }

    public void setMapCollectionIdToUniqueFieldName(Map<String, String> mapCollectionIdToUniqueFieldName) {
        this.mapCollectionIdToUniqueFieldName = mapCollectionIdToUniqueFieldName;
    }

    public void setBuyLinkBaseUrl(String buyLinkBaseUrl) {
        this.buyLinkBaseUrl = buyLinkBaseUrl;
    }

    public String getBuyLinkBaseUrl() {
        return this.buyLinkBaseUrl;
    }

    public Vector<String> getBuyLinkParamName() {
        return this.buyLinkParamName;
    }

    public void setBuyLinkParamName(Vector<String> buyLinkParameName) {
        this.buyLinkParamName = buyLinkParameName;
    }

    public void addBuyLinkParamName(int index, String buyLinkParamName) {
        if (index >= 0 && StringUtils.isNotEmpty((String)buyLinkParamName)) {
            if (this.buyLinkParamName.size() <= index) {
                this.buyLinkParamName.setSize(index + 1);
            }
            this.buyLinkParamName.set(index, buyLinkParamName);
        }
    }

    public Vector<String> getBuyLinkParamSrcField() {
        return this.buyLinkParamSrcField;
    }

    public void setBuyLinkParamSrcField(Vector<String> buyLinkParamSrcField) {
        this.buyLinkParamSrcField = buyLinkParamSrcField;
    }

    public void addBuyLinkParamSrcField(int index, String buyLinkParamSrcField) {
        if (index >= 0 && StringUtils.isNotEmpty((String)buyLinkParamSrcField)) {
            if (this.buyLinkParamSrcField.size() <= index) {
                this.buyLinkParamSrcField.setSize(index + 1);
            }
            this.buyLinkParamSrcField.set(index, buyLinkParamSrcField);
        }
    }

    public Vector<String> getBuyLinkCollectionId() {
        return this.buyLinkCollectionId;
    }

    public void setBuyLinkCollectionId(Vector<String> buyLinkCollectionId) {
        this.buyLinkCollectionId = buyLinkCollectionId;
    }

    public void addBuyLinkCollectionId(int index, String buyLinkCollectionId) {
        if (index >= 0 && StringUtils.isNotEmpty((String)buyLinkCollectionId)) {
            if (this.buyLinkCollectionId.size() <= index) {
                this.buyLinkCollectionId.setSize(index + 1);
            }
            this.buyLinkCollectionId.set(index, buyLinkCollectionId);
        }
    }

    public void setOaiRepositoryName(String oaiRepositoryName) {
        this.oaiRepositoryName = oaiRepositoryName;
    }

    public String getOaiRepositoryName() {
        return this.oaiRepositoryName;
    }

    public void setOaiRepositoryAdminEmail(String oaiRepositoryAdminEmail) {
        this.oaiRepositoryAdminEmail = oaiRepositoryAdminEmail;
    }

    public String getOaiRepositoryAdminEmail() {
        return this.oaiRepositoryAdminEmail;
    }

    public void setOaiAdditionalIdentifiers(String oaiAdditionalIdentifiers) {
        this.oaiAdditionalIdentifiers = oaiAdditionalIdentifiers;
    }

    public String getOaiAdditionalIdentifiers() {
        return this.oaiAdditionalIdentifiers;
    }

    public void setLinkSearchShowDelayMilliSec(int linkSearchShowDelayMilliSec) {
        this.linkSearchShowDelayMilliSec = linkSearchShowDelayMilliSec;
    }

    public int getLinkSearchShowDelayMilliSec() {
        return this.linkSearchShowDelayMilliSec;
    }

    public void setLinkSearchHideDelayMilliSec(int linkSearchHideDelayMilliSec) {
        this.linkSearchHideDelayMilliSec = linkSearchHideDelayMilliSec;
    }

    public int getLinkSearchHideDelayMilliSec() {
        return this.linkSearchHideDelayMilliSec;
    }

    public void setLinkSearchExcludedFields(String linkSearchExcludedFields) {
        this.linkSearchExcludedFields = linkSearchExcludedFields.replace("'", "");
    }

    public String getLinkSearchExcludedFields() {
        return this.linkSearchExcludedFields;
    }

    public boolean isValidateRequestBeforeExport() {
        return this.validateRequestBeforeExport;
    }

    public String getMetaDescription(String key) {
        return this.metaDescription.get(key);
    }

    public String getMetaKeywords(String key) {
        return this.metaKeywords.get(key);
    }

    public String getThumbnailFacetLabel(String key) {
        return this.thumbnailFacetLabel.get(key);
    }

    public Map<String, String> getMetaDescription() {
        return this.metaDescription;
    }

    public Map<String, String> getMetaKeywords() {
        return this.metaKeywords;
    }

    public Map<String, String> getThumbnailFacetLabel() {
        return this.thumbnailFacetLabel;
    }

    public void setMetaKeywords(Map<String, String> metaKeywords) {
        this.metaKeywords = metaKeywords;
    }

    public void setMetaDescription(Map<String, String> metaDescription) {
        this.metaDescription = metaDescription;
    }

    public void addThumbnailFacetLabel(String key, String value) {
        this.thumbnailFacetLabel.put(key, value);
    }

    public void addMetaKeywords(String key, String value) {
        this.metaKeywords.put(key, value);
    }

    public void addMetaDescription(String key, String value) {
        this.metaDescription.put(key, value);
    }

    public void setThumbnailFacetLabel(Map<String, String> thumbnailFacetLabel) {
        this.thumbnailFacetLabel = thumbnailFacetLabel;
    }

    public void setValidateRequestBeforeExport(boolean validateRequestBeforeExport) {
        this.validateRequestBeforeExport = validateRequestBeforeExport;
    }

    public void setAnalyticsEnabled(boolean analyticsEnabled) {
        this.analyticsEnabled = analyticsEnabled;
    }

    public boolean getAnalyticsEnabled() {
        return this.analyticsEnabled;
    }

    public int getValidateExportSize() {
        return this.validateExportSize;
    }

    public void setValidateExportSize(int validateExportSize) {
        this.validateExportSize = validateExportSize;
    }

    public int getValidateExportInterval() {
        return this.validateExportInterval;
    }

    public void setValidateExportInterval(int validateExportInterval) {
        this.validateExportInterval = validateExportInterval;
    }

    public boolean isValidateExportByIP() {
        return this.validateExportByIP;
    }

    public void setValidateExportByIP(boolean validateExportByIP) {
        this.validateExportByIP = validateExportByIP;
    }

    public String getRecaptchaPublicKey() {
        return this.recaptchaPublicKey;
    }

    public void setRecaptchaPublicKey(String recaptchaPublicKey) {
        this.recaptchaPublicKey = recaptchaPublicKey;
    }

    public String getRecaptchaPrivateKey() {
        return this.recaptchaPrivateKey;
    }

    public void setRecaptchaPrivateKey(String recaptchaPrivateKey) {
        this.recaptchaPrivateKey = recaptchaPrivateKey;
    }

    public int getRecaptchaAllowedFailedAttempts() {
        return this.recaptchaAllowedFailedAttempts;
    }

    public void setRecaptchaAllowedFailedAttempts(int recaptchaAllowedFailedAttempts) {
        this.recaptchaAllowedFailedAttempts = recaptchaAllowedFailedAttempts;
    }

    public Vector<String> getOaiOrderedStandardName() {
        return this.oaiOrderedStandardName;
    }

    public void setOaiOrderedStandardName(Vector<String> oaiOrderedStandardName) {
        this.oaiOrderedStandardName = oaiOrderedStandardName;
    }

    public void addOaiOrderedStandardName(int index, String oaiOrderedStandardName) {
        if (index >= 0 && StringUtils.isNotEmpty((String)oaiOrderedStandardName)) {
            if (this.oaiOrderedStandardName.size() <= index) {
                this.oaiOrderedStandardName.setSize(index + 1);
            }
            this.oaiOrderedStandardName.set(index, oaiOrderedStandardName);
        }
    }

    public Vector<String> getOaiOrderedDCField() {
        return this.oaiOrderedDCField;
    }

    public void setOaiOrderedDCField(Vector<String> oaiOrderedDCField) {
        this.oaiOrderedDCField = oaiOrderedDCField;
    }

    public void addOaiOrderedDCField(int index, String oaiOrderedDCField) {
        if (index >= 0 && StringUtils.isNotEmpty((String)oaiOrderedDCField)) {
            if (this.oaiOrderedDCField.size() <= index) {
                this.oaiOrderedDCField.setSize(index + 1);
            }
            this.oaiOrderedDCField.set(index, oaiOrderedDCField);
        }
    }

    public Vector<String> getOaiOrderedStandardFields() {
        return this.oaiOrderedStandardFields;
    }

    public void setOaiOrderedStandardFields(Vector<String> oaiOrderedStandardFields) {
        this.oaiOrderedStandardFields = oaiOrderedStandardFields;
    }

    public void addOaiOrderedStandardFields(int index, String oaiOrderedStandardFields) {
        if (index >= 0 && StringUtils.isNotEmpty((String)oaiOrderedStandardFields)) {
            if (this.oaiOrderedStandardFields.size() <= index) {
                this.oaiOrderedStandardFields.setSize(index + 1);
            }
            this.oaiOrderedStandardFields.set(index, oaiOrderedStandardFields);
        }
    }

    public void addBuyButtonCustomText(int index, String buyButtonCustomText) {
        if (index >= 0 && StringUtils.isNotEmpty((String)buyButtonCustomText)) {
            if (this.buyButtonCustomText.size() <= index) {
                this.buyButtonCustomText.setSize(index + 1);
            }
            this.buyButtonCustomText.set(index, buyButtonCustomText);
        }
    }

    public Vector<String> getBuyButtonCustomText() {
        return this.buyButtonCustomText;
    }

    public void setBuyButtonCustomText(Vector<String> buyButtonCustomText) {
        this.buyButtonCustomText = buyButtonCustomText;
    }

    public Vector<String> getBuyButtonCollectionId() {
        return this.buyButtonCollectionId;
    }

    public void setBuyButtonCollectionId(Vector<String> buyButtonCollectionId) {
        this.buyButtonCollectionId = buyButtonCollectionId;
    }

    public void addBuyButtonCollectionId(int index, String buyButtonCollectionId) {
        if (index >= 0 && StringUtils.isNotEmpty((String)buyButtonCollectionId)) {
            if (this.buyButtonCollectionId.size() <= index) {
                this.buyButtonCollectionId.setSize(index + 1);
            }
            this.buyButtonCollectionId.set(index, buyButtonCollectionId);
        }
    }

    public String getGeoreferencerBaseUrl() {
        return this.georeferencerBaseUrl;
    }

    public void setGeoreferencerBaseUrl(String georeferencerBaseUrl) {
        this.georeferencerBaseUrl = georeferencerBaseUrl;
    }

    public String getGeoreferencerIdField() {
        return this.georeferencerIdField;
    }

    public void setGeoreferencerIdField(String georeferencerIdField) {
        this.georeferencerIdField = georeferencerIdField;
    }

    public void addBuyButtonBaseUrls(int index, String buyButtonBaseUrl) {
        if (index >= 0 && StringUtils.isNotEmpty((String)buyButtonBaseUrl)) {
            if (this.buyButtonBaseUrl.size() <= index) {
                this.buyButtonBaseUrl.setSize(index + 1);
            }
            this.buyButtonBaseUrl.set(index, buyButtonBaseUrl);
        }
    }

    public Vector<String> getBuyButtonBaseUrl() {
        return this.buyButtonBaseUrl;
    }

    public void setBuyButtonBaseUrl(Vector<String> buyButtonBaseUrl) {
        this.buyButtonBaseUrl = buyButtonBaseUrl;
    }

    public String getThumbnailDisplay() {
        return this.thumbnailDisplay;
    }

    public void setThumbnailDisplay(String thumbnailDisplay) {
        this.thumbnailDisplay = thumbnailDisplay;
    }

    public String getHashTags() {
        return this.hashTags;
    }

    public void setHashTags(String hashTags) {
        this.hashTags = hashTags;
    }

    public String getTwitterHandle() {
        return this.twitterHandle;
    }

    public void setTwitterHandle(String twitterHandle) {
        this.twitterHandle = twitterHandle;
    }

    public String getImageViewer() {
        return this.imageViewer;
    }

    public void setImageViewer(String imageViewer) {
        this.imageViewer = imageViewer;
    }

    public String getExternalScriptUrl() {
        return this.externalScriptUrl;
    }

    public void setExternalScriptUrl(String externalScriptUrl) {
        this.externalScriptUrl = externalScriptUrl;
    }

    public String getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(String layoutType) {
        this.layoutType = layoutType;
    }

    public boolean isRecaptchaV3Enabled() {
        return this.recaptchaV3Enabled;
    }

    public void setRecaptchaV3Enabled(boolean recaptchaV3Enabled) {
        this.recaptchaV3Enabled = recaptchaV3Enabled;
    }

    public String getRecaptchaV3SiteKey() {
        return this.recaptchaV3SiteKey;
    }

    public void setRecaptchaV3SiteKey(String recaptchaV3SiteKey) {
        this.recaptchaV3SiteKey = recaptchaV3SiteKey;
    }

    public String getRecaptchaV3SecretKey() {
        return this.recaptchaV3SecretKey;
    }

    public void setRecaptchaV3SecretKey(String recaptchaV3SecretKey) {
        this.recaptchaV3SecretKey = recaptchaV3SecretKey;
    }

    public String getRecaptchaV3WhiteListRegex() {
        return this.recaptchaV3WhiteListRegex;
    }

    public void setRecaptchaV3WhiteListRegex(String recaptchaV3WhiteListRegex) {
        this.recaptchaV3WhiteListRegex = recaptchaV3WhiteListRegex;
    }
}

