/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.lunaimaging.insight.core.domain.AnnotationHistory;
import com.lunaimaging.insight.core.domain.comparator.AnnotationHistoryComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Annotation
implements Serializable {
    private static final long serialVersionUID = 917900953106832610L;
    protected int id;
    protected int userId;
    protected String mediaId;
    protected int mgid;
    protected String color;
    protected String annotation;
    protected String ocrText;
    protected int xPos;
    protected int yPos;
    protected int imgWidth;
    protected int imgHeight;
    protected int fWidth;
    protected int fHeight;
    protected String type;
    protected List<AnnotationHistory> history;
    protected String annotationUri;
    protected String manifestUri;
    protected String collectionUri;
    protected String canvasUri;
    protected String contextUri;
    protected String selector;
    protected String coordinates;
    protected String imageCoordinates;
    protected double score = 1.0;
    protected String source;
    protected String modifiedTimestamp;
    protected int seqno = 0;
    public static final int COLLECTION_ANNOTATION = 0;
    public static final int PRIVATE_ANNOTATION = -1;

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getId() {
        return this.id;
    }

    public int getMgid() {
        return this.mgid;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMgid(int mgid) {
        this.mgid = mgid;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String toString() {
        return "Annotation[" + this.id + "]: " + (this.getAnnotation() != null ? this.getAnnotation() : "");
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(int imgWidth) {
        this.imgWidth = imgWidth;
    }

    public int getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
    }

    public int getfWidth() {
        return this.fWidth;
    }

    public void setfWidth(int fWidth) {
        this.fWidth = fWidth;
    }

    public int getfHeight() {
        return this.fHeight;
    }

    public void setfHeight(int fHeight) {
        this.fHeight = fHeight;
    }

    public String getManifestUri() {
        return this.manifestUri;
    }

    public void setManifestUri(String manifestUri) {
        this.manifestUri = manifestUri;
    }

    public String getCollectionUri() {
        return this.collectionUri;
    }

    public void setCollectionUri(String collectionUri) {
        this.collectionUri = collectionUri;
    }

    public String getCanvasUri() {
        return this.canvasUri;
    }

    public void setCanvasUri(String canvasUri) {
        this.canvasUri = canvasUri;
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public void setContextUri(String contextUri) {
        this.contextUri = contextUri;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getAnnotationUri() {
        return this.annotationUri;
    }

    public void setAnnotationUri(String annotationUri) {
        this.annotationUri = annotationUri;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    @XmlElement(name="xPos")
    @JsonProperty(value="xPos")
    public int getxPos() {
        return this.xPos;
    }

    public void setxPos(int xPos) {
        this.xPos = xPos;
    }

    @XmlElement(name="yPos")
    @JsonProperty(value="yPos")
    public int getyPos() {
        return this.yPos;
    }

    public void setyPos(int yPos) {
        this.yPos = yPos;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public void setModifiedTimestamp(String modifiedTimestamp) {
        this.modifiedTimestamp = modifiedTimestamp;
    }

    public String getImageCoordinates() {
        return this.imageCoordinates;
    }

    public void setImageCoordinates(String imageCoordinates) {
        this.imageCoordinates = imageCoordinates;
    }

    public void addHistory(AnnotationHistory history) {
        if (this.history == null) {
            this.history = new ArrayList<AnnotationHistory>();
        }
        this.history.add(history);
        Collections.sort(this.history, new AnnotationHistoryComparator());
    }

    public AnnotationHistory getLatestChange() {
        if (this.history.size() > 0) {
            return this.history.get(0);
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof Annotation && this.id > 0 && this.id == ((Annotation)obj).id;
    }

    public String getOcrText() {
        return this.ocrText;
    }

    public void setOcrText(String ocrText) {
        this.ocrText = ocrText;
    }

    public List<AnnotationHistory> getHistory() {
        return this.history;
    }

    public void setHistory(List<AnnotationHistory> history) {
        this.history = history;
        Collections.sort(this.history, new AnnotationHistoryComparator());
    }

    public List<String> getSearchableTerms() {
        ArrayList<String> searchList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.annotation)) {
            searchList.add(this.annotation.toLowerCase());
        }
        if (StringUtils.isNotBlank((CharSequence)this.ocrText) && !searchList.contains(this.ocrText.toLowerCase())) {
            searchList.add(this.ocrText.toLowerCase());
        }
        if (this.history != null) {
            for (AnnotationHistory hist : this.history) {
                if (!StringUtils.equals((CharSequence)hist.getCreatorName(), (CharSequence)"mapKurator:ocr") && !StringUtils.equals((CharSequence)hist.getCreatorName(), (CharSequence)"mapKurator:post-ocr-correction") || !StringUtils.isNotBlank((CharSequence)hist.getValue()) || searchList.contains(hist.getValue().toLowerCase())) continue;
                searchList.add(hist.getValue().toLowerCase());
            }
        }
        return searchList;
    }

    public int getSeqno() {
        return this.seqno;
    }

    public void setSeqno(int seqno) {
        this.seqno = seqno;
    }

    public static enum Type {
        TRANSCRIPTION,
        TRANSLATION,
        ANNOTATION,
        LABEL,
        LANDMARK,
        LOGO;

    }
}

