/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.simplecache;

import com.lunaimaging.insight.core.dao.UserActivityDao;
import com.lunaimaging.insight.core.domain.UserActivity;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;

public class SimplecacheUserActivityDao
implements Maintainable,
UserActivityDao {
    protected int maximumUserActivityCache = 5000;
    protected LRUCache userActivityCache = new LRUCache();
    protected LRUCache userActivityByIpCache = new LRUCache();
    private boolean initialized = false;
    protected Log log = LogFactory.getLog(this.getClass());

    public void setMaximumUserActivityCache(int maximumUserActivityCache) {
        this.maximumUserActivityCache = maximumUserActivityCache;
    }

    @Override
    public UserActivity getUserActivity(int userId) throws DataAccessException {
        UserActivity a = null;
        a = (UserActivity)this.userActivityCache.get(userId);
        if (a == null) {
            // empty if block
        }
        return a;
    }

    @Override
    public UserActivity getUserActivity(String ip) throws DataAccessException {
        UserActivity a = null;
        a = (UserActivity)this.userActivityByIpCache.get(ip);
        if (a == null) {
            // empty if block
        }
        return a;
    }

    @Override
    public void saveUserActivity(UserActivity a) throws DataAccessException {
        if (a.getUser() != null) {
            this.userActivityCache.put(a.getUser().getId(), a);
        }
        if (a.getIpAddress() != null) {
            this.userActivityByIpCache.put(a.getIpAddress(), a);
        }
    }

    @Override
    public boolean isUserActivityAvailable(int userId) throws DataAccessException {
        UserActivity a = null;
        a = (UserActivity)this.userActivityCache.get(userId);
        return a == null;
    }

    @Override
    public boolean isUserActivityAvailable(String ipAddress) throws DataAccessException {
        UserActivity a = null;
        a = (UserActivity)this.userActivityByIpCache.get(ipAddress);
        return a == null;
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing UserActivity(s)");
            this.initializeUserActivities();
            this.initialized = true;
        }
    }

    private void initializeUserActivities() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new user activity cache");
        this.userActivityCache = new LRUCache(this.maximumUserActivityCache);
        this.userActivityByIpCache = new LRUCache(this.maximumUserActivityCache);
        this.log.debug((Object)("Completed user activity cache: " + this.userActivityCache.size()));
    }

    @Override
    public void startMaintenance() throws Exception {
        this.userActivityCache.purge();
        this.userActivityByIpCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

