/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.simplecache;

import com.lunaimaging.insight.core.dao.ResumptionTokenDao;
import com.lunaimaging.insight.core.domain.ResumptionToken;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;

public class SimplecacheResumptionTokenDao
implements Maintainable,
ResumptionTokenDao {
    protected int maximumResumptionTokenCache = 5000;
    protected LRUCache resumptionTokensCache = new LRUCache();
    private boolean initialized = false;
    public int resultPageSize = 50;
    protected Log log = LogFactory.getLog(this.getClass());

    public void setMaximumResumptionTokenCache(int maximumResumptionTokenCache) {
        this.maximumResumptionTokenCache = maximumResumptionTokenCache;
    }

    public void setResultPageSize(int resultPageSize) {
        this.resultPageSize = resultPageSize;
    }

    @Override
    public int getResultPageSize() {
        return this.resultPageSize;
    }

    @Override
    public ResumptionToken getResumptionToken(String token) throws DataAccessException {
        ResumptionToken a = null;
        a = (ResumptionToken)this.resumptionTokensCache.get(token);
        if (a == null) {
            // empty if block
        }
        return a;
    }

    @Override
    public void saveResumptionToken(ResumptionToken a) throws DataAccessException {
        this.resumptionTokensCache.put(a.getResumptionToken(), a);
    }

    @Override
    public boolean isResumptionTokenAvailable(String token) throws DataAccessException {
        ResumptionToken a = null;
        a = (ResumptionToken)this.resumptionTokensCache.get(token);
        return a == null;
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing ResumptionToken(s)");
            this.initializeResumptionTokens();
            this.initialized = true;
        }
    }

    private void initializeResumptionTokens() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new resumption tokens cache");
        this.resumptionTokensCache = new LRUCache(this.maximumResumptionTokenCache);
        this.log.debug((Object)("Completed resumption tokens cache: " + this.resumptionTokensCache.size()));
    }

    @Override
    public void startMaintenance() throws Exception {
        this.resumptionTokensCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

