/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.simplecache;

import com.lunaimaging.insight.core.dao.FailedLoginAttemptDao;
import com.lunaimaging.insight.core.domain.FailedLoginAttempt;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;

public class SimplecacheFailedLoginAttemptDao
implements Maintainable,
FailedLoginAttemptDao {
    protected int maximumFailedLoginAttemptCache = 5000;
    protected LRUCache failedLoginAttemptCache = new LRUCache();
    private boolean initialized = false;
    protected Log log = LogFactory.getLog(this.getClass());

    public void setMaximumFailedLoginAttemptCache(int maximumFailedLoginAttemptCache) {
        this.maximumFailedLoginAttemptCache = maximumFailedLoginAttemptCache;
    }

    @Override
    public FailedLoginAttempt getFailedLoginAttempt(String userName) throws DataAccessException {
        FailedLoginAttempt a = null;
        if (userName != null) {
            a = (FailedLoginAttempt)this.failedLoginAttemptCache.get(userName);
        }
        return a;
    }

    @Override
    public void saveFailedLoginAttempt(FailedLoginAttempt a) throws DataAccessException {
        if (a != null && StringUtils.isNotBlank((CharSequence)a.getUserName())) {
            this.failedLoginAttemptCache.put(a.getUserName(), a);
        }
    }

    @Override
    public void removeFailedLoginAttempt(String userName) throws DataAccessException {
        if (userName != null) {
            this.failedLoginAttemptCache.remove(userName);
        }
    }

    @Override
    public boolean isFailedLoginAttemptAvailable(String userName) throws DataAccessException {
        FailedLoginAttempt a = null;
        if (userName != null) {
            a = (FailedLoginAttempt)this.failedLoginAttemptCache.get(userName);
        }
        return a == null;
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing FailedLoginAttempt(s)");
            this.initializeFailedLoginAttempts();
            this.initialized = true;
        }
    }

    private void initializeFailedLoginAttempts() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new failed login attempts cache");
        this.failedLoginAttemptCache = new LRUCache(this.maximumFailedLoginAttemptCache);
        this.log.debug((Object)("Completed failed login attempts cache: " + this.failedLoginAttemptCache.size()));
    }

    @Override
    public void startMaintenance() throws Exception {
        this.failedLoginAttemptCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

