/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.orion;

import com.luna.insight.server.Field;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldValue;
import com.lunaimaging.insight.core.dao.MediaFieldDao;
import com.lunaimaging.insight.core.dao.orion.OrionBaseDao;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.SharedMediaField;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.cache.UnboundCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class OrionMediaFieldDao
extends OrionBaseDao
implements MediaFieldDao,
Maintainable {
    private static List<MediaField> W4MediaFields;
    private static final boolean allowUnknowMediaFields = true;
    protected LRUCache mediaFieldCache = new LRUCache();
    protected LRUCache mediaFieldValueCache = new LRUCache();
    protected LRUCache mediaFieldForStandardsCache = new LRUCache();
    protected UnboundCache w4MediaFieldsCache = new UnboundCache();
    protected UnboundCache summaryMediaFieldsCache = new UnboundCache();
    protected UnboundCache enhancedMediaFieldsCache = new UnboundCache();
    protected UnboundCache previewMediaFieldsCache = new UnboundCache();
    protected UnboundCache displayTitleMediaFieldsCache = new UnboundCache();
    protected int maximumMediaFieldCache;
    protected int maximumMediaFieldValueCache;
    protected int maximumMediaFieldForStandardsCache;
    protected int unqiueValuesThreshold = -1;
    protected boolean initialized = false;
    protected int maximumNumberOfPickListValues;

    public void setMaximumMediaFieldCache(int maximumMediaFieldCache) {
        this.maximumMediaFieldCache = maximumMediaFieldCache;
    }

    public void setMaximumMediaFieldValueCache(int maximumMediaFieldValueCache) {
        this.maximumMediaFieldValueCache = maximumMediaFieldValueCache;
    }

    public void setMaximumMediaFieldForStandardsCache(int maximumMediaFieldForStandardsCache) {
        this.maximumMediaFieldForStandardsCache = maximumMediaFieldForStandardsCache;
    }

    public void setUnqiueValuesThreshold(int unqiueValuesThreshold) {
        this.unqiueValuesThreshold = unqiueValuesThreshold;
    }

    @Override
    public List<MediaFieldValue> getMediaFieldValues(Media media) {
        ArrayList<MediaFieldValue> toReturn = new ArrayList<MediaFieldValue>();
        if (media instanceof LunaMedia) {
            LunaMedia lm = (LunaMedia)media;
            return this.getMediaMetaData(lm);
        }
        return toReturn;
    }

    @Override
    public List<MediaField> getAllMediaFields(List<MediaCollection> mcs) {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (CollectionUtils.isNotEmpty(mcs)) {
            for (MediaCollection mc : mcs) {
                toReturn.addAll(this.getAllMediaFields(mc));
            }
        }
        return toReturn;
    }

    @Override
    public List<MediaField> getAllMediaFields(MediaCollection mc) throws DataAccessException {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (mc != null) {
            if (this.mediaFieldCache.contains(mc.getId())) {
                toReturn.addAll((List)this.mediaFieldCache.get(mc.getId()));
            } else {
                if (mc.getStandardName() == null) {
                    throw new DataRetrievalFailureException("PublisherMedia Collection's standard name can not be null! " + mc);
                }
                try {
                    if (CollectionUtils.isEmpty((Collection)((List)this.enhancedMediaFieldsCache.get(mc.getId())))) {
                        this.initializeEnhancedMediaFieldCache(mc);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)((List)this.enhancedMediaFieldsCache.get(mc.getId())))) {
                        toReturn.removeAll((List)this.enhancedMediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.enhancedMediaFieldsCache.get(mc.getId()));
                    }
                    if (CollectionUtils.isNotEmpty(this.getW4MediaFields(mc))) {
                        toReturn.removeAll((List)this.w4MediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.w4MediaFieldsCache.get(mc.getId()));
                    }
                    if (CollectionUtils.isNotEmpty(this.getSummaryMediaFields(mc))) {
                        toReturn.removeAll((List)this.summaryMediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.summaryMediaFieldsCache.get(mc.getId()));
                    }
                    if (this.previewMediaFieldsCache.contains(mc.getId())) {
                        toReturn.removeAll((List)this.previewMediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.previewMediaFieldsCache.get(mc.getId()));
                    }
                    if (this.displayTitleMediaFieldsCache.contains(mc.getId())) {
                        toReturn.remove(this.displayTitleMediaFieldsCache.get(mc.getId()));
                        toReturn.add((MediaField)this.displayTitleMediaFieldsCache.get(mc.getId()));
                    }
                    for (MediaField mediaField : (List)this.enhancedMediaFieldsCache.get(mc.getId())) {
                        if (toReturn.contains(mediaField)) continue;
                        toReturn.add(mediaField);
                    }
                    this.mediaFieldCache.remove(mc.getId());
                    this.mediaFieldCache.put(mc.getId(), toReturn);
                }
                catch (Exception e) {
                    this.log.error((Object)"problem loading field standard file:", (Throwable)e);
                }
            }
        }
        for (MediaField mf : toReturn) {
            this.log.debug((Object)("___________________ fld:" + mf.getDisplayName()));
        }
        return toReturn;
    }

    private void initializeEnhancedMediaFieldCache(MediaCollection mc) {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        toReturn.add(this.constructMediaField(mc, "_collection", "Collection", -1, -1, 1, true, true));
        Document doc = this.getMediaTemplateDocument(mc);
        if (doc != null) {
            List nodes = doc.selectNodes("//descendant-or-self::field");
            for (Node obj : nodes) {
                Element node = (Element)obj;
                if (node.attributeValue("id") == null) continue;
                try {
                    String name = node.elementText("name");
                    String display_name = node.elementText("display_name");
                    int id = Integer.valueOf(node.attributeValue("id").replaceAll("f(\\-?)", ""));
                    int type = 1;
                    int order = Integer.valueOf(node.elementText("display_order"));
                    boolean date = Boolean.valueOf(node.elementText("is_fuzzy"));
                    boolean sort = Boolean.valueOf(node.elementText("sort_option"));
                    boolean hidden = false;
                    MediaField mf = this.constructMediaField(mc, name, display_name, id, order, type, sort, date);
                    this.log.debug((Object)(mf.toString() + " | " + name + " | " + id));
                    toReturn.add(mf);
                }
                catch (Exception e) {
                    this.log.error((Object)"problem loading field :", (Throwable)e);
                }
            }
        } else {
            this.log.error((Object)"could not read template file");
        }
        this.enhancedMediaFieldsCache.remove(mc.getId());
        this.enhancedMediaFieldsCache.put(mc.getId(), toReturn);
    }

    @Override
    public List<MediaField> getCrossCollectionMediaFields(List<MediaCollection> mcs) throws DataAccessException {
        ArrayList toReturn = new ArrayList();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                String key;
                if (mc == null || !this.w4MediaFieldsCache.contains(key = mc.getId())) continue;
                toReturn.addAll((List)this.w4MediaFieldsCache.get(key));
            }
        }
        return ParsingUtils.removeDuplicateItems(toReturn);
    }

    @Override
    public List<MediaField> getPreviewMediaFields(List<MediaCollection> mcs) throws DataAccessException {
        ArrayList toReturn = new ArrayList();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                String key;
                if (mc == null || !this.previewMediaFieldsCache.contains(key = mc.getId())) continue;
                toReturn.addAll((List)this.previewMediaFieldsCache.get(key));
            }
        }
        return ParsingUtils.removeDuplicateItems(toReturn);
    }

    @Override
    public Map<String, String> getUniqueValues(String term, MediaCollection mc, MediaField mf) {
        if (mc == null) {
            throw new DataRetrievalFailureException("PublisherMedia Collection can not be null! " + mc);
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        return toReturn;
    }

    @Override
    public List<MediaField> getW4MediaFields(MediaCollection mc) throws DataAccessException {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        try {
            if (mc != null && !this.w4MediaFieldsCache.contains(mc.getId())) {
                this.fetchMediaFields(mc);
            }
        }
        catch (InvalidParameterException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        List fields = (List)this.w4MediaFieldsCache.get(mc.getId());
        if (fields != null) {
            toReturn.addAll(fields);
        }
        return toReturn;
    }

    @Override
    public List<MediaField> getW4MediaFields(List<MediaCollection> mcs) throws DataAccessException {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                List<MediaField> fields;
                if (mc == null || (fields = this.getW4MediaFields(mc)) == null) continue;
                toReturn.addAll(fields);
            }
        }
        return toReturn;
    }

    @Override
    public List<MediaField> getSummaryMediaFields(MediaCollection mc) {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        try {
            if (mc != null && !this.summaryMediaFieldsCache.contains(mc.getId())) {
                this.fetchMediaFields(mc);
            }
        }
        catch (InvalidParameterException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        List fields = (List)this.summaryMediaFieldsCache.get(mc.getId());
        if (fields != null) {
            toReturn.addAll(fields);
        }
        return toReturn;
    }

    @Override
    public List<MediaField> getSummaryMediaFields(List<MediaCollection> mcs) {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                List<MediaField> fields;
                if (mc == null || (fields = this.getSummaryMediaFields(mc)) == null) continue;
                toReturn.addAll(fields);
            }
        }
        return toReturn;
    }

    @Override
    public void saveMediaFields(List<MediaField> mfs, MediaCollection mc) throws DataAccessException {
        if (CollectionUtils.isNotEmpty(mfs)) {
            try {
                this.deleteMediaFields(mc);
                ArrayList<MediaField> toSave = new ArrayList<MediaField>();
                for (MediaField mf : mfs) {
                    if (toSave.contains(mf)) continue;
                    toSave.add(mf);
                }
                this.batchInsert(toSave);
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Unable to save media fields", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteMediaFields(MediaCollection mc) throws DataAccessException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("institutionId", mc.getInstitutionId());
            params.put("uniqueCollectionId", mc.getUniqueCollectionId());
            params.put("collectionId", mc.getCollectionId());
            this.deleteObjects(MediaField.class, params);
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Unable to save media fields", (Throwable)e);
        }
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            this.log.debug((Object)"initializing LegacyMediaField Cache(s)");
            if (this.maximumMediaFieldCache > 0) {
                this.mediaFieldCache.setMaximumSize(this.maximumMediaFieldCache);
                this.mediaFieldValueCache.setMaximumSize(this.maximumMediaFieldValueCache);
                this.mediaFieldForStandardsCache.setMaximumSize(this.maximumMediaFieldForStandardsCache);
                W4MediaFields = new ArrayList<MediaField>();
                for (MediaField.W4Type w4Type : MediaField.W4Type.values()) {
                    MediaField mf = new MediaField();
                    mf.setDisplayName(w4Type.getDisplayName());
                    mf.setFieldName(w4Type.name());
                    mf.setW4Type(w4Type.name());
                    W4MediaFields.add(mf);
                }
            }
            this.initialized = true;
            this.log.debug((Object)"completed initializing LegacyMediaField Cache(s)");
        }
    }

    private MediaField constructMediaField(MediaCollection mc, FieldMapping fieldMapping) {
        MediaField toReturn = null;
        if (fieldMapping != null && (toReturn = this.getMediaField(mc.getMediaFields(), fieldMapping.getFieldName())) == null) {
            toReturn = new MediaField();
            toReturn.setFieldName(fieldMapping.getFieldName());
            toReturn.setDisplayName(fieldMapping.getDisplayName());
            toReturn.setFieldId(fieldMapping.getFieldID());
            toReturn.setDisplayOrder(fieldMapping.getDisplayOrder());
            toReturn.setFieldType(fieldMapping.getFieldType());
            toReturn.setSortable(fieldMapping.isSortable());
            toReturn.setDateField(fieldMapping.isDate());
            toReturn.setInstitutionId(mc.getInstitutionId());
            toReturn.setCollectionId(NumberUtils.toInt((String)mc.getCollectionId(), (int)-1));
            toReturn.setUniqueCollectionId(mc.getUniqueCollectionId());
        }
        return toReturn;
    }

    private MediaField constructMediaField(MediaCollection mc, String name, String displayName, int id, int order, int type, boolean sortable, boolean date) {
        MediaField toReturn = null;
        toReturn = new MediaField();
        toReturn.setFieldName(name);
        toReturn.setDisplayName(displayName);
        toReturn.setFieldId(id);
        toReturn.setDisplayOrder(order);
        toReturn.setFieldType(type);
        toReturn.setSortable(sortable);
        toReturn.setDateField(date);
        toReturn.setInstitutionId(mc.getInstitutionId());
        toReturn.setCollectionId(NumberUtils.toInt((String)mc.getCollectionId(), (int)-1));
        toReturn.setUniqueCollectionId(mc.getUniqueCollectionId());
        return toReturn;
    }

    private MediaField constructMediaField(MediaCollection mc, FieldValue fieldValue) {
        MediaField toReturn = null;
        if (fieldValue != null) {
            if (fieldValue.getField() != null) {
                toReturn = this.getMediaField(mc.getMediaFields(), fieldValue.getField().getFieldName());
                if (toReturn == null) {
                    Field field = fieldValue.getField();
                    toReturn = new MediaField();
                    toReturn.setFieldName(field.getFieldName());
                    toReturn.setDisplayName(field.getFieldDisplayName());
                    toReturn.setFieldId(field.getFieldID());
                    toReturn.setDisplayOrder(field.getFieldDisplayOrder());
                    toReturn.setFieldType(field.getFieldType());
                }
            } else if (fieldValue.getFieldMapping() != null) {
                toReturn = this.constructMediaField(mc, fieldValue.getFieldMapping());
            }
        }
        return toReturn;
    }

    private MediaField constructMediaField(String fieldName, String fieldDisplayName, int fieldId, int displayOrder, int fieldType) {
        MediaField toReturn = null;
        toReturn = new MediaField();
        toReturn.setFieldName(fieldName);
        toReturn.setDisplayName(fieldDisplayName);
        toReturn.setFieldId(fieldId);
        toReturn.setDisplayOrder(displayOrder);
        toReturn.setFieldType(fieldType);
        return toReturn;
    }

    private MediaField copyEnhancedProps(MediaField source, MediaField dest) {
        return dest;
    }

    private void fetchMediaFields(MediaCollection mc) throws SQLException, InvalidParameterException {
        if (mc != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("institutionId", mc.getInstitutionId());
            params.put("uniqueCollectionId", mc.getUniqueCollectionId());
            params.put("collectionId", mc.getCollectionId());
            this.initializeEnhancedMediaFieldCache(mc);
            List eFields = (List)this.enhancedMediaFieldsCache.get(mc.getId());
            Class beanClass = mc instanceof SharedMediaCollection ? SharedMediaField.class : MediaField.class;
            List mediaFields = (List)this.constructObjects(beanClass, params);
            ArrayList<MediaField> w4Fields = new ArrayList<MediaField>();
            ArrayList<MediaField> summaryFields = new ArrayList<MediaField>();
            ArrayList<MediaField> previewFields = new ArrayList<MediaField>();
            for (MediaField mf : mediaFields) {
                if (eFields != null && eFields.contains(mf)) {
                    mf = this.copyEnhancedProps((MediaField)eFields.get(eFields.indexOf(mf)), mf);
                }
                if (mf == null) continue;
                if (mf.getType() != null) {
                    w4Fields.add(mf);
                }
                if (mf.isSummaryDescriptionField()) {
                    summaryFields.add(mf);
                }
                if (mf.isPreviewField()) {
                    previewFields.add(mf);
                }
                if (!mf.isDisplayTitleField()) continue;
                this.displayTitleMediaFieldsCache.put(mc.getId(), mf);
            }
            this.w4MediaFieldsCache.put(mc.getId(), w4Fields);
            this.summaryMediaFieldsCache.put(mc.getId(), summaryFields);
            this.previewMediaFieldsCache.put(mc.getId(), previewFields);
        }
    }

    private MediaField getMediaField(List<MediaField> mediaFields, String fieldName) {
        MediaField toReturn = null;
        if (mediaFields != null && fieldName != null) {
            for (MediaField mf : mediaFields) {
                if (mf == null || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName) && !StringUtils.equalsIgnoreCase((String)mf.getDisplayName(), (String)fieldName)) continue;
                toReturn = mf;
                break;
            }
        }
        return toReturn;
    }

    private MediaField getVisibleMediaField(List<MediaField> mediaFields, String fieldName) {
        MediaField toReturn;
        block1: {
            toReturn = null;
            if (mediaFields == null || fieldName == null) break block1;
            for (MediaField mf : mediaFields) {
                if (mf != null && (StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName) || StringUtils.equalsIgnoreCase((String)mf.getDisplayName(), (String)fieldName))) break;
            }
        }
        return toReturn;
    }

    private List<MediaFieldValue> getMediaMetaData(LunaMedia media) {
        Date start = new Date();
        this.log.debug((Object)("getting MediaMetaData for :" + media.toString()));
        ArrayList<MediaFieldValue> toReturn = new ArrayList();
        String key = media.getId();
        if (this.mediaFieldValueCache.contains(key)) {
            toReturn = (List)this.mediaFieldValueCache.get(key);
        } else {
            List<MediaField> mediaFields = this.getAllMediaFields(media.getCollection());
            toReturn.add(new MediaFieldValue(this.getMediaField(mediaFields, "_collection"), media.getCollection().getCollectionName()));
            Document doc = this.getMediaDocument(media);
            if (doc != null) {
                List nodes = doc.selectNodes("//descendant-or-self::entityFieldValue");
                for (Node obj : nodes) {
                    Element node = (Element)obj;
                    String name = node.elementText("fieldName");
                    String val = "";
                    try {
                        MediaField mf;
                        Element vals = node.element("values");
                        for (Object oval : vals.elements("value")) {
                            Element eval = (Element)oval;
                            val = val + eval.getText() + ", ";
                        }
                        if (val.length() > 0) {
                            val = val.substring(0, val.length() - 2);
                        }
                        if ((mf = this.getMediaField(mediaFields, name)) == null) continue;
                        toReturn.add(new MediaFieldValue(mf, val));
                        this.log.debug((Object)(name + ":" + val));
                    }
                    catch (Exception e) {
                        this.log.debug((Object)"error reading text:", (Throwable)e);
                    }
                }
            } else {
                this.log.error((Object)("error reading template file for: " + media.getMediaCollectionId()));
            }
        }
        return toReturn;
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaFieldCache.purge();
        this.mediaFieldValueCache.purge();
        this.mediaFieldForStandardsCache.purge();
        this.w4MediaFieldsCache.purge();
        this.summaryMediaFieldsCache.purge();
        this.enhancedMediaFieldsCache.purge();
        this.previewMediaFieldsCache.purge();
        this.displayTitleMediaFieldsCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public void setMaximumNumberOfPickListValues(int maximumNumberOfPickListValues) {
        this.maximumNumberOfPickListValues = maximumNumberOfPickListValues;
    }

    @Override
    public List<MediaField> getFieldOrderFromCache(String collectionId) {
        return null;
    }
}

