/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.orion;

import com.luna.insight.server.ImageFile;
import com.lunaimaging.insight.core.dao.MediaDao;
import com.lunaimaging.insight.core.dao.orion.OrionBaseDao;
import com.lunaimaging.insight.core.domain.ExternalMedia;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.SharedLunaMedia;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.awt.Dimension;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;

public class OrionMediaDao
extends OrionBaseDao
implements MediaDao {
    protected LRUCache mediaCache = new LRUCache();
    protected LRUCache externalObjectDataCache = new LRUCache();
    protected String mediaTitleColumnName;
    protected List<MediaCollection> allMediaCollections;
    protected String mediaFormat = "";

    public void setMediaCacheMaxSize(int mediaCacheMaxSize) {
        this.mediaCache.setMaximumSize(mediaCacheMaxSize);
    }

    public void setMediaTitleColumnName(String mediaTitleColumnName) {
        this.mediaTitleColumnName = mediaTitleColumnName;
    }

    @Override
    public void setAllMediaCollections(List<MediaCollection> allMediaCollections) {
        this.allMediaCollections = allMediaCollections;
    }

    @Override
    public LunaMedia getLunaMedia(PublisherMedia pm, boolean updateCache) {
        return null;
    }

    @Override
    public LunaMedia getLunaMedia(String id) throws DataAccessException {
        LunaMedia media = null;
        if (this.mediaCache.contains(id)) {
            media = (LunaMedia)this.mediaCache.get(id);
        } else {
            String mediaCollectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(id);
            if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
                MediaCollection mc = this.getMediaCollection(mediaCollectionId);
                this.log.debug((Object)("creating mediaCollection" + mc.toString()));
                if (mc != null) {
                    media = this.constrcutLunaMedia(mc, id);
                }
            }
        }
        return media;
    }

    private LunaMedia constrcutLunaMedia(MediaCollection mc, String mediaId) {
        LunaMedia media = null;
        if (mc != null && StringUtils.isNotEmpty((String)mediaId)) {
            media = mc instanceof SharedMediaCollection ? new SharedLunaMedia() : new LunaMedia();
            media.setId(mediaId);
            media.setCollection(mc);
            media.setMediaId(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId));
            media.setInstitutionId(mc.getInstitutionId());
            media.setObjectId(InsightCoreUtils.getObjectIdFromLunaMediaId(mediaId));
            media.setUniqueCollectionId(String.valueOf(mc.getUniqueCollectionId()));
            this.log.info((Object)(mediaId + ":" + media.toString()));
            this.populateLunaMedia(media);
            this.mediaCache.put(mediaId, media);
        }
        return media;
    }

    private void populateLunaMedia(LunaMedia media) {
        Vector<ImageFile> imageFiles = new Vector<ImageFile>();
        if (media != null && media.getCollection() != null) {
            Date start = new Date();
            Document doc = this.getMediaDocument(media);
            if (doc != null) {
                List nodes = doc.selectNodes("//descendant-or-self::mediaInfo");
                int msize = 0;
                Iterator iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    Node obj = (Node)iterator.next();
                    Element node = (Element)obj;
                    try {
                        int fmt = -1;
                        String url = node.elementText("url");
                        int size = Integer.valueOf(node.elementText("resolutionSize"));
                        int width = Integer.valueOf(node.elementText("width"));
                        int height = Integer.valueOf(node.elementText("height"));
                        int type = Integer.valueOf(node.elementText("mediaType"));
                        String format = node.elementText("mediaFormat");
                        if (size > msize) {
                            msize = size;
                            this.mediaFormat = format;
                        }
                        try {
                            fmt = Integer.parseInt(format);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (format.equalsIgnoreCase("jp2")) {
                            fmt = 13;
                        } else if (format.equalsIgnoreCase("sid")) {
                            fmt = 1;
                        } else if (format.equalsIgnoreCase("jpg")) {
                            fmt = 0;
                        }
                        this.log.debug((Object)("size:" + size + " w:" + width + " h:" + height + " tp:" + type + "format:" + format + "(" + fmt + ") url :" + url));
                        imageFiles.add(new ImageFile(new Dimension(width, height), size, url, fmt, type));
                    }
                    catch (Exception e) {
                        this.log.info((Object)"problem loading image :", (Throwable)e);
                    }
                }
                this.log.info((Object)("Fetched media getImageFiles in " + (new Date().getTime() - start.getTime()) + "ms for media: " + media));
            } else {
                this.log.info((Object)("problem loading images from datafile: " + media.getMediaId()));
            }
            if (CollectionUtils.isNotEmpty(imageFiles)) {
                try {
                    for (ImageFile img : imageFiles) {
                        if (img.getResolution() > media.getMaxLevel()) {
                            media.setMaxLevel(img.getResolution());
                        }
                        switch (img.resolution) {
                            case 0: {
                                media.setUrlSize0(this.prepareStaticImageUrl(img.getUrl()));
                                break;
                            }
                            case 1: {
                                media.setUrlSize1(this.prepareStaticImageUrl(img.getUrl()));
                                break;
                            }
                            case 2: {
                                media.setUrlSize2(this.prepareStaticImageUrl(img.getUrl()));
                                this.log.debug((Object)("setting media Type to:" + ImageFile.getMediaTypeToString((int)img.getMediaType())));
                                media.setType(ImageFile.getMediaTypeToString((int)img.getMediaType()));
                                break;
                            }
                            case 3: {
                                media.setUrlSize3(this.prepareStaticImageUrl(img.getUrl()));
                                break;
                            }
                            case 4: {
                                media.setUrlSize4(this.prepareStaticImageUrl(img.getUrl()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log.info((Object)e);
                }
                media.setFormat(this.mediaFormat);
                this.log.debug((Object)("checking MediaFormat:" + media.getFormat() + " isImage? " + media.isImage()));
                if (!media.isImage()) {
                    ImageFile nonImageFile = this.getNonImageFile(imageFiles);
                    if (nonImageFile != null) {
                        media.setUrlSource(nonImageFile.getUrl());
                    }
                } else {
                    ImageFile largestResolution = this.getLargestResolutionImageFile(imageFiles);
                    this.log.debug((Object)(imageFiles.toString() + "(" + imageFiles.size() + ")"));
                    if (largestResolution != null) {
                        this.log.debug((Object)largestResolution.toString());
                        media.setMaxLevel(largestResolution.getResolution());
                        media.setUrlSource(this.getSourceUrl(largestResolution.getUrl()));
                        this.log.debug((Object)("setting source url:" + media.getUrlSource().toString() + ":" + largestResolution.getResolution()));
                        if (largestResolution.getImageSize() != null) {
                            media.setMaxHeight((int)largestResolution.getImageSize().getHeight());
                            media.setMaxWidth((int)largestResolution.getImageSize().getWidth());
                        }
                    }
                }
            }
            this.log.debug((Object)("Fetched media image urls and max width/height in " + (new Date().getTime() - start.getTime()) + "ms for media: " + media));
        }
    }

    private String prepareStaticImageUrl(String url) {
        return url;
    }

    private String getSourceUrl(String url) {
        String toReturn = "";
        if (url != null) {
            toReturn = url.contains(".sid") ? url.substring(0, url.indexOf(".sid") + 4) : this.prepareStaticImageUrl(url);
        }
        return toReturn;
    }

    private ImageFile getNonImageFile(Vector<ImageFile> imageFiles) {
        ImageFile imf = null;
        if (CollectionUtils.isNotEmpty(imageFiles)) {
            int i = imageFiles.size() - 1;
            while (i >= 0 && i < imageFiles.size()) {
                if ((imf = imageFiles.get(i--)) == null || imf.getResolution() < 2) continue;
                return imf;
            }
        }
        return null;
    }

    private ImageFile getLargestResolutionImageFile(Vector<ImageFile> imageFiles) {
        ImageFile imf = null;
        if (CollectionUtils.isNotEmpty(imageFiles)) {
            int i = imageFiles.size() - 1;
            while (i >= 0 && i < imageFiles.size()) {
                imf = imageFiles.get(i--);
                this.log.debug((Object)("[" + imf.getResolution() + "] " + imf.getFormat() + " " + imf.getUrl()));
                if ((imf == null || imf.getFormat() != 1 && imf.getFormat() != 13) && !this.mediaFormat.equalsIgnoreCase("jp2") && !this.mediaFormat.equalsIgnoreCase("sid")) continue;
                return imf;
            }
        }
        return null;
    }

    private MediaCollection getMediaCollection(String mediaCollectionId) {
        if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
            for (MediaCollection mc : this.allMediaCollections) {
                if (!StringUtils.equalsIgnoreCase((String)mc.getId(), (String)mediaCollectionId)) continue;
                return mc;
            }
        }
        return null;
    }

    @Override
    public ExternalMedia getExternalMedia(String id) {
        ExternalMedia media = (ExternalMedia)this.externalObjectDataCache.get(id);
        if (media == null) {
            try {
                media = this.constructExternalObjectData(id);
                if (media != null) {
                    this.externalObjectDataCache.put(id, media);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
                throw new DataAccessResourceFailureException("Unexpected error, unable to retrieve PublisherMedia!", (Throwable)e);
            }
        }
        if (media == null) {
            throw new DataRetrievalFailureException("Unable to locate image! [" + id + "]");
        }
        return media;
    }

    @Override
    public void saveExternalObjectData(ExternalMedia eod) throws DataAccessException {
        try {
            this.saveObject(eod);
            this.externalObjectDataCache.put(eod.getIdentity(), eod);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created ExternalObjectData", (Throwable)e);
        }
    }

    private ExternalMedia constructExternalObjectData(String id) throws SQLException {
        ExternalMedia media = (ExternalMedia)this.constructObjectOnly(ExternalMedia.class, id);
        return media;
    }

    @Override
    public void getImageFiles(List<String> mediaIds) {
        this.log.info((Object)"called:getMediaFiles()");
    }

    @Override
    public LunaMedia getLunaMedia(String id, boolean updateCache) throws DataAccessException {
        if (updateCache) {
            this.mediaCache.remove(id);
        }
        return this.getLunaMedia(id);
    }

    @Override
    public List<ExternalMedia> getExternalMedias(String query) throws SQLException {
        return null;
    }

    @Override
    public void removeExternalMedia(List<ExternalMedia> mediaList) throws SQLException {
    }

    @Override
    public List<ExternalMedia> getExternalMediaByUser(String userId, String mediaSource) throws SQLException {
        return null;
    }

    @Override
    public Vector<String> getImageExportUrls(String mediaId) throws DataAccessException {
        return null;
    }

    @Override
    public Vector<String> getExternalMediaExportUrls(String mediaId) throws DataAccessException {
        return null;
    }

    @Override
    public Vector<String> getImageExportUrls(PublisherMedia pm) throws DataAccessException {
        return null;
    }
}

