/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.orion;

import com.luna.insight.server.TrinityCollectionInfo;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.MediaCollection;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class OrionBaseDao
extends JdbcBaseDao {
    protected Log log = LogFactory.getLog(this.getClass());
    public static String baseURI = "http://localhost:8081/data/";
    private static HttpClient client = new HttpClient();

    String readFile(String fn) {
        String text = "";
        try {
            String inputLine;
            BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fn), "UTF-8"));
            while ((inputLine = is.readLine()) != null) {
                text = text + inputLine;
            }
            is.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    Document getMediaTemplateDocument(MediaCollection mc) {
        return this.getURIDocument("/" + mc.getInstitutionId() + "-" + mc.getCollectionId() + "-" + mc.getVcId() + "/template-" + mc.getInstitutionId() + "-" + mc.getCollectionId() + "-" + mc.getVcId() + ".xml");
    }

    public String getContent(HttpMethod method) throws IOException {
        String line;
        int response = this.handleConnection(method);
        InputStream in = method.getResponseBodyAsStream();
        StringBuffer sb = new StringBuffer();
        String charset = "utf8";
        BufferedReader inbr = new BufferedReader(new InputStreamReader(in, charset));
        while ((line = inbr.readLine()) != null) {
            sb.append(line + "\r\n");
        }
        return sb.toString();
    }

    private int handleConnection(HttpMethod method) {
        return this.handleConnection(method, 5);
    }

    private int handleConnection(HttpMethod method, int retry) {
        int response = -1;
        if (retry == -1) {
            return response;
        }
        try {
            if (retry != 5) {
                this.log.info((Object)("retrying: " + method.getURI().toString()));
            }
        }
        catch (URIException e1) {
            e1.printStackTrace();
        }
        try {
            client.executeMethod(method);
        }
        catch (SocketException se) {
            se.printStackTrace();
            response = this.handleConnection(method, retry - 1);
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    Document getURIDocument(String fn) {
        Document doc = null;
        String text = null;
        this.log.info((Object)("opening:" + baseURI + fn));
        if (baseURI.toLowerCase().startsWith("http")) {
            try {
                text = this.getContent((HttpMethod)new GetMethod(baseURI + fn));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            text = this.readFile(baseURI + fn);
        }
        if (text != null) {
            try {
                doc = DocumentHelper.parseText(text);
            }
            catch (Exception e) {
                this.log.info((Object)"problem loading images from datafile :", (Throwable)e);
            }
        }
        return doc;
    }

    Document getMediaDocument(LunaMedia media) {
        return this.getURIDocument("/" + media.getInstitutionId() + "-" + media.getCollection().getCollectionId() + "-" + media.getCollection().getVcId() + "/" + media.getInstitutionId() + "-" + media.getCollection().getCollectionId() + "-" + media.getCollection().getVcId() + "-" + media.getObjectId() + ".xml");
    }

    protected TrinityCollectionInfo constructCollectionInfo(MediaCollection mc) {
        TrinityCollectionInfo tci = new TrinityCollectionInfo(mc.getUserId(), mc.getUserName(), mc.getInstitutionId(), mc.getCollectionId(), mc.getServerId(), mc.getCollectionName(), mc.getServerAddress(), mc.getServerPort(), mc.getGroupName(), mc.getGroupKeyCode(), mc.getGroupProfileId());
        tci.setUserCollection(mc.getUserCollection());
        tci.setProfileID(mc.getProfileId());
        tci.setUniqueCollectionID(Integer.valueOf(mc.getUniqueCollectionId()));
        tci.setSessionCodeKey(mc.getSessionCodeKey());
        tci.setSessionGroupName(mc.getSessionGroupName());
        return tci;
    }
}

