/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.lucene;

import com.lunaimaging.insight.core.dao.lucene.LunaMediaDAO;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.search.facet.Facet;
import com.lunaimaging.insight.core.search.facet.Facets;
import com.lunaimaging.insight.core.search.facet.W4Facets;
import com.lunaimaging.publisher.common.dao.SolrMediaDAO;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;

public class SolrLunaMediaDAO
extends SolrMediaDAO
implements LunaMediaDAO<W4Facets, String> {
    protected boolean useStrFieldForExactMatch = false;

    @Override
    public List<String> suggestions(List<MediaCollection> mediaCollections, String fieldName, String prefix) {
        if (mediaCollections == null || mediaCollections.size() == 0 || fieldName == null) {
            return null;
        }
        ArrayList<String> suggestionValues = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (MediaCollection mc : mediaCollections) {
            if (sb.length() == 0) {
                sb.append("(mediaCollectionId:");
            } else {
                sb.append(" AND mediaCollectionId:");
            }
            sb.append(mc.getInstitutionId() + "\\~" + mc.getCollectionId() + "\\~" + mc.getUniqueCollectionId());
        }
        sb.append(")");
        ArrayList facetQueries = new ArrayList();
        ArrayList<String> facetFields = new ArrayList<String>();
        if (this.useStrFieldForExactMatch) {
            facetFields.add(fieldName + "_s");
        } else {
            facetFields.add(fieldName + PublisherMedia._SORTABLE);
        }
        QueryResponse response = this.facetsQuery(sb.toString(), facetQueries, facetFields, prefix);
        if (response != null && facetFields != null) {
            for (String f : facetFields) {
                List count;
                FacetField facetField = response.getFacetField(f);
                if (facetField == null || (count = facetField.getValues()) == null) continue;
                for (FacetField.Count c : count) {
                    String name = c.getName();
                    int num = (int)c.getCount();
                    this.logger.debug((Object)("facet name = " + name + ", count = " + num));
                    if (num == 0) continue;
                    suggestionValues.add(name);
                }
            }
        }
        return suggestionValues;
    }

    @Override
    public W4Facets facets(String qs, List<String> facetQueries, List<String> facetFields, int facetLimit, String sortOption, int minCount) {
        return this.facets(qs, null, facetQueries, facetFields, facetLimit, sortOption, minCount);
    }

    public W4Facets facets(String qs, String filterQuery, List<String> facetQueries, List<String> facetFields, int facetLimit, String sortOption, int minCount) {
        W4Facets facets = new W4Facets();
        QueryResponse response = this.facetsQuery(qs, filterQuery, facetQueries, facetFields, null, facetLimit, sortOption, minCount);
        if (response != null && facetFields != null) {
            for (String f : facetFields) {
                List count;
                FacetField facetField = response.getFacetField(f);
                if (facetField == null || (count = facetField.getValues()) == null) continue;
                for (FacetField.Count c : count) {
                    String name = c.getName();
                    int num = (int)c.getCount();
                    this.logger.debug((Object)("facet name = " + name + ", count = " + num));
                    if (num == 0) continue;
                    if ("_luna_what".equals(f)) {
                        facets.add(new Facet(MediaField.W4Type.WHAT, name, num));
                        continue;
                    }
                    if ("_luna_when".equals(f)) {
                        facets.add(new Facet(MediaField.W4Type.WHEN, name, num));
                        continue;
                    }
                    if ("_luna_where".equals(f)) {
                        facets.add(new Facet(MediaField.W4Type.WHERE, name, num));
                        continue;
                    }
                    if (!"_luna_who".equals(f)) continue;
                    facets.add(new Facet(MediaField.W4Type.WHO, name, num));
                }
            }
        }
        return facets;
    }

    public Facets relatedItemFieldFacets(String qs, List<String> facetQueries, List<String> facetFields, String facetPrefix, int facetLimit, String sortOption, int minCount) {
        Facets facets = new Facets();
        ArrayList<String> fields = new ArrayList<String>();
        for (String ff : facetFields) {
            fields.add("_luna_ri_" + ff.toLowerCase());
        }
        QueryResponse response = this.facetsQuery(qs, facetQueries, fields, facetPrefix, facetLimit, sortOption, minCount);
        if (response != null && response.getFacetFields() != null) {
            List ffs = response.getFacetFields();
            for (FacetField ff : ffs) {
                List count;
                if (ff == null || (count = ff.getValues()) == null) continue;
                for (FacetField.Count c : count) {
                    String name = c.getName();
                    int num = (int)c.getCount();
                    this.logger.debug((Object)("facet name = " + name + ", count = " + num));
                    if (num == 0 || !ff.getName().startsWith("_luna_ri_")) continue;
                    facets.add(new Facet(null, name, num));
                }
            }
        }
        return facets;
    }

    public List<Pair> customFacets(String qs, String filterQuery, List<String> facetQueries, List<MediaField> customFacetFields, int facetLimit, String sortOption, int facetMinCount) {
        ArrayList<Pair> facetList = new ArrayList<Pair>();
        HashMap<MediaField, Facets> results = new HashMap<MediaField, Facets>();
        ArrayList<String> facetFields = new ArrayList<String>();
        HashMap<String, MediaField> customNameToFieldMap = new HashMap<String, MediaField>();
        ArrayList<Object> alphaSortFacetFields = new ArrayList<Object>();
        for (MediaField cff : customFacetFields) {
            String solrFacetField = "_luna_fct_" + PublisherMedia.normalizeField((String)cff.getFacetCustomName());
            customNameToFieldMap.put(solrFacetField, cff);
            facetFields.add(solrFacetField);
            if (cff.isFacetAlphaSorted()) {
                alphaSortFacetFields.add(solrFacetField);
            }
            results.put(cff, new Facets());
        }
        QueryResponse response = this.facetsQuery(qs, filterQuery, facetQueries, facetFields, null, facetLimit, sortOption, facetMinCount, alphaSortFacetFields);
        if (response != null && response.getFacetFields() != null) {
            List ffs = response.getFacetFields();
            for (FacetField ff : ffs) {
                String facetFieldName = ff.getName();
                List count = ff.getValues();
                if (count == null) continue;
                for (FacetField.Count c : count) {
                    MediaField mf;
                    String name = c.getName();
                    int num = (int)c.getCount();
                    this.logger.debug((Object)("Facet field name = " + facetFieldName + ", facet name = " + name + ", count = " + num + (customNameToFieldMap.containsKey(facetFieldName) ? ", field display name = " + ((MediaField)customNameToFieldMap.get(facetFieldName)).getDisplayName() : "")));
                    if (num == 0 || !ff.getName().startsWith("_luna_fct_") || (mf = (MediaField)customNameToFieldMap.get(facetFieldName)) == null || !results.containsKey(mf)) continue;
                    Facets fts = (Facets)results.get(mf);
                    fts.add(new Facet(null, name, num));
                }
            }
        }
        for (MediaField mf : results.keySet()) {
            facetList.add((Pair)new ImmutablePair((Object)mf, results.get(mf)));
        }
        return facetList;
    }

    public void setUseStrFieldForExactMatch(boolean useStrFieldForExactMatch) {
        this.useStrFieldForExactMatch = useStrFieldForExactMatch;
    }
}

