/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.lucene;

import com.lunaimaging.insight.core.dao.MediaSearchDao;
import com.lunaimaging.insight.core.dao.lucene.SolrLunaMediaDAO;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.MediaSearchResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneMediaSearchCriteriaParser;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneMediaSearchResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchCriteriaParserDeprecated;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchResult;
import com.lunaimaging.insight.core.domain.search.lucene.MediaResultProcessor;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.lucene.LuceneResultProcessor;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import com.lunaimaging.publisher.common.solr.SolrServerAdapter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.Query;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.dao.DataRetrievalFailureException;

public class LuceneMediaSearchDao
implements MediaSearchDao,
Maintainable {
    private Log log = LogFactory.getLog(LuceneMediaSearchDao.class);
    private int maximumSearchResults;
    protected List<String> valueDelimeter;
    protected SolrServerAdapter solrServerAdapter;
    protected SolrLunaMediaDAO solrLunaMediaDAO = null;
    protected boolean useStrFieldForExactMatch = false;

    public void setMaximumSearchResults(int maximumSearchResults) {
        this.maximumSearchResults = maximumSearchResults;
    }

    public void setValueDelimeter(List<String> valueDelimeter) {
        this.valueDelimeter = valueDelimeter;
    }

    @Override
    public MediaSearchResult findMedia(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments) throws Exception {
        return this.findMedia(criteria, offset, maximumNumberOfDocuments, this.maximumSearchResults, false, null);
    }

    @Override
    public MediaSearchResult findMedia(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments, boolean fullData) throws Exception {
        return this.findMedia(criteria, offset, maximumNumberOfDocuments, this.maximumSearchResults, fullData, null);
    }

    @Override
    public MediaSearchResult findMedia(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments, int maximumSearchResults) throws Exception {
        return this.findMedia(criteria, offset, maximumNumberOfDocuments, maximumSearchResults, false, null);
    }

    @Override
    public MediaSearchResult findMediaRandomized(MediaSearchCriteria criteria, int maximumNumberOfDocuments, String randomSortSeed) throws Exception {
        return this.findMedia(criteria, 0, maximumNumberOfDocuments, this.maximumSearchResults, false, randomSortSeed);
    }

    private MediaSearchResult findMedia(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments, int maximumSearchResults, boolean fullData, String randomSortSeed) throws Exception {
        LuceneMediaSearchResult toReturn = new LuceneMediaSearchResult();
        LuceneSearchResult result = null;
        try {
            MediaResultProcessor processor = new MediaResultProcessor(this.valueDelimeter);
            Query query = criteria.luceneQuery();
            LuceneSearchCriteriaParserDeprecated parser = LuceneSearchCriteriaParserDeprecated.getInstance();
            parser.setStrFieldForExactMatch(this.useStrFieldForExactMatch);
            String generatedQueryString = parser.generateQueryString(criteria);
            String filterQuery = LuceneSearchCriteriaParserDeprecated.getInstance().generateRestrictionQuery(criteria);
            this.log.info((Object)("Search query :" + generatedQueryString));
            SolrDocument docFor_sortableField = null;
            ArrayList<String> sortFields = null;
            boolean reverse = false;
            if (randomSortSeed != null) {
                sortFields = new ArrayList<String>();
                sortFields.add("random_" + randomSortSeed);
            } else {
                if (criteria.getSortFields().size() > 0) {
                    sortFields = LuceneMediaSearchCriteriaParser.getInstance().getSortFieldNames(criteria, docFor_sortableField);
                }
                if (sortFields != null && criteria.getSortFields().size() == 1 && criteria.getSortOrder() == criteria.REVERSE) {
                    reverse = true;
                }
            }
            this.log.debug((Object)(Thread.currentThread() + " Before fetchDocuments: " + new Date()));
            if (criteria.getInternalMediaIds() != null && criteria.getInternalMediaIds().length > 0) {
                this.log.debug((Object)"Before process solr documents");
                result = processor.processSolrDocuments(this.solrServerAdapter.query(criteria.getInternalMediaIds(), offset, maximumNumberOfDocuments));
            } else {
                this.log.debug((Object)("findMedia(): criteria mediaFields = " + criteria.getMediaFields()));
                ArrayList<String> responseFields = new ArrayList<String>();
                for (MediaField f : criteria.getMediaFields()) {
                    if (responseFields.contains(f.getFieldName())) continue;
                    responseFields.add(f.getFieldName());
                }
                if (fullData) {
                    responseFields = null;
                } else {
                    responseFields.addAll(PublisherMedia.lunaSolrRequiredFields());
                }
                result = this.findMedia(criteria, processor, generatedQueryString, filterQuery, responseFields, sortFields, reverse, offset, maximumNumberOfDocuments);
            }
            this.log.debug((Object)("search result = " + result));
            toReturn = new LuceneMediaSearchResult(result);
            toReturn.addDisplayAttributeName(LuceneDocumentFactory.LuceneAttribute.displayTitle.getAttributeName());
            toReturn.setSearchCriteria(criteria);
            if (this.log.isInfoEnabled()) {
                this.log.debug((Object)(Thread.currentThread() + " returning from findMedia: " + new Date()));
            }
        }
        catch (IOException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)e);
            }
            throw new DataRetrievalFailureException("Unable to access Lucene Index!", (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public void startMaintenance() throws Exception {
    }

    @Override
    public void endMaintenance() throws Exception {
    }

    @Override
    public SolrServerAdapter getSolrServerAdapter() {
        return this.solrServerAdapter;
    }

    @Override
    public void setSolrServerAdapter(SolrServerAdapter s) {
        this.solrServerAdapter = s;
    }

    @Override
    public LuceneSearchResult findMedia(MediaSearchCriteria criteria, LuceneResultProcessor processor, String queryStr, String filterQuery, List<String> responseFields, List<String> sortFields, boolean reverse, int offset, int maximumNumberOfDocuments) throws Exception {
        LuceneSearchResult searchResult = null;
        this.log.debug((Object)("findMedia(..): query = " + queryStr));
        boolean containsPublic = false;
        for (MediaCollection mc : criteria.getCollectionLimit()) {
            if (!mc.isPublicCollection()) continue;
            containsPublic = true;
            break;
        }
        SolrDocumentList docs = this.solrServerAdapter.query(queryStr, filterQuery, responseFields, sortFields, reverse, offset, maximumNumberOfDocuments, containsPublic);
        this.log.debug((Object)("findMedia(..): docs size = " + docs.size()));
        searchResult = processor.processSolrDocumentList(docs, criteria.getCollectionLimit());
        this.log.debug((Object)("findMedia(..): search result = " + searchResult));
        return searchResult;
    }

    @Override
    public String[] findDocumentIds(String queryStr, List<String> sortFields, int offset, int maximumNumberOfDocuments) throws Exception {
        String[] docIds = null;
        if (queryStr == null) {
            throw new InvalidParameterException("Query cannot be null.");
        }
        if (maximumNumberOfDocuments < 1) {
            throw new InvalidParameterException("maximumNumberOfDocuments must be at least 1!");
        }
        this.log.info((Object)(Thread.currentThread() + " Top of LC:fetchDocumentIds " + new Date()));
        SolrQuery query = new SolrQuery();
        query.setQuery(queryStr);
        query.setRows(Integer.valueOf(maximumNumberOfDocuments));
        if (offset >= 0) {
            query.setStart(Integer.valueOf(offset));
        }
        if (sortFields != null) {
            for (int i = 0; i < sortFields.size(); ++i) {
                query.setSortField(sortFields.get(i), SolrQuery.ORDER.asc);
            }
        }
        QueryResponse rsp = null;
        try {
            rsp = this.solrServerAdapter.query(query);
        }
        catch (Exception e) {
            this.log.error((Object)("Solr: message: " + e.getMessage()));
            this.solrServerAdapter.setAuthenticated(false);
            e.printStackTrace();
            throw e;
        }
        SolrDocumentList docs = rsp.getResults();
        if (docs != null && docs.size() > 0) {
            docIds = new String[docs.size()];
            for (int i = 0; i < docs.size(); ++i) {
                Object obj = ((SolrDocument)docs.get(i)).getFieldValue("id");
                if (obj == null) continue;
                docIds[i] = obj.toString();
            }
        }
        return docIds;
    }

    @Override
    public void deleteById(String[] ids) throws Exception {
        List<String> idList = Arrays.asList(ids);
        this.solrServerAdapter.deleteById(idList);
    }

    public SolrLunaMediaDAO getSolrLunaMediaDAO() {
        return this.solrLunaMediaDAO;
    }

    public void setSolrLunaMediaDAO(SolrLunaMediaDAO dao) {
        this.solrLunaMediaDAO = dao;
    }

    public void setUseStrFieldForExactMatch(boolean useStrFieldForExactMatch) {
        this.useStrFieldForExactMatch = useStrFieldForExactMatch;
    }
}

