/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.lucene;

import com.lunaimaging.insight.core.dao.FacetsDao;
import com.lunaimaging.insight.core.dao.lucene.FacetCacheGenerationThread;
import com.lunaimaging.insight.core.dao.lucene.FacetEntry;
import com.lunaimaging.insight.core.dao.lucene.SolrLunaMediaDAO;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.MediaSearchResult;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import com.lunaimaging.insight.core.domain.search.W4SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchCriteriaParserDeprecated;
import com.lunaimaging.insight.core.lucene.LuceneConnectorFactory;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.search.facet.Facets;
import com.lunaimaging.insight.core.search.facet.W4Facets;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import com.techempower.ReflectiveComparator;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.springframework.dao.DataAccessException;

public class LuceneFacetsDao
implements FacetsDao,
Maintainable,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final String TERM_WILD_CARD = "%";
    private static Log log = LogFactory.getLog(LuceneFacetsDao.class);
    protected int[][][] mapDocIdToFieldIndexToUniqueValueId;
    protected String[][] mapDocIdToUniqueValueIds;
    protected List<FacetEntry> uniqueValues;
    protected List<String> unqiueCollectionId;
    protected int[] mapDocIdToCollectionId;
    protected Map<String, List> collectionIdToMediaFieldsMap;
    protected int threshold;
    protected FacetCacheGenerationThread facetsThread;
    protected List<String> facetValueDelimiter;
    protected List<MediaField> mediaFields;
    protected List<String> sortedUniqueValues;
    protected transient boolean initialized;
    protected transient LuceneConnectorFactory luceneConnectorFactory;
    protected int maximumNumberOfValuesPerGivenField = 20;
    protected int[] mapCollectionToMediaCount;
    protected int initalizationDelay = 0;
    protected int initializationFacetCountDelay = 0;
    protected int initializationFacetCountBeforeDelay = 0;
    protected int loggingInterval = 0;
    protected int maximumNumberOfPickListValues;
    protected int facetLimit = 50000;
    protected int facetMinCount = 0;
    protected SolrLunaMediaDAO solrLunaMediaDAO = null;

    public void setLuceneConnectorFactory(LuceneConnectorFactory luceneConnectorFactory) {
        this.luceneConnectorFactory = luceneConnectorFactory;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setMaximumNumberOfValuesPerGivenField(int maximumNumberOfValuesPerGivenField) {
        this.maximumNumberOfValuesPerGivenField = maximumNumberOfValuesPerGivenField;
    }

    public void setFacetValueDelimiter(List<String> delimiter) {
        this.facetValueDelimiter = delimiter;
    }

    public int tempStringIdToInt(String id) {
        int mappedId = 0;
        if (id != null) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                mappedId += c;
            }
        }
        return mappedId;
    }

    @Override
    @Deprecated
    public int[] filterByFacets(MediaSearchResult searchResult) {
        ArrayList<String> filteredIds = new ArrayList<String>();
        if (this.initialized && searchResult != null && searchResult.getSearchCriteria() != null) {
            List<String> uniqueValues = this.geUniqueValuesIndexes(searchResult.getSearchCriteria());
            String[] docIds = searchResult.getResultIds();
            if (docIds != null) {
                for (String docId : docIds) {
                    Object[] uniqueValueIndexes;
                    if (this.tempStringIdToInt(docId) >= this.mapDocIdToUniqueValueIds.length || ArrayUtils.isEmpty((Object[])(uniqueValueIndexes = this.mapDocIdToUniqueValueIds[this.tempStringIdToInt(docId)])) || !ParsingUtils.containsAll((String[])uniqueValueIndexes, uniqueValues)) continue;
                    filteredIds.add(docId);
                }
            }
        }
        return ArrayUtils.toPrimitive((Integer[])filteredIds.toArray(new Integer[0]));
    }

    @Override
    public Facets generateFacets(MediaSearchResult searchResult, String sortOption) {
        return this.generateFacets(searchResult, sortOption, -1);
    }

    @Override
    public Facets generateFacets(MediaSearchResult searchResult, String sortOption, int userFacetLimit) throws DataAccessException, InvalidParameterException {
        if (searchResult == null) {
            throw new InvalidParameterException("SearchResult cannot be null!");
        }
        W4Facets facets = new W4Facets();
        ArrayList<String> facetQueries = new ArrayList<String>();
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add("_luna_what");
        facetFields.add("_luna_when");
        facetFields.add("_luna_where");
        facetFields.add("_luna_who");
        MediaSearchCriteria msc = searchResult.getSearchCriteria();
        List<W4SearchFieldValue> w4SearchFieldValueList = msc.getW4SearchFieldValue();
        if (w4SearchFieldValueList != null) {
            for (W4SearchFieldValue w4fv : w4SearchFieldValueList) {
                this.addFacetQuery(facetQueries, w4fv);
            }
        }
        String luceneQueryString = msc.getLuceneQueryString();
        String filterQuery = LuceneSearchCriteriaParserDeprecated.getInstance().generateRestrictionQuery(msc);
        log.debug((Object)("luceneQueryString = " + luceneQueryString));
        if (userFacetLimit < 0) {
            userFacetLimit = this.facetLimit;
        }
        facets = this.solrLunaMediaDAO.facets(luceneQueryString, filterQuery, facetQueries, facetFields, userFacetLimit, sortOption, this.facetMinCount);
        return facets;
    }

    protected void addFacetQuery(List<String> facetQueries, W4SearchFieldValue w4fv) {
        MediaField.W4Type type = w4fv.getW4Field();
        List<SearchValue> searchValueList = w4fv.getSearchValues();
        for (SearchValue sv : searchValueList) {
            String facetQuery = "_luna_" + type.toString().toLowerCase() + ":" + sv.getValue();
            log.debug((Object)facetQuery);
            facetQueries.add(facetQuery);
        }
    }

    @Override
    public Facets generateFacets(MediaSearchResult searchResult) throws DataAccessException, InvalidParameterException {
        Facets facets = this.generateFacets(searchResult, "count");
        return facets;
    }

    @Override
    public Facets generateFacets(MediaSearchCriteria searchCriteria) {
        String generatedQuery = null;
        if (searchCriteria == null || (generatedQuery = LuceneSearchCriteriaParserDeprecated.getInstance().generateQueryString(searchCriteria)) == null) {
            return null;
        }
        Facets facets = null;
        log.debug((Object)"start generating facets...");
        return facets;
    }

    @Override
    public List<String> getFacetValues(List<MediaField> mediaFields) throws DataAccessException {
        if (this.initialized && CollectionUtils.isEmpty(this.sortedUniqueValues) && CollectionUtils.isNotEmpty(this.uniqueValues)) {
            this.sortedUniqueValues = new ArrayList<String>();
            for (FacetEntry fe : this.uniqueValues) {
                if (fe == null) continue;
                this.sortedUniqueValues.add(fe.getValue());
            }
            Collections.sort(this.sortedUniqueValues);
        }
        return this.sortedUniqueValues;
    }

    @Override
    public Facets generateRelatedItemFacets(MediaCollection mc, String relatedItemField, String prefix, Authenticable authenticable) throws DataAccessException, InvalidParameterException {
        if (relatedItemField == null) {
            throw new InvalidParameterException("relatedItemfield cannot be null!");
        }
        MediaSearchCriteria msc = new MediaSearchCriteria();
        msc.setAuthenticable(authenticable);
        ArrayList<String> fields = new ArrayList<String>();
        msc.addCollectionLimit(mc);
        fields.add(relatedItemField);
        String luceneQueryString = "mediaCollectionId: \"" + mc.getId() + "\"";
        log.debug((Object)("luceneQueryString = " + luceneQueryString));
        Facets facets = this.solrLunaMediaDAO.relatedItemFieldFacets(luceneQueryString, null, fields, prefix, this.facetLimit, "count", 1);
        return facets;
    }

    @Override
    public List<Pair> generateCustomFacets(MediaSearchResult searchResult, String sortOption, int userFacetLimit, List<MediaField> customFacetFields) throws DataAccessException, InvalidParameterException {
        if (searchResult == null) {
            throw new InvalidParameterException("SearchResult cannot be null!");
        }
        if (customFacetFields == null) {
            throw new InvalidParameterException("customFacetNames cannot be null!");
        }
        Collections.sort(customFacetFields, new ReflectiveComparator("getFacetFieldOrder", 2));
        ArrayList<String> facetQueries = new ArrayList<String>();
        MediaSearchCriteria msc = searchResult.getSearchCriteria();
        List<SearchFieldValue> cfFieldValueList = msc.getCfFieldValues();
        if (cfFieldValueList != null) {
            for (SearchFieldValue cfFv : cfFieldValueList) {
                this.addFacetQuery(facetQueries, cfFv);
            }
        }
        String luceneQueryString = msc.getLuceneQueryString();
        String filterQuery = LuceneSearchCriteriaParserDeprecated.getInstance().generateRestrictionQuery(msc);
        log.debug((Object)("luceneQueryString = " + luceneQueryString));
        if (userFacetLimit < 0) {
            userFacetLimit = this.facetLimit;
        }
        return this.solrLunaMediaDAO.customFacets(luceneQueryString, filterQuery, facetQueries, customFacetFields, userFacetLimit, sortOption, this.facetMinCount);
    }

    protected void addFacetQuery(List<String> facetQueries, SearchFieldValue cfFv) {
        List<SearchValue> searchValueList = cfFv.getSearchValues();
        for (SearchValue sv : searchValueList) {
            String facetQuery = "_luna_fct_" + PublisherMedia.normalizeField((String)cfFv.getField()) + ":" + sv.getValue();
            log.debug((Object)facetQuery);
            facetQueries.add(facetQuery);
        }
    }

    @Override
    public int getMediaCount(List<MediaCollection> mcs) {
        int toReturn = 0;
        if (this.initialized && mcs != null) {
            for (MediaCollection mc : mcs) {
                toReturn += this.getMediaCount(mc);
            }
        }
        return toReturn;
    }

    @Override
    public int getMediaCount(MediaCollection mc) {
        int index;
        int toReturn = 0;
        if (this.initialized && mc != null && (index = this.unqiueCollectionId.indexOf(mc.getId())) >= 0 && index < this.mapCollectionToMediaCount.length) {
            toReturn = this.mapCollectionToMediaCount[index];
        }
        return toReturn;
    }

    @Override
    public Map<String, String> getUniqueValues(MediaField.W4Type type, String term) throws DataAccessException {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        if (this.initialized) {
            for (int i = 0; i < this.uniqueValues.size() && toReturn.size() <= this.maximumNumberOfPickListValues; ++i) {
                String value = this.uniqueValues.get(i).getValue();
                if (type == null) {
                    if (term != null && !term.equalsIgnoreCase(TERM_WILD_CARD) && !ParsingUtils.startsWithIgnoreCaseTrim(value, term)) continue;
                    toReturn.put(value, value);
                    continue;
                }
                if (!type.equals((Object)this.uniqueValues.get(i).getType()) || term != null && !term.equalsIgnoreCase(TERM_WILD_CARD) && !ParsingUtils.startsWithIgnoreCaseTrim(value, term)) continue;
                toReturn.put(value, value);
            }
        }
        return toReturn;
    }

    private List<String> geUniqueValuesIndexes(MediaSearchCriteria criteria) {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.initialized && criteria != null && CollectionUtils.isNotEmpty(criteria.getW4SearchFieldValue())) {
            for (W4SearchFieldValue sfv : criteria.getW4SearchFieldValue()) {
                if (sfv == null) continue;
                for (SearchValue sv : sfv.getSearchValues()) {
                    int index = this.uniqueValues.indexOf(new FacetEntry(sv.getValue(), sfv.getW4Field()));
                    if (index < 0) continue;
                    String indexStr = "" + (index + 1);
                    toReturn.add(indexStr);
                }
            }
        }
        return toReturn;
    }

    private void constructMediaFieldMap(List<MediaField> mediaFields) {
        this.collectionIdToMediaFieldsMap = new HashMap<String, List>();
        if (mediaFields != null) {
            for (MediaField mf : mediaFields) {
                String key;
                if (mf == null || (key = InsightCoreUtils.getCollectionIdFromMediaField(mf)) == null) continue;
                if (!this.collectionIdToMediaFieldsMap.containsKey(key)) {
                    this.collectionIdToMediaFieldsMap.put(key, new ArrayList());
                }
                this.collectionIdToMediaFieldsMap.get(key).add(mf);
            }
        }
        this.unqiueCollectionId = new ArrayList<String>(this.collectionIdToMediaFieldsMap.keySet());
        this.mapCollectionToMediaCount = new int[this.unqiueCollectionId.size()];
    }

    protected String[] parseFieldValues(String fieldValue) {
        String[] fieldValues = new String[]{};
        if (CollectionUtils.isNotEmpty(this.facetValueDelimiter) && StringUtils.isNotEmpty((String)fieldValue)) {
            fieldValues = ParsingUtils.splitIgnoreCaseTrim(fieldValue, this.facetValueDelimiter);
        }
        return fieldValues;
    }

    protected void logInfo(String message) {
        this.logInfo(message, true);
    }

    protected void logInfo(String message, boolean includeMemory) {
        if (log.isInfoEnabled()) {
            message = Thread.currentThread() + " " + message;
            if (includeMemory) {
                message = message + Runtime.getRuntime().freeMemory() / 0x100000L + "Mb free of " + Runtime.getRuntime().totalMemory() / 0x100000L + "Mb available";
            }
            log.info((Object)message);
        }
    }

    protected int getUniqueFieldIndex(MediaField mf) {
        return this.getUniqueFieldIndex(this.getMediaFieldsFormMediaCollectionId(InsightCoreUtils.getCollectionIdFromMediaField(mf)), mf);
    }

    protected int getUniqueFieldIndex(List<MediaField> mediaFields, MediaField mf) {
        int fieldIndex = -1;
        if (mf != null) {
            for (int i = 0; i < mediaFields.size(); ++i) {
                if (!mf.equals(mediaFields.get(i))) continue;
                fieldIndex = i;
                break;
            }
        }
        return fieldIndex;
    }

    protected List<MediaField> getMediaFieldsForDoc(Document doc) {
        List<MediaField> toReturn = null;
        if (doc != null) {
            String mediaId = String.valueOf(doc.get(LuceneDocumentFactory.LuceneAttribute.id.getAttributeName()));
            toReturn = this.getMediaFieldsFormMediaId(mediaId);
        }
        return toReturn;
    }

    protected List<MediaField> getMediaFieldsFormMediaId(String mediaId) {
        List<MediaField> toReturn = null;
        if (mediaId != null) {
            String mediaCollectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId);
            toReturn = this.getMediaFieldsFormMediaCollectionId(mediaCollectionId);
        }
        return toReturn;
    }

    protected List<MediaField> getMediaFieldsFormMediaCollectionId(String mediaCollectionId) {
        List toReturn = null;
        if (mediaCollectionId != null) {
            toReturn = this.collectionIdToMediaFieldsMap.get(mediaCollectionId);
        }
        return toReturn;
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaFields = null;
        this.uniqueValues = null;
        this.sortedUniqueValues = null;
        this.mapDocIdToFieldIndexToUniqueValueId = null;
        this.mapDocIdToUniqueValueIds = null;
        this.mapDocIdToCollectionId = null;
        this.unqiueCollectionId = null;
        this.luceneConnectorFactory.closeReader();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
    }

    public int getInitalizationDelay() {
        return this.initalizationDelay;
    }

    public void setInitalizationDelay(int initialSleepLength) {
        this.initalizationDelay = initialSleepLength;
    }

    public int getInitializationFacetCountDelay() {
        return this.initializationFacetCountDelay;
    }

    public void setInitializationFacetCountDelay(int intervalSleepLength) {
        this.initializationFacetCountDelay = intervalSleepLength;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(int documentLoggingInterval) {
        this.loggingInterval = documentLoggingInterval;
    }

    public int getInitializationFacetCountBeforeDelay() {
        return this.initializationFacetCountBeforeDelay;
    }

    public void setInitializationFacetCountBeforeDelay(int documentSleepInterval) {
        this.initializationFacetCountBeforeDelay = documentSleepInterval;
    }

    public void setMaximumNumberOfPickListValues(int maximumNumberOfPickListValues) {
        this.maximumNumberOfPickListValues = maximumNumberOfPickListValues;
    }

    @Override
    public SolrLunaMediaDAO getSolrLunaMediaDAO() {
        return this.solrLunaMediaDAO;
    }

    @Override
    public void setSolrLunaMediaDAO(SolrLunaMediaDAO dao) {
        this.solrLunaMediaDAO = dao;
    }

    public void setFacetLimit(int facetLimit) {
        this.facetLimit = facetLimit;
    }

    public void setFacetMinCount(int facetMinCount) {
        this.facetMinCount = facetMinCount;
    }
}

