/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.lucene;

import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.lucene.LuceneConnectorFactory;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LuceneBaseDao
extends JdbcBaseDao {
    protected Collection<String> simpleSearchTokens;
    protected LuceneConnectorFactory luceneConnectorFactory;
    protected String mediaSearchIndexDirectory;
    protected List<String> facetValueDelimiter;

    public void setLuceneConnectorFactory(LuceneConnectorFactory luceneConnectorFactory) {
        this.luceneConnectorFactory = luceneConnectorFactory;
    }

    public String getMediaSearchIndexDirectory() {
        return this.mediaSearchIndexDirectory;
    }

    public void setMediaSearchIndexDirectory(String mediaSearchIndexDirectory) {
        this.mediaSearchIndexDirectory = mediaSearchIndexDirectory;
    }

    protected List<MediaField> getStorableFields(Media media) {
        MediaCollection mc;
        ArrayList<MediaField> sortableFields = new ArrayList<MediaField>();
        if (media != null && (mc = media.getCollection()) != null) {
            sortableFields.addAll(this.getStorableFields(mc));
        }
        return sortableFields;
    }

    protected List<MediaField> getStorableFields(List<Media> media) {
        ArrayList<MediaField> sortableFields = new ArrayList<MediaField>();
        ArrayList<MediaCollection> mcs = new ArrayList<MediaCollection>();
        for (Media m : media) {
            if (m == null || mcs.contains(m.getCollection())) continue;
            mcs.add(m.getCollection());
        }
        for (MediaCollection mc : mcs) {
            if (mc == null) continue;
            sortableFields.addAll(this.getStorableFields(mc));
        }
        return ParsingUtils.removeDuplicateItems(sortableFields);
    }

    protected List<MediaField> getStorableFields(MediaCollection mc) {
        ArrayList<MediaField> sortableFields = new ArrayList<MediaField>();
        try {
            if (mc != null) {
                sortableFields.addAll(mc.getPreviewMediaFields());
                sortableFields.addAll(mc.getSummaryDescriptionMediaFields());
                sortableFields.addAll(mc.getW4MediaFields());
                sortableFields.addAll(mc.getDefaultCollectionSortFields());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ParsingUtils.removeDuplicateItems(sortableFields);
    }

    public Collection<String> getSimpleSearchTokens() {
        return this.simpleSearchTokens;
    }

    public void setSimpleSearchTokens(Collection<String> simpleSearchTokens) {
        this.simpleSearchTokens = simpleSearchTokens;
    }

    public List<String> getFacetValueDelimiter() {
        return this.facetValueDelimiter;
    }

    public void setFacetValueDelimiter(List<String> delimiter) {
        this.facetValueDelimiter = delimiter;
    }
}

