/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.lucene;

import com.lunaimaging.insight.core.MessageManager;
import com.lunaimaging.insight.core.dao.AnalyticsDao;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaGroup;
import com.lunaimaging.insight.core.domain.Presentation;
import com.lunaimaging.insight.core.domain.search.MediaResult;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.MediaSearchResult;
import com.lunaimaging.insight.core.domain.search.Result;
import com.lunaimaging.insight.core.search.facet.Facet;
import com.lunaimaging.insight.core.search.facet.FacetComparator;
import com.lunaimaging.insight.core.search.facet.Facets;
import com.lunaimaging.insight.core.search.facet.W4Facets;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.context.MessageSource;

public class LuceneAnalyticsGeneratorDao
implements AnalyticsDao {
    private static Log log = LogFactory.getLog(LuceneAnalyticsGeneratorDao.class);
    private String xmlHeaderVersion;
    private String xmlHeaderEncoding;
    private int individualResultsThreshold;
    private int siteMapFileUrlCountThreshold;
    private int totalBytes = 0;
    private int maxBytes = 10470000;
    private String basePagePriority;
    private String basePageFrequency;
    private String detailPagePriority;
    private String detailPageFrequency;
    private String filterTopValuesPagePriority;
    private String filterTopValuesPageFrequency;
    private String filterComboValuesPagePriority;
    private String filterComboValuesPageFrequency;
    private String filterBelowValuesPagePriority;
    private String filterBelowValuesPageFrequency;
    private String filterTopValueAmount;
    private String filterComboValueAmount;
    private String presentationPriority;
    private String presentationFrquency;
    private String groupPriority;
    private String groupFrquency;
    private String siteMapDirectory;
    private String domainName;
    private String appName;
    private String contextName;
    private String[] sitemapProviders;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    Date date = new Date();
    private List<MediaResult> media;
    private MediaSearchCriteria searchCriteria = new MediaSearchCriteria();
    private MediaSearchResult sr = null;
    private W4Facets facets = null;
    private Facets facetBucket = new Facets();
    private MessageSource messageSource;
    Locale locale = Locale.getDefault();
    protected BufferedWriter indexFile;
    protected BufferedWriter siteMapFile;
    protected String siteMapFileName = null;
    protected int siteMapFileCount = 0;
    protected int siteMapURLCount = 0;
    protected List<MediaCollection> collections;
    protected Authenticable authenticable;
    protected String dir = "";
    protected String domain;
    protected String appContext;

    public void setIndividualResultsThreshold(int individualResultsThreshold) {
        this.individualResultsThreshold = individualResultsThreshold;
    }

    public void setSiteMapFileUrlCountThreshold(int siteMapFileUrlCountThreshold) {
        this.siteMapFileUrlCountThreshold = siteMapFileUrlCountThreshold;
    }

    public void setXmlHeaderVersion(String xmlHeaderVersion) {
        this.xmlHeaderVersion = xmlHeaderVersion;
    }

    public void setXmlHeaderEncoding(String xmlHeaderEncoding) {
        this.xmlHeaderEncoding = xmlHeaderEncoding;
    }

    public void setBasePageFrequency(String basePageFrequency) {
        this.basePageFrequency = basePageFrequency;
    }

    public void setBasePagePriority(String basePagePriority) {
        this.basePagePriority = basePagePriority;
    }

    public void setDetailPageFrequency(String detailPageFrequency) {
        this.detailPageFrequency = detailPageFrequency;
    }

    public void setDetailPagePriority(String detailPagePriority) {
        this.detailPagePriority = detailPagePriority;
    }

    public void setFilterBelowValuesPageFrequency(String filterBelowValuesPageFrequency) {
        this.filterBelowValuesPageFrequency = filterBelowValuesPageFrequency;
    }

    public void setFilterBelowValuesPagePriority(String filterBelowValuesPagePriority) {
        this.filterBelowValuesPagePriority = filterBelowValuesPagePriority;
    }

    public void setFilterComboValueAmount(String filterComboValueAmount) {
        this.filterComboValueAmount = filterComboValueAmount;
    }

    public void setFilterComboValuesPageFrequency(String filterComboValuesPageFrequency) {
        this.filterComboValuesPageFrequency = filterComboValuesPageFrequency;
    }

    public void setFilterComboValuesPagePriority(String filterComboValuesPagePriority) {
        this.filterComboValuesPagePriority = filterComboValuesPagePriority;
    }

    public void setFilterTopValueAmount(String filterTopValueAmount) {
        this.filterTopValueAmount = filterTopValueAmount;
    }

    public void setFilterTopValuesPageFrequency(String filterTopValuesPageFrequency) {
        this.filterTopValuesPageFrequency = filterTopValuesPageFrequency;
    }

    public void setFilterTopValuesPagePriority(String filterTopValuesPagePriority) {
        this.filterTopValuesPagePriority = filterTopValuesPagePriority;
    }

    public void setSiteMapDirectory(String siteMapDirectory) {
        this.siteMapDirectory = siteMapDirectory;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setPresentationPriority(String presentationPriority) {
        this.presentationPriority = presentationPriority;
    }

    public void setPresentationFrquency(String presentationFrquency) {
        this.presentationFrquency = presentationFrquency;
    }

    public void setGroupPriority(String groupPriority) {
        this.groupPriority = groupPriority;
    }

    public void setGroupFrquency(String groupFrquency) {
        this.groupFrquency = groupFrquency;
    }

    @Override
    public void generateSiteMap(List<MediaCollection> coll, MediaSearchResult srParam, W4Facets facetsParam, MessageSource messageSourceParam, List<Presentation> presentations, List<MediaGroup> groups) throws SQLException, IOException {
        this.indexFile = null;
        this.siteMapFile = null;
        this.siteMapFileName = null;
        this.siteMapFileCount = 0;
        this.collections = coll;
        this.messageSource = messageSourceParam;
        this.dir = this.siteMapDirectory;
        this.domain = this.domainName;
        this.sr = srParam;
        this.facets = facetsParam;
        this.indexFile = this.makeIndexFile(this.dir);
        this.siteMapFile = this.makeSiteMapFile(this.dir);
        this.initialSearch();
        this.insertBasePages();
        this.insertDetailPages();
        this.insertTopAmount();
        this.insertTopCombinations(2);
        this.insertBelowTopAmount();
        this.insertPresentations(presentations);
        this.insertMediaGroups(groups);
        try {
            this.siteMapFile.write("</urlset>");
            this.siteMapFile.flush();
            this.addSMFToIndex();
            this.indexFile.write("</sitemapindex>");
            this.indexFile.flush();
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
        this.gZip(this.siteMapFile);
        this.closeSiteMapFile(this.indexFile);
        this.closeSiteMapFile(this.siteMapFile);
        this.removeWriter(this.dir);
        for (String provider : this.sitemapProviders) {
            provider = provider + URLEncoder.encode(this.domainName + this.contextName + "/sitemap/sitemap_index.xml", "UTF-8");
            URL url = new URL(provider);
            URLConnection conn = url.openConnection();
            conn.connect();
        }
    }

    private void insertPresentations(List<Presentation> presentations) {
        for (Presentation pres : presentations) {
            if (!pres.isPubliclyViewable()) continue;
            try {
                this.populateSMF(InsightCoreUtils.constructPresentationUrl(this.domainName, this.appContext, pres.getId(), pres, null), this.sdf.format(this.date), this.presentationFrquency, this.presentationPriority);
            }
            catch (IOException e) {
                log.error((Object)"error accessing presentations in sitemap generator", (Throwable)e);
            }
        }
    }

    private void insertMediaGroups(List<MediaGroup> groups) {
        for (MediaGroup group : groups) {
            if (!group.isPubliclyViewable()) continue;
            try {
                this.populateSMF(InsightCoreUtils.constructGroupUrl(this.domainName, this.appContext, group, group.getId(), null), this.sdf.format(this.date), this.groupFrquency, this.groupPriority);
            }
            catch (IOException e) {
                log.error((Object)"error accessing media groups in sitemap generator", (Throwable)e);
            }
        }
    }

    private void initialSearch() {
        if (this.sr != null && !this.sr.isEmpty()) {
            this.facetBucket.addAll(this.facets.getWhat());
            this.facetBucket.addAll(this.facets.getWho());
            this.facetBucket.addAll(this.facets.getWhere());
            this.facetBucket.addAll(this.facets.getWhen());
            this.facetBucket.sort(FacetComparator.Sort.BY_COUNT, FacetComparator.SortOrder.DESC);
            this.media = this.sr.getResults();
        }
    }

    private void checkSiteMapFileSize(String url) throws IOException {
        this.totalBytes += url.getBytes().length;
        if (this.maxBytes <= this.totalBytes || this.siteMapURLCount >= this.siteMapFileUrlCountThreshold) {
            try {
                this.siteMapFile.write("</urlset>");
                this.siteMapFile.flush();
            }
            catch (Exception e) {
                throw new IOException("Unable to write to file for sitemap");
            }
            this.addSMFToIndex();
            this.gZip(this.siteMapFile);
            this.closeSiteMapFile(this.siteMapFile);
            this.removeWriter(this.dir);
            this.totalBytes = 0;
            this.siteMapFile = this.makeSiteMapFile(this.dir);
        }
    }

    private BufferedWriter makeIndexFile(String dir) throws IOException {
        try {
            File folderTest = new File(dir);
            if (!folderTest.exists()) {
                folderTest.mkdirs();
            }
            FileWriter fstream = new FileWriter(dir + "\\sitemap_index.xml");
            BufferedWriter bw = new BufferedWriter(fstream);
            this.addHeader(bw);
            this.addSubHeader(bw, "sitemapindex");
            return bw;
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap:" + this.siteMapDirectory);
        }
    }

    private BufferedWriter makeSiteMapFile(String dir) throws IOException {
        try {
            ++this.siteMapFileCount;
            this.siteMapFileName = "sitemap" + this.siteMapFileCount + ".xml";
            FileWriter fstream = new FileWriter(dir + "\\" + this.siteMapFileName);
            BufferedWriter bw = new BufferedWriter(fstream);
            this.addHeader(bw);
            this.addSubHeader(bw, "urlset");
            return bw;
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void populateSMF(String loc, String lastMod, String changeFreq, String priority) throws IOException {
        if (changeFreq == null) {
            changeFreq = "weekly";
        }
        if (priority == null) {
            priority = "1";
        }
        Element e = new Element("url").addContent((Content)new Element("loc").addContent(loc));
        if (lastMod != null) {
            e.addContent((Content)new Element("lastmod").addContent(lastMod));
        }
        if (changeFreq != null) {
            e.addContent((Content)new Element("changefreq").addContent(changeFreq));
        }
        if (priority != null) {
            e.addContent((Content)new Element("priority").addContent(priority));
        }
        XMLOutputter xmo = new XMLOutputter();
        this.checkSiteMapFileSize(xmo.outputString(e));
        try {
            this.siteMapFile.write(xmo.outputString(e));
            this.siteMapFile.newLine();
            this.siteMapFile.flush();
            ++this.siteMapURLCount;
        }
        catch (Exception e1) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void addHeader(BufferedWriter bw) throws IOException {
        try {
            String header = "<?xml version=\"" + this.xmlHeaderVersion + "\" encoding=\"" + this.xmlHeaderEncoding + "\"?>";
            bw.write(header);
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void addSubHeader(BufferedWriter bw, String type) throws IOException {
        try {
            String subHeader = "<" + type + " xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">";
            bw.write(subHeader);
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void addSMFToIndex() throws IOException {
        try {
            String newSMF = "<sitemap>";
            newSMF = newSMF + "<loc>" + this.domain + this.appContext + "/" + this.siteMapFileName + ".gz</loc>";
            newSMF = newSMF + "<lastmod>" + this.sdf.format(this.date) + "</lastmod>";
            newSMF = newSMF + "</sitemap>";
            this.indexFile.write(newSMF);
            this.indexFile.flush();
            this.siteMapURLCount = 0;
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void insertBasePages() throws IOException {
        String loc = InsightCoreUtils.constructHomePageUrl(this.domain, this.appContext, this.messageSource);
        this.populateSMF(loc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
        this.insertBasicCollectionHomePageURL();
        this.insertBasicCollectionListingPageURL();
        loc = InsightCoreUtils.constructBrowseByCategoryUrl(this.domain, this.appContext, this.messageSource);
        this.populateSMF(loc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
        this.insertTitlePagesURL();
    }

    private void insertBasicBasePageURL(String loc, boolean constructUrl) throws IOException {
        try {
            if (constructUrl) {
                loc = this.domain + this.appContext + loc;
            }
            this.populateSMF(loc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void insertBasicCollectionHomePageURL() throws IOException {
        try {
            String thisLoc = "";
            for (MediaCollection collection : this.collections) {
                thisLoc = InsightCoreUtils.constructMediaCollectionHomePageUrl(this.domain, this.appContext, collection, this.messageSource);
                this.populateSMF(thisLoc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void insertTitlePagesURL() throws IOException {
        try {
            String thisLoc = "";
            StringCharacterIterator cit = new StringCharacterIterator("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
            char ch = cit.first();
            while (ch != '\uffff') {
                thisLoc = InsightCoreUtils.constructBrowseByTitleUrl(this.domain, this.appContext, this.messageSource, Character.valueOf(ch));
                this.populateSMF(thisLoc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
                ch = cit.next();
            }
            thisLoc = InsightCoreUtils.constructBrowseByTitleUrl(this.domain, this.appContext, this.messageSource, "Other");
            this.populateSMF(thisLoc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void insertBasicCollectionListingPageURL() throws IOException {
        try {
            String thisLoc = "";
            for (MediaCollection collection : this.collections) {
                thisLoc = InsightCoreUtils.constructMediaCollectionUrl(this.domain, this.appContext, collection, this.messageSource);
                this.populateSMF(thisLoc, this.sdf.format(this.date), this.basePageFrequency, this.basePagePriority);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to write to file for sitemap");
        }
    }

    private void insertW4FilterPages(String type) throws IOException {
        Facet who;
        List<Object> w4List = new ArrayList();
        if (this.facets != null && type.equalsIgnoreCase(MediaField.W4Type.WHO.getDisplayName())) {
            w4List = this.facets.getWho();
        } else if (this.facets != null && type.equalsIgnoreCase(MediaField.W4Type.WHAT.getDisplayName())) {
            w4List = this.facets.getWhat();
        } else if (this.facets != null && type.equalsIgnoreCase(MediaField.W4Type.WHERE.getDisplayName())) {
            w4List = this.facets.getWhere();
        } else if (this.facets != null && type.equalsIgnoreCase(MediaField.W4Type.WHEN.getDisplayName())) {
            w4List = this.facets.getWhen();
        }
        Iterator<Object> iterator = w4List.iterator();
        while (iterator.hasNext() && (who = (Facet)iterator.next()).getCount() >= this.individualResultsThreshold) {
            String loc = InsightCoreUtils.constructW4Url(this.domain, this.appContext, who.getType().toString(), who.getValue(), this.messageSource.getMessage(MessageManager.MessageKeys.VIEW_ALL_URL.getValue(), null, this.locale), true);
            this.insertBasicBasePageURL(loc, false);
        }
    }

    private void insertDetailPages() throws SQLException, IOException {
        for (Result result : this.media) {
            String loc = InsightCoreUtils.constructDetailUrl(this.domain, this.appContext, this.messageSource.getMessage(MessageManager.MessageKeys.VIEW_DETAIL_URL.getValue(), null, this.locale), result.getIdentity().toString(), result.getDisplayName(), null);
            this.populateSMF(loc, this.sdf.format(this.date), this.detailPageFrequency, this.detailPagePriority);
        }
    }

    private void insertTopAmount() throws IOException {
        int limit = this.facetBucket.getSize() > Integer.valueOf(this.filterTopValueAmount) ? Integer.valueOf(this.filterTopValueAmount).intValue() : this.facetBucket.getSize();
        for (int i = 0; i < limit; ++i) {
            String loc = InsightCoreUtils.constructW4Url(this.domain, this.appContext, this.facetBucket.getFacets().get(i).getType().toString(), this.facetBucket.getFacets().get(i).getValue(), this.messageSource.getMessage(MessageManager.MessageKeys.VIEW_ALL_URL.getValue(), null, this.locale), true);
            this.populateSMF(loc, this.sdf.format(this.date), this.filterTopValuesPageFrequency, this.filterTopValuesPagePriority);
        }
    }

    private void insertBelowTopAmount() throws IOException {
        for (int i = Integer.valueOf(this.filterTopValueAmount).intValue(); i < this.facetBucket.getSize(); ++i) {
            String loc = InsightCoreUtils.constructW4Url(this.domain, this.appContext, this.facetBucket.getFacets().get(i).getType().toString(), this.facetBucket.getFacets().get(i).getValue(), this.messageSource.getMessage(MessageManager.MessageKeys.VIEW_ALL_URL.getValue(), null, this.locale), true);
            this.populateSMF(loc, this.sdf.format(this.date), this.filterBelowValuesPageFrequency, this.filterBelowValuesPagePriority);
        }
    }

    private void insertTopCombinations(int loopNumber) throws IOException {
        int totalCount = 0;
        int totalAllowed = Integer.valueOf(this.filterComboValueAmount);
        ArrayList<Facet> acceptedFacets = new ArrayList<Facet>();
        int i = 0;
        while (totalCount < totalAllowed) {
            int j = 0;
            while (totalCount < totalAllowed) {
                if (!this.facetBucket.getFacets().get(i).getType().toString().equalsIgnoreCase(this.facetBucket.getFacets().get(j).getType().toString())) {
                    acceptedFacets.add(0, this.facetBucket.getFacets().get(i));
                    acceptedFacets.add(1, this.facetBucket.getFacets().get(j));
                    if (loopNumber >= 3) {
                        int k = 0;
                        while (totalCount < totalAllowed) {
                            if (!this.facetBucket.getFacets().get(i).getType().toString().equalsIgnoreCase(this.facetBucket.getFacets().get(k).getType().toString()) && !this.facetBucket.getFacets().get(j).getType().toString().equalsIgnoreCase(this.facetBucket.getFacets().get(k).getType().toString())) {
                                acceptedFacets.add(2, this.facetBucket.getFacets().get(k));
                                if (loopNumber >= 4) {
                                    int m = 0;
                                    while (totalCount < totalAllowed) {
                                        if (!(this.facetBucket.getFacets().get(i).getType().toString().equalsIgnoreCase(this.facetBucket.getFacets().get(m).getType().toString()) || this.facetBucket.getFacets().get(j).getType().toString().equalsIgnoreCase(this.facetBucket.getFacets().get(m).getType().toString()) || this.facetBucket.getFacets().get(k).getType().toString().equalsIgnoreCase(this.facetBucket.getFacets().get(m).getType().toString()))) {
                                            acceptedFacets.add(3, this.facetBucket.getFacets().get(m));
                                            this.insertCombo(acceptedFacets);
                                            acceptedFacets.clear();
                                            ++totalCount;
                                        }
                                        ++m;
                                    }
                                }
                                this.insertCombo(acceptedFacets);
                                acceptedFacets.clear();
                                ++totalCount;
                            }
                            ++k;
                        }
                    }
                    this.insertCombo(acceptedFacets);
                    acceptedFacets.clear();
                    ++totalCount;
                }
                ++j;
            }
            if (totalCount < totalAllowed) {
                if (loopNumber < 4) {
                    this.insertTopCombinations(loopNumber++);
                } else if (loopNumber >= 4) break;
            }
            ++i;
        }
    }

    private void insertCombo(List<Facet> facetsToAdd) throws IOException {
        String loc = InsightCoreUtils.constructW4ComboUrl(this.domain, this.appContext, facetsToAdd, this.messageSource.getMessage(MessageManager.MessageKeys.VIEW_ALL_URL.getValue(), null, this.locale));
        this.populateSMF(loc, this.sdf.format(this.date), this.filterComboValuesPageFrequency, this.filterComboValuesPagePriority);
    }

    private void gZip(BufferedWriter bw) throws FileNotFoundException, IOException {
        try {
            GZIPOutputStream gzip_out_stream;
            File gzip_output = new File(this.dir, "sitemap" + this.siteMapFileCount + ".xml.gz");
            try {
                FileOutputStream out = new FileOutputStream(gzip_output);
                gzip_out_stream = new GZIPOutputStream(new BufferedOutputStream(out));
            }
            catch (IOException e) {
                throw new IOException("Unable to create gzip output file");
            }
            int len = 0;
            int buffBuffer = 10000;
            byte[] input_buffer = new byte[this.maxBytes];
            File f = new File(this.siteMapFileName.toString());
            FileInputStream in = new FileInputStream(this.dir + "//" + f);
            BufferedInputStream source = new BufferedInputStream(in, this.maxBytes);
            while ((len = source.read(input_buffer, 0, this.maxBytes)) != -1) {
                gzip_out_stream.write(input_buffer, 0, len);
            }
            in.close();
            try {
                gzip_out_stream.close();
            }
            catch (IOException e) {
                throw new IOException("Unable to close gzip file");
            }
        }
        catch (Exception e) {
            throw new FileNotFoundException("Unable to gzip compress sitemap file");
        }
    }

    private void closeSiteMapFile(BufferedWriter bw) throws IOException {
        try {
            bw.close();
        }
        catch (Exception e) {
            throw new IOException("Unable to close file for sitemap");
        }
    }

    private void removeWriter(String directory) {
        File f = new File(directory + "\\sitemap" + this.siteMapFileCount + ".xml");
        f.delete();
    }

    public void setSitemapProviders(String[] sitemapProviders) {
        this.sitemapProviders = sitemapProviders;
    }

    public String[] getSitemapProviders() {
        return this.sitemapProviders;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }
}

