/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.lucene;

import com.lunaimaging.insight.core.dao.lucene.LuceneFacetsDao;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;

@Deprecated
public class FacetCacheGenerationThread
extends Thread
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected static Log log = LogFactory.getLog(FacetCacheGenerationThread.class);
    boolean forceStop = false;
    protected transient IndexReader reader = null;
    protected LuceneFacetsDao luceneFacetsDao;
    protected String facetCacheFileName = "facetCache";

    public FacetCacheGenerationThread(LuceneFacetsDao lfd) {
        this.luceneFacetsDao = lfd;
    }

    void initializeCache() {
        try {
            if (this.forceStop) {
                return;
            }
            this.reader = this.luceneFacetsDao.luceneConnectorFactory.getReader();
            FacetCacheGenerationThread.sleep(this.luceneFacetsDao.initalizationDelay);
        }
        catch (IOException e) {
            log.error((Object)"Error ", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error ", (Throwable)e);
        }
    }

    @Override
    public void run() {
        boolean restored = this.restoreFacetCache(this.luceneFacetsDao.luceneConnectorFactory.getFacetCacheDirectory() + File.separator + this.facetCacheFileName);
        try {
            if (this.forceStop || restored) {
                return;
            }
            this.initializeCache();
            this.generateFacetCache();
            this.debugInfo("Completed facets cache generation: uniqueValues[" + this.luceneFacetsDao.uniqueValues.size() + "]", true);
        }
        catch (Exception e) {
            log.error((Object)"Error generating threaded facets cache: ", (Throwable)e);
        }
        if (!restored && this.luceneFacetsDao.initialized && this.luceneFacetsDao != null) {
            this.saveFacetCache(this.luceneFacetsDao.luceneConnectorFactory.getFacetCacheDirectory() + File.separator + this.facetCacheFileName);
        }
    }

    public String getFacetCacheFileName() {
        return this.facetCacheFileName;
    }

    public void setFacetCacheFileName(String name) {
        this.facetCacheFileName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFacetCache(String file) {
        log.debug((Object)("Saving the facet cache to: " + file));
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(file);
            out = new ObjectOutputStream(fos);
            out.writeObject(this.luceneFacetsDao);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean restoreFacetCache(String file) {
        if (this.luceneFacetsDao.luceneConnectorFactory.facetCacheDirectoryUpdateRequired()) {
            return false;
        }
        File f = new File(file);
        if (!f.exists()) {
            return false;
        }
        boolean restored = false;
        log.debug((Object)("Start restoring the facet cache from: " + file));
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            log.debug((Object)"Reading the facet cache.");
            LuceneFacetsDao restoredDao = (LuceneFacetsDao)in.readObject();
            in.close();
            log.debug((Object)"Restored the facet cache.");
            restored = true;
            this.luceneFacetsDao.collectionIdToMediaFieldsMap = restoredDao.collectionIdToMediaFieldsMap;
            this.luceneFacetsDao.mapCollectionToMediaCount = restoredDao.mapCollectionToMediaCount;
            this.luceneFacetsDao.mapDocIdToCollectionId = restoredDao.mapDocIdToCollectionId;
            this.luceneFacetsDao.mapDocIdToFieldIndexToUniqueValueId = restoredDao.mapDocIdToFieldIndexToUniqueValueId;
            this.luceneFacetsDao.mapDocIdToUniqueValueIds = restoredDao.mapDocIdToUniqueValueIds;
            this.luceneFacetsDao.maximumNumberOfPickListValues = restoredDao.maximumNumberOfPickListValues;
            this.luceneFacetsDao.maximumNumberOfValuesPerGivenField = restoredDao.maximumNumberOfValuesPerGivenField;
            this.luceneFacetsDao.mediaFields = restoredDao.mediaFields;
            this.luceneFacetsDao.sortedUniqueValues = restoredDao.sortedUniqueValues;
            this.luceneFacetsDao.threshold = restoredDao.threshold;
            this.luceneFacetsDao.unqiueCollectionId = restoredDao.unqiueCollectionId;
            this.luceneFacetsDao.uniqueValues = restoredDao.uniqueValues;
            this.luceneFacetsDao.initialized = true;
        }
        catch (InvalidClassException ice) {
            log.error((Object)("message = " + ice.getMessage()));
            ice.printStackTrace();
        }
        catch (IOException e) {
            log.error((Object)("message = " + e.getMessage()));
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("message = " + e.getMessage()));
            e.printStackTrace();
        }
        return restored;
    }

    @Deprecated
    protected void generateFacetCache() {
    }

    protected void debugInfo(String message) {
        this.debugInfo(message, true);
    }

    protected void debugInfo(String message, boolean includeMemory) {
        if (log.isDebugEnabled()) {
            if (includeMemory) {
                message = message + Runtime.getRuntime().freeMemory() / 0x100000L + "Mb free of " + Runtime.getRuntime().totalMemory() / 0x100000L + "Mb available";
            }
            log.debug((Object)message);
        }
    }

    protected void delayFacetCount(int docId) {
        if (docId % this.luceneFacetsDao.initializationFacetCountBeforeDelay == 0) {
            try {
                log.debug((Object)("Facet Count sleep for " + this.luceneFacetsDao.initializationFacetCountDelay + "ms."));
                FacetCacheGenerationThread.sleep(this.luceneFacetsDao.initializationFacetCountDelay);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
    }

    protected void logFacetStatus(int docId, int totalDocuments) {
        if (docId % this.luceneFacetsDao.loggingInterval == 0 && this.luceneFacetsDao != null && this.luceneFacetsDao.uniqueValues != null) {
            this.debugInfo("FacetCache on docId " + docId + " of " + totalDocuments + " with " + this.luceneFacetsDao.uniqueValues.size() + " unique values. ");
        }
    }
}

