/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.legacy;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.FieldValueGroup;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.MediaField;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.ObjectDataRecord;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.TrinityCollectionInfo;
import com.lunaimaging.insight.core.dao.MediaFieldDao;
import com.lunaimaging.insight.core.dao.legacy.LegacyBaseDao;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.SharedMediaField;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.cache.UnboundCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.MediaFieldUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class LegacyMediaFieldDao
extends LegacyBaseDao
implements MediaFieldDao,
Maintainable {
    protected Log log = LogFactory.getLog(this.getClass());
    private static List<com.lunaimaging.insight.core.domain.MediaField> W4MediaFields;
    protected LRUCache mediaFieldCache = new LRUCache();
    protected LRUCache mediaFieldValueCache = new LRUCache();
    protected LRUCache mediaFieldForStandardsCache = new LRUCache();
    protected LRUCache groupInfoCache = new LRUCache();
    protected UnboundCache w4MediaFieldsCache = new UnboundCache();
    protected UnboundCache summaryMediaFieldsCache = new UnboundCache();
    protected UnboundCache previewMediaFieldsCache = new UnboundCache();
    protected UnboundCache displayTitleMediaFieldsCache = new UnboundCache();
    protected UnboundCache remainingDefaultSortCache = new UnboundCache();
    protected UnboundCache mediaFieldOrderCache = new UnboundCache();
    protected int maximumMediaFieldCache;
    protected int maximumMediaFieldValueCache;
    protected int maximumMediaFieldForStandardsCache;
    protected int unqiueValuesThreshold = -1;
    protected boolean initialized = false;
    protected int maximumNumberOfPickListValues;
    protected int showMediaInfo = 1;

    public void setMaximumMediaFieldCache(int maximumMediaFieldCache) {
        this.maximumMediaFieldCache = maximumMediaFieldCache;
    }

    public void setMaximumMediaFieldValueCache(int maximumMediaFieldValueCache) {
        this.maximumMediaFieldValueCache = maximumMediaFieldValueCache;
    }

    public void setMaximumMediaFieldForStandardsCache(int maximumMediaFieldForStandardsCache) {
        this.maximumMediaFieldForStandardsCache = maximumMediaFieldForStandardsCache;
    }

    public void setUnqiueValuesThreshold(int unqiueValuesThreshold) {
        this.unqiueValuesThreshold = unqiueValuesThreshold;
    }

    public void setShowMediaInfo(int showMediaInfo) {
        this.showMediaInfo = showMediaInfo >= 1 ? 1 : 0;
    }

    private void updateFieldOrderCache(String collectionId, List<MediaFieldValue> mfvs) {
        List<com.lunaimaging.insight.core.domain.MediaField> mfList = new ArrayList();
        if (mfvs == null) {
            return;
        }
        for (MediaFieldValue mfv : mfvs) {
            mfList.add(mfv.getField());
        }
        mfList = ParsingUtils.removeDuplicateItems(mfList);
        if (!this.mediaFieldOrderCache.contains(collectionId)) {
            if (mfList.size() > 0) {
                this.mediaFieldOrderCache.put(collectionId, mfList);
            }
        } else if (mfList.size() > ((List)this.mediaFieldOrderCache.get(collectionId)).size()) {
            this.mediaFieldOrderCache.put(collectionId, mfList);
        }
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getFieldOrderFromCache(String collectionId) {
        return (List)this.mediaFieldOrderCache.get(collectionId);
    }

    @Override
    public List<MediaFieldValue> getMediaFieldValues(Media media) {
        if (!this.isLuna6) {
            return this.getSolrMediaFieldValues(media);
        }
        return this.getMediaFieldValuesOriginal(media);
    }

    public List<MediaFieldValue> getSolrMediaFieldValues(Media media) {
        ArrayList<MediaFieldValue> toReturn = new ArrayList<MediaFieldValue>();
        if (media instanceof LunaMedia) {
            LunaMedia lm = (LunaMedia)media;
            this.log.debug((Object)("getSolrMediaFieldValues(..): solrMediaDAO has been set = " + (this.solrMediaDAO != null)));
            PublisherMedia pm = this.solrMediaDAO.findByMediaId(lm.getId());
            if (pm == null) {
                this.log.error((Object)("getSolrMediaFieldValues(..): could not obtain a publisher media with id = " + lm.getId()));
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("publisher media = " + pm.toString()));
            }
            this.log.debug((Object)("getSolrMediaFieldValues(..) Publisher Media id = " + lm.getId()));
            String key = lm.getId();
            if (lm.getCollection() != null) {
                MediaCollection mc = lm.getCollection();
                Set fieldNameSet = pm.getFieldNames();
                MediaFieldValue mediaFieldValue = null;
                HashMap entityFieldValues = new HashMap();
                for (String fieldName : fieldNameSet) {
                    if (fieldName == null) continue;
                    com.lunaimaging.insight.core.domain.MediaField mediaField = MediaFieldUtils.constructMediaField(mc, fieldName, pm);
                    this.log.debug((Object)("getSolrMediaFieldValues(..) fieldName = " + fieldName));
                    if (mediaField == null || mediaField.getDisplayOrder() < 0) continue;
                    String fieldValue = null;
                    if (mediaField.getParentName() != null && !fieldName.startsWith("_luna_media_") && !fieldName.startsWith("_luna_display_entity_")) {
                        for (String thisFieldName : fieldNameSet) {
                            if (!thisFieldName.startsWith("_luna_display_entity_" + fieldName + "_#")) continue;
                            List fieldValueList = pm.getFieldValueList(thisFieldName);
                            if (fieldValueList != null && fieldValueList.size() > 1) {
                                for (int j = 0; j < fieldValueList.size(); ++j) {
                                    String value = (String)fieldValueList.get(j);
                                    mediaFieldValue = new MediaFieldValue(mediaField, value);
                                    String hierarchyStr = thisFieldName.substring(thisFieldName.indexOf("_luna_display_entity_") + "_luna_display_entity_".length() + fieldName.length() + 1);
                                    MediaFieldUtils.constructEntityFieldValues(hierarchyStr, mediaFieldValue, entityFieldValues);
                                }
                                continue;
                            }
                            fieldValue = pm.getFieldValue(thisFieldName);
                            mediaFieldValue = new MediaFieldValue(mediaField, fieldValue);
                            String hierarchyStr = thisFieldName.substring(thisFieldName.indexOf("_luna_display_entity_") + "_luna_display_entity_".length() + fieldName.length() + 1);
                            MediaFieldUtils.constructEntityFieldValues(hierarchyStr, mediaFieldValue, entityFieldValues);
                        }
                        continue;
                    }
                    List fieldValueList = pm.getFieldValueList(fieldName);
                    if (fieldValueList != null && fieldValueList.size() > 1) {
                        for (int j = fieldValueList.size() - 1; j >= 0; --j) {
                            String value = (String)fieldValueList.get(j);
                            mediaFieldValue = new MediaFieldValue(mediaField, value);
                            toReturn.add(0, mediaFieldValue);
                        }
                        continue;
                    }
                    fieldValue = pm.getFieldValue(fieldName);
                    if (fieldName.startsWith("_luna_collection")) {
                        mediaField.setDisplayOrder(1);
                    }
                    if (fieldValue != null) {
                        mediaFieldValue = new MediaFieldValue(mediaField, fieldValue);
                    }
                    toReturn.add(0, mediaFieldValue);
                }
                this.updateFieldOrderCache(lm.getMediaCollectionId(), new ArrayList<MediaFieldValue>(toReturn));
                Collections.sort(toReturn);
                this.mediaFieldValueCache.put(key, new ArrayList<MediaFieldValue>(toReturn));
                if (this.showMediaInfo == 1) {
                    toReturn.addAll(this.getMediaMetaData(pm));
                }
                if (this.log.isDebugEnabled()) {
                    this.testFieldDisplayOrder(mc);
                }
                MediaFieldUtils.addEntityFields(toReturn, MediaFieldUtils.getEntityFields(entityFieldValues));
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaFieldValue> getMediaFieldValuesOriginal(Media media) {
        List<MediaFieldValue> toReturn = new ArrayList<MediaFieldValue>();
        if (media instanceof LunaMedia) {
            LunaMedia lm = (LunaMedia)media;
            String key = lm.getId();
            if (this.mediaFieldValueCache.contains(key) && (toReturn = (List)this.mediaFieldValueCache.get(key)).size() == 0) {
                this.mediaFieldValueCache.remove(key);
            }
            if (!this.mediaFieldValueCache.contains(key)) {
                InsightSmartClient isc = null;
                if (lm.getCollection() != null) {
                    try {
                        FieldValue aField;
                        MediaCollection mc = lm.getCollection();
                        TrinityCollectionInfo tci = this.constructCollectionInfo(mc);
                        isc = new InsightSmartClient(tci);
                        Vector values = isc.getFullInformation((long)lm.getObjectId(), (CollectionKey)tci, mc.getStandardName());
                        boolean hasFieldGroup = false;
                        for (Object obj : values) {
                            if (!(obj instanceof FieldValue)) continue;
                            aField = (FieldValue)obj;
                            if (!aField.isFieldGroupName) continue;
                            hasFieldGroup = true;
                            break;
                        }
                        ObjectDataRecord odr = null;
                        if (hasFieldGroup) {
                            odr = isc.getFullObjectData((long)lm.getObjectId(), (CollectionKey)tci, mc.getStandardName());
                        }
                        for (Object obj : values) {
                            if (obj instanceof FieldValue) {
                                aField = (FieldValue)obj;
                                if (aField.getValue() == null) continue;
                                com.lunaimaging.insight.core.domain.MediaField mediaField = MediaFieldUtils.constructMediaField(mc, aField);
                                if (aField.isFieldGroupName) {
                                    mediaField.setFieldName(this.getFieldNamesForFieldGroup(odr, aField));
                                }
                                if (mediaField == null) continue;
                                MediaFieldValue mediaFieldValue = new MediaFieldValue(mediaField, aField.getValue());
                                toReturn.add(mediaFieldValue);
                                continue;
                            }
                            this.log.error((Object)("unknow field value type from CollectionManger: field: " + obj));
                        }
                        this.updateFieldOrderCache(lm.getMediaCollectionId(), new ArrayList<MediaFieldValue>(toReturn));
                        if (this.showMediaInfo == 1) {
                            toReturn.addAll(this.getMediaMetaData(lm));
                        }
                        this.mediaFieldValueCache.put(key, new ArrayList<MediaFieldValue>(toReturn));
                    }
                    finally {
                        if (isc != null) {
                            isc.closeConnections();
                        }
                    }
                }
            }
        }
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getAllMediaFields(List<MediaCollection> mcs) {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        if (CollectionUtils.isNotEmpty(mcs)) {
            for (MediaCollection mc : mcs) {
                toReturn.addAll(this.getAllMediaFields(mc));
            }
        }
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getAllMediaFields(MediaCollection mc) throws DataAccessException {
        if (!this.isLuna6) {
            return this.getAllMediaFieldsFromDB(mc);
        }
        return this.getAllMediaFieldsOriginal(mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<com.lunaimaging.insight.core.domain.MediaField> getAllMediaFieldsFromDB(MediaCollection mc) throws DataAccessException {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        if (mc != null) {
            if (this.mediaFieldCache.contains(mc.getId()) && !((List)this.mediaFieldCache.get(mc.getId())).isEmpty()) {
                toReturn.addAll((List)this.mediaFieldCache.get(mc.getId()));
            } else {
                if (mc.getStandardName() == null) {
                    throw new DataRetrievalFailureException("PublisherMedia Collection's standard name can not be null! " + mc);
                }
                try {
                    com.lunaimaging.insight.core.domain.MediaField mf = null;
                    mf = mc instanceof SharedMediaCollection ? new SharedMediaField() : new com.lunaimaging.insight.core.domain.MediaField();
                    StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(mf.getClass()).getTableName());
                    query.append(" WHERE INSTITUTIONID = '" + mc.getInstitutionId() + "'");
                    query.append(" AND UNIQUECOLLECTIONID = '" + mc.getUniqueCollectionId() + "'");
                    query.append(" AND COLLECTIONID = '" + mc.getCollectionId() + "'");
                    this.log.debug((Object)("getAllMediaFieldsFromDB(.), query = " + query));
                    List mfList = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(com.lunaimaging.insight.core.domain.MediaField.class));
                    this.mediaFieldCache.put(mc.getId(), new ArrayList(mfList));
                    toReturn.addAll(mfList);
                    this.log.debug((Object)("getAllMediaFieldsFromDB(..): List of MediaField = " + mfList));
                }
                catch (Exception e) {
                    this.log.error((Object)("getAllMediaFieldsFromDB(..): message = " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        return toReturn;
    }

    public List<com.lunaimaging.insight.core.domain.MediaField> getAllMediaFieldsOriginal(MediaCollection mc) throws DataAccessException {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        if (mc != null) {
            if (this.mediaFieldCache.contains(mc.getId())) {
                toReturn.addAll((List)this.mediaFieldCache.get(mc.getId()));
            } else {
                if (mc.getStandardName() == null) {
                    throw new DataRetrievalFailureException("PublisherMedia Collection's standard name can not be null! " + mc);
                }
                InsightSmartClient isc = this.getInsightSmartClient(mc);
                if (isc == null) {
                    return null;
                }
                InsightSmartClient.setWaitLimit((long)3000L);
                try {
                    if (CollectionUtils.isNotEmpty(this.getW4MediaFields(mc))) {
                        toReturn.removeAll((List)this.w4MediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.w4MediaFieldsCache.get(mc.getId()));
                    }
                    if (CollectionUtils.isNotEmpty(this.getSummaryMediaFields(mc))) {
                        toReturn.removeAll((List)this.summaryMediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.summaryMediaFieldsCache.get(mc.getId()));
                    }
                    if (this.previewMediaFieldsCache.contains(mc.getId())) {
                        toReturn.removeAll((List)this.previewMediaFieldsCache.get(mc.getId()));
                        toReturn.addAll((List)this.previewMediaFieldsCache.get(mc.getId()));
                    }
                    if (this.displayTitleMediaFieldsCache.contains(mc.getId())) {
                        toReturn.remove(this.displayTitleMediaFieldsCache.get(mc.getId()));
                        toReturn.add((com.lunaimaging.insight.core.domain.MediaField)this.displayTitleMediaFieldsCache.get(mc.getId()));
                    }
                    if (this.remainingDefaultSortCache.contains(mc.getId()) && !toReturn.contains(mc.getId())) {
                        toReturn.remove((List)this.remainingDefaultSortCache.get(mc.getId()));
                        toReturn.addAll((List)this.remainingDefaultSortCache.get(mc.getId()));
                    }
                    this.log.debug((Object)("Fetching Field Standard found for: " + mc));
                    FieldStandard fs = isc.getFieldStandard(mc.getStandardName());
                    if (fs != null) {
                        Vector fieldMappings = fs.getFieldMappings();
                        if (!CollectionUtils.isEmpty((Collection)fieldMappings)) {
                            for (FieldMapping fm : fieldMappings) {
                                com.lunaimaging.insight.core.domain.MediaField mediaField;
                                if (fm == null || !fm.isDataFieldSearchable() || (mediaField = MediaFieldUtils.constructMediaField(mc, fm)) == null || toReturn.contains(mediaField)) continue;
                                toReturn.add(mediaField);
                            }
                            this.mediaFieldCache.put(mc.getId(), new ArrayList<com.lunaimaging.insight.core.domain.MediaField>(toReturn));
                            this.log.debug((Object)("Completed Fetching Field Standard found for: " + mc));
                        }
                    } else {
                        this.log.debug((Object)("No Field Standard found for: " + mc + " with standard name: " + mc.getStandardName()));
                        toReturn = null;
                    }
                }
                catch (InvalidParameterException e) {
                    this.log.error((Object)("Error getting media fields for collection: " + mc), (Throwable)e);
                    throw new DataRetrievalFailureException("Error getting media fields for collection: " + mc, (Throwable)e);
                }
                finally {
                    if (isc != null) {
                        isc.closeConnections();
                    }
                }
            }
        }
        return toReturn;
    }

    public List<com.lunaimaging.insight.core.domain.MediaField> getExtraFields() {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        com.lunaimaging.insight.core.domain.MediaField processedDate = new com.lunaimaging.insight.core.domain.MediaField(1000, 1, "_processedDate", "Processed Date", 1000);
        processedDate.setSortable(true);
        toReturn.add(processedDate);
        com.lunaimaging.insight.core.domain.MediaField processedDateMilli = new com.lunaimaging.insight.core.domain.MediaField(1001, 1, "_processedDateMilli", "Processed Date (epoch)", 1001);
        processedDateMilli.setSortable(true);
        toReturn.add(processedDateMilli);
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getCrossCollectionMediaFields(List<MediaCollection> mcs) throws DataAccessException {
        ArrayList toReturn = new ArrayList();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                String key;
                if (mc == null || !this.w4MediaFieldsCache.contains(key = mc.getId())) continue;
                toReturn.addAll((List)this.w4MediaFieldsCache.get(key));
            }
        }
        return ParsingUtils.removeDuplicateItems(toReturn);
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getPreviewMediaFields(List<MediaCollection> mcs) throws DataAccessException {
        ArrayList toReturn = new ArrayList();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                String key;
                if (mc == null || !this.previewMediaFieldsCache.contains(key = mc.getId())) continue;
                toReturn.addAll((List)this.previewMediaFieldsCache.get(key));
            }
        }
        return ParsingUtils.removeDuplicateItems(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUniqueValues(String term, MediaCollection mc, com.lunaimaging.insight.core.domain.MediaField mf) {
        if (mc == null) {
            throw new DataRetrievalFailureException("PublisherMedia Collection can not be null! " + mc);
        }
        GroupInformation gInfo = null;
        if (this.groupInfoCache.contains(mc.getId())) {
            gInfo = (GroupInformation)this.groupInfoCache.get(mc.getId());
        } else {
            gInfo = this.getGroupInfo(mc);
            this.groupInfoCache.put(mc.getId(), gInfo);
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        InsightSmartClient isc = this.getInsightSmartClient(mc);
        try {
            FieldMapping fieldMapping = new FieldMapping(mf.getFieldId());
            fieldMapping.setDisplayName(mf.getDisplayName());
            fieldMapping.setFieldName(mf.getFieldName());
            fieldMapping.setFieldType(mf.getFieldType());
            UniqueListResultProgressListener rpl = new UniqueListResultProgressListener(gInfo);
            Vector<UniqueListResultProgressListener> v = new Vector<UniqueListResultProgressListener>();
            v.add(rpl);
            CriterionValue[] criterionValues = isc.getUniqueList(fieldMapping, v, 3, term, this.unqiueValuesThreshold, null, null, false);
            if (criterionValues != null) {
                for (CriterionValue cv : criterionValues) {
                    if (toReturn.size() >= this.maximumNumberOfPickListValues || cv == null || !StringUtils.isNotEmpty((String)cv.getDisplayValue()) || !StringUtils.isNotEmpty((String)cv.getSearchValue())) continue;
                    toReturn.put(cv.getDisplayValue(), cv.getSearchValue());
                }
            }
        }
        finally {
            if (isc != null) {
                isc.closeConnections();
            }
        }
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getW4MediaFields(MediaCollection mc) throws DataAccessException {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        try {
            if (mc != null && !this.w4MediaFieldsCache.contains(mc.getId())) {
                this.fetchMediaFields(mc);
            }
        }
        catch (InvalidParameterException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        List fields = (List)this.w4MediaFieldsCache.get(mc.getId());
        if (fields != null) {
            toReturn.addAll(fields);
        }
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getW4MediaFields(List<MediaCollection> mcs) throws DataAccessException {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                List<com.lunaimaging.insight.core.domain.MediaField> fields;
                if (mc == null || (fields = this.getW4MediaFields(mc)) == null) continue;
                toReturn.addAll(fields);
            }
        }
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getSummaryMediaFields(MediaCollection mc) {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        try {
            if (mc != null && !this.summaryMediaFieldsCache.contains(mc.getId())) {
                this.fetchMediaFields(mc);
            }
        }
        catch (InvalidParameterException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unable to fetch w4 media fields", (Throwable)e);
        }
        List fields = (List)this.summaryMediaFieldsCache.get(mc.getId());
        if (fields != null) {
            toReturn.addAll(fields);
        }
        return toReturn;
    }

    @Override
    public List<com.lunaimaging.insight.core.domain.MediaField> getSummaryMediaFields(List<MediaCollection> mcs) {
        ArrayList<com.lunaimaging.insight.core.domain.MediaField> toReturn = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                List<com.lunaimaging.insight.core.domain.MediaField> fields;
                if (mc == null || (fields = this.getSummaryMediaFields(mc)) == null) continue;
                toReturn.addAll(fields);
            }
        }
        return toReturn;
    }

    @Override
    public void saveMediaFields(List<com.lunaimaging.insight.core.domain.MediaField> mfs, MediaCollection mc) throws DataAccessException {
        if (CollectionUtils.isNotEmpty(mfs)) {
            try {
                this.deleteMediaFields(mc);
                ArrayList<com.lunaimaging.insight.core.domain.MediaField> toSave = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
                for (com.lunaimaging.insight.core.domain.MediaField mf : mfs) {
                    this.log.debug((Object)("to save: field name = " + mf.getFieldName()));
                    if (toSave.contains(mf)) continue;
                    toSave.add(mf);
                    this.log.debug((Object)("added to save:  " + mf.getFieldName()));
                }
                this.batchInsert(toSave);
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Unable to save media fields", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteMediaFields(MediaCollection mc) throws DataAccessException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("institutionId", mc.getInstitutionId());
            params.put("uniqueCollectionId", mc.getUniqueCollectionId());
            params.put("collectionId", mc.getCollectionId());
            this.deleteObjects(com.lunaimaging.insight.core.domain.MediaField.class, params);
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Unable to save media fields", (Throwable)e);
        }
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            this.log.debug((Object)"initializing LegacyMediaField Cache(s)");
            if (this.maximumMediaFieldCache > 0) {
                this.mediaFieldCache.setMaximumSize(this.maximumMediaFieldCache);
                this.mediaFieldValueCache.setMaximumSize(this.maximumMediaFieldValueCache);
                this.mediaFieldForStandardsCache.setMaximumSize(this.maximumMediaFieldForStandardsCache);
                this.groupInfoCache.setMaximumSize(this.maximumNumberOfPickListValues);
                W4MediaFields = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
                for (MediaField.W4Type w4Type : MediaField.W4Type.values()) {
                    com.lunaimaging.insight.core.domain.MediaField mf = new com.lunaimaging.insight.core.domain.MediaField();
                    mf.setDisplayName(w4Type.getDisplayName());
                    mf.setFieldName(w4Type.name());
                    mf.setW4Type(w4Type.name());
                    W4MediaFields.add(mf);
                }
            }
            this.initialized = true;
            this.log.debug((Object)"completed initializing LegacyMediaField Cache(s)");
        }
    }

    private void testFieldDisplayOrder(MediaCollection mc) {
        List<com.lunaimaging.insight.core.domain.MediaField> fields = mc.getMediaFields();
        StringBuilder sb = new StringBuilder();
        sb.append("\nfield display order: \n");
        for (com.lunaimaging.insight.core.domain.MediaField mf : fields) {
            String name = mf.getDisplayName();
            sb.append("Name = " + name + ", disporder = " + mf.getDisplayOrder() + "\n");
        }
        this.log.debug((Object)sb.toString());
    }

    private void fetchMediaFields(MediaCollection mc) throws SQLException, InvalidParameterException {
        if (mc != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("institutionId", mc.getInstitutionId());
            params.put("uniqueCollectionId", mc.getUniqueCollectionId());
            params.put("collectionId", mc.getCollectionId());
            Class beanClass = mc instanceof SharedMediaCollection ? SharedMediaField.class : com.lunaimaging.insight.core.domain.MediaField.class;
            List mediaFields = (List)this.constructObjects(beanClass, params);
            ArrayList<com.lunaimaging.insight.core.domain.MediaField> w4Fields = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
            ArrayList<com.lunaimaging.insight.core.domain.MediaField> summaryFields = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
            ArrayList<com.lunaimaging.insight.core.domain.MediaField> previewFields = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
            ArrayList<com.lunaimaging.insight.core.domain.MediaField> defaultSortFields = new ArrayList<com.lunaimaging.insight.core.domain.MediaField>();
            for (com.lunaimaging.insight.core.domain.MediaField mf : mediaFields) {
                if (mf == null) continue;
                if (mf.getType() != null) {
                    w4Fields.add(mf);
                }
                if (mf.isSummaryDescriptionField()) {
                    summaryFields.add(mf);
                }
                if (mf.isPreviewField()) {
                    previewFields.add(mf);
                }
                if (mf.isDisplayTitleField()) {
                    this.displayTitleMediaFieldsCache.put(mc.getId(), mf);
                }
                if (mf.getDefaultCollectionSort() <= 0 || mf.getType() != null || mf.isSummaryDescriptionField() || mf.isPreviewField() || mf.isDisplayTitleField()) continue;
                defaultSortFields.add(mf);
            }
            this.w4MediaFieldsCache.put(mc.getId(), w4Fields);
            this.summaryMediaFieldsCache.put(mc.getId(), summaryFields);
            this.previewMediaFieldsCache.put(mc.getId(), previewFields);
            this.remainingDefaultSortCache.put(mc.getId(), defaultSortFields);
        }
    }

    private List<MediaFieldValue> getMediaMetaData(PublisherMedia pm) {
        ArrayList<MediaFieldValue> toReturn = new ArrayList<MediaFieldValue>();
        if (pm != null) {
            com.lunaimaging.insight.core.domain.MediaField mediaField = new com.lunaimaging.insight.core.domain.MediaField();
            mediaField.setDisplayOrder(10000);
            String value = pm.getFieldValue("mediaId");
            mediaField.setDisplayName("Image ID");
            MediaFieldValue mfv = new MediaFieldValue(mediaField, value);
            mfv.setMetaData(true);
            toReturn.add(mfv);
            mediaField = new com.lunaimaging.insight.core.domain.MediaField();
            mediaField.setDisplayOrder(10010);
            value = pm.getFieldValueWithLastIndex("_luna_resolutionSize_");
            mediaField.setDisplayName("Resolution Size");
            mfv = new MediaFieldValue(mediaField, value);
            mfv.setMetaData(true);
            toReturn.add(mfv);
            mediaField = new com.lunaimaging.insight.core.domain.MediaField();
            mediaField.setDisplayOrder(10020);
            value = pm.getFieldValueWithLastIndex("_luna_media_format_");
            String format = "";
            try {
                int temp = Integer.valueOf(value);
                format = ImageFile.getFormatTypeToString((int)temp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mediaField.setDisplayName("Format");
            mfv = new MediaFieldValue(mediaField, format);
            mfv.setMetaData(true);
            toReturn.add(mfv);
            mediaField = new com.lunaimaging.insight.core.domain.MediaField();
            mediaField.setDisplayOrder(10030);
            value = pm.getFieldValue("mediaType");
            mediaField.setDisplayName("Media Type");
            try {
                this.log.debug((Object)("media type = " + value));
                value = ImageFile.getMediaTypeToString((int)Media.MediaType.toImageFileMediaType(value));
                mfv = new MediaFieldValue(mediaField, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mfv.setMetaData(true);
            toReturn.add(mfv);
            mediaField = new com.lunaimaging.insight.core.domain.MediaField();
            mediaField.setDisplayOrder(10040);
            value = pm.getFieldValueWithLastIndex("_luna_media_width_");
            mediaField.setDisplayName("Width");
            mfv = new MediaFieldValue(mediaField, value);
            mfv.setMetaData(true);
            toReturn.add(mfv);
            mediaField = new com.lunaimaging.insight.core.domain.MediaField();
            mediaField.setDisplayOrder(10050);
            value = pm.getFieldValueWithLastIndex("_luna_media_height_");
            mediaField.setDisplayName("Height");
            mfv = new MediaFieldValue(mediaField, value);
            mfv.setMetaData(true);
            toReturn.add(mfv);
        }
        return toReturn;
    }

    private List<MediaFieldValue> getMediaMetaData(LunaMedia media) {
        Date start = new Date();
        ArrayList<MediaFieldValue> toReturn = new ArrayList<MediaFieldValue>();
        InsightSmartClient isc = this.getInsightSmartClient(media.getCollection());
        TrinityCollectionInfo tci = this.constructCollectionInfo(media.getCollection());
        MediaMetaData mediaData = isc.getFullMediaData((long)media.getMediaId(), (CollectionKey)tci, media.getMaxLevel());
        this.log.debug((Object)("fetched media data from CollectionManager in " + (new Date().getTime() - start.getTime()) + "ms for media " + media));
        if (mediaData != null) {
            Vector fields = mediaData.getMediaFields();
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    if (!(fields.get(i) instanceof MediaField)) continue;
                    MediaField mf = (MediaField)fields.get(i);
                    com.lunaimaging.insight.core.domain.MediaField mediaField = new com.lunaimaging.insight.core.domain.MediaField();
                    mediaField.setDisplayName(mf.getName());
                    MediaFieldValue mfv = new MediaFieldValue(mediaField, mf.getValue());
                    mfv.setMetaData(true);
                    toReturn.add(mfv);
                }
            }
            this.log.debug((Object)("Completly loaded full media information in " + (new Date().getTime() - start.getTime()) + "ms for media " + media));
        }
        return toReturn;
    }

    private String getFieldNamesForFieldGroup(ObjectDataRecord objectDataRecord, FieldValue fieldValue) {
        String toReturn = "";
        if (objectDataRecord == null) {
            return toReturn;
        }
        Vector groupedFieldValues = objectDataRecord.getGroupedFieldValues();
        for (Object obj : groupedFieldValues) {
            FieldValueGroup fvg = (FieldValueGroup)obj;
            if (!fvg.getGroupName().equalsIgnoreCase(fieldValue.displayName)) continue;
            for (Object o : fvg.getFieldValues()) {
                FieldValue fv = (FieldValue)o;
                if (toReturn.length() > 0) {
                    toReturn = toReturn + "]|#";
                }
                if (fv.getField() != null) {
                    toReturn = toReturn + fv.getField().getFieldName();
                    continue;
                }
                toReturn = toReturn + fv.displayName;
            }
        }
        return toReturn;
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaFieldCache.purge();
        this.mediaFieldValueCache.purge();
        this.mediaFieldForStandardsCache.purge();
        this.groupInfoCache.purge();
        this.w4MediaFieldsCache.purge();
        this.summaryMediaFieldsCache.purge();
        this.previewMediaFieldsCache.purge();
        this.displayTitleMediaFieldsCache.purge();
        this.remainingDefaultSortCache.purge();
        this.mediaFieldOrderCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public void setMaximumNumberOfPickListValues(int maximumNumberOfPickListValues) {
        this.maximumNumberOfPickListValues = maximumNumberOfPickListValues;
    }

    public class UniqueListResultProgressListener
    implements ResultsProgressListener {
        protected GroupInformation groupInfo = null;

        public UniqueListResultProgressListener(GroupInformation g) {
            this.groupInfo = g;
        }

        public GroupInformation getGroupInfo() {
            return this.groupInfo;
        }

        public void serverContacted(boolean successful) {
        }

        public void findingPage() {
        }

        public void setResultCounts(int totalHitCount, int actualCount) {
        }

        public void setResultProgress(int progress) {
        }

        public void resultLoadComplete() {
        }

        public void resultLoadFailed() {
        }
    }
}

