/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.legacy;

import com.luna.insight.client.media.Jp2URL;
import com.luna.insight.client.media.SidURL;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.TrinityCollectionInfo;
import com.lunaimaging.insight.core.MessageManager;
import com.lunaimaging.insight.core.dao.MediaDao;
import com.lunaimaging.insight.core.dao.legacy.LegacyBaseDao;
import com.lunaimaging.insight.core.domain.ExternalMedia;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.SharedLunaMedia;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.utils.ImageInfoUtils;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.UrlUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.awt.Dimension;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;

public class LegacyMediaDao
extends LegacyBaseDao
implements MediaDao {
    protected LRUCache mediaCache = new LRUCache();
    protected LRUCache mediaImageCache = new LRUCache();
    protected LRUCache externalObjectDataCache = new LRUCache();
    protected LRUCache mediaExportUrlsCache = new LRUCache();
    protected LRUCache mediaDateCache = new LRUCache();
    protected String mediaTitleColumnName;
    protected List<MediaCollection> allMediaCollections;

    public void setMediaCacheMaxSize(int mediaCacheMaxSize) {
        this.mediaCache.setMaximumSize(mediaCacheMaxSize);
        this.mediaImageCache.setMaximumSize(mediaCacheMaxSize);
        this.mediaExportUrlsCache.setMaximumSize(mediaCacheMaxSize);
    }

    public void setMediaTitleColumnName(String mediaTitleColumnName) {
        this.mediaTitleColumnName = mediaTitleColumnName;
    }

    @Override
    public void setAllMediaCollections(List<MediaCollection> allMediaCollections) {
        this.allMediaCollections = allMediaCollections;
    }

    @Override
    public LunaMedia getLunaMedia(PublisherMedia pm, boolean updateCache) throws DataAccessException {
        if (pm == null || pm.id() == null) {
            this.log.debug((Object)"Media is null or Media id is null.");
            return null;
        }
        boolean isCacheExpired = false;
        if (this.mediaDateCache.contains(pm.id())) {
            String processedDateMilli = String.valueOf(this.mediaDateCache.get(pm.id()));
            if (pm.getLastEditedTime() != null && !pm.getLastEditedTime().equals(processedDateMilli)) {
                isCacheExpired = true;
            }
        }
        if (updateCache || isCacheExpired) {
            this.mediaCache.remove(pm.id());
            this.mediaImageCache.remove(InsightCoreUtils.getCollectionIdFromLunaMediaId(pm.id()) + "~" + InsightCoreUtils.getMediaIdFromLunaMediaId(pm.id()));
            this.mediaDateCache.remove(pm.id());
        }
        return this.getLunaMedia(pm);
    }

    @Override
    public LunaMedia getLunaMedia(String id, boolean updateCache) {
        if (updateCache) {
            this.mediaCache.remove(id);
            this.mediaImageCache.remove(InsightCoreUtils.getCollectionIdFromLunaMediaId(id) + "~" + InsightCoreUtils.getMediaIdFromLunaMediaId(id));
            this.mediaDateCache.remove(id);
        }
        return this.getLunaMedia(id);
    }

    public LunaMedia getLunaMedia(PublisherMedia pm) throws DataAccessException {
        if (pm == null || pm.id() == null) {
            return null;
        }
        String id = pm.id();
        LunaMedia media = null;
        if (this.mediaCache.contains(id) && (media = (LunaMedia)this.mediaCache.get(id)).getUrlSize0() == null) {
            this.mediaCache.remove(id);
            this.mediaImageCache.remove(InsightCoreUtils.getCollectionIdFromLunaMediaId(id) + "~" + InsightCoreUtils.getMediaIdFromLunaMediaId(id));
            this.mediaDateCache.remove(id);
        }
        if (!this.mediaCache.contains(id)) {
            String mediaCollectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(id);
            if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
                MediaCollection mc = this.getMediaCollection(mediaCollectionId);
                this.log.info((Object)"Reteived the media collection Info");
                if (mc != null) {
                    media = this.constrcutLunaMediaFromSolr(mc, pm);
                }
            }
            this.log.info((Object)"Constructed the Luna PublisherMedia info");
        }
        try {
            String owner = pm.getFieldValue("_luna_collection_owner");
            this.log.debug((Object)("getLunaMediaImageDataFromSolr(): owner = " + owner));
            media.setCollectionOwner(owner);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return media;
    }

    @Override
    public LunaMedia getLunaMedia(String id) throws DataAccessException {
        LunaMedia media = null;
        if (this.mediaCache.contains(id) && (media = (LunaMedia)this.mediaCache.get(id)).getUrlSize0() == null) {
            this.mediaCache.remove(id);
            this.mediaImageCache.remove(InsightCoreUtils.getCollectionIdFromLunaMediaId(id) + "~" + InsightCoreUtils.getMediaIdFromLunaMediaId(id));
            this.mediaDateCache.remove(id);
        }
        if (!this.mediaCache.contains(id)) {
            String mediaCollectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(id);
            if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
                MediaCollection mc = this.getMediaCollection(mediaCollectionId);
                this.log.info((Object)"Reteived the media collection Info");
                if (mc != null) {
                    media = this.constrcutLunaMedia(mc, id);
                }
            }
            this.log.info((Object)"Constructed the Luna PublisherMedia info");
        }
        return media;
    }

    private List<String> getMediaIdsNotInCache(List<String> mediaIds) {
        ArrayList<String> mediaIdsNotInCache = new ArrayList<String>();
        for (String id : mediaIds) {
            if (this.mediaCache.contains(id) || this.mediaImageCache.contains(InsightCoreUtils.getCollectionIdFromLunaMediaId(id) + "~" + InsightCoreUtils.getMediaIdFromLunaMediaId(id))) continue;
            mediaIdsNotInCache.add(id);
        }
        return mediaIdsNotInCache;
    }

    private Map<String, Vector<Long>> groupMediaIdsByCollection(List<String> mediaIds) {
        HashMap<String, Vector<Long>> collectionMediaMap = new HashMap<String, Vector<Long>>();
        for (String mediaId : mediaIds) {
            String collectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId);
            if (collectionMediaMap.containsKey(collectionId)) {
                ((Vector)collectionMediaMap.get(collectionId)).add(new Long(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId)));
                continue;
            }
            Vector<Long> mediaIdsForThisCollection = new Vector<Long>();
            mediaIdsForThisCollection.add(new Long(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId)));
            collectionMediaMap.put(collectionId, mediaIdsForThisCollection);
        }
        return collectionMediaMap;
    }

    public Vector<ImageFile> getImageFilesFromSolr(String lunaMediaId) {
        PublisherMedia pm = this.solrMediaDAO.findByMediaId(lunaMediaId);
        Vector<ImageFile> imageFiles = this.getLunaMediaImageDataFromSolr(pm);
        return imageFiles;
    }

    private void getImageFiles(String collectionId, Vector<Long> mediaIds) {
        Vector imageFiles = null;
        if (StringUtils.isNotEmpty((String)collectionId)) {
            MediaCollection mediaCollection = this.getMediaCollection(collectionId);
            if (mediaCollection != null) {
                InsightSmartClient isc = this.getInsightSmartClient(mediaCollection);
                TrinityCollectionInfo tci = this.constructCollectionInfo(mediaCollection);
                this.log.info((Object)"Going to fetch the image");
                imageFiles = isc.getImageFiles(mediaIds, (CollectionKey)tci);
            }
            if (CollectionUtils.isNotEmpty(imageFiles)) {
                for (ImageInGroup mediaData : imageFiles) {
                    Vector imageData = mediaData.imageFiles;
                    this.mediaImageCache.put(collectionId + "~" + mediaData.getImageID(), imageData);
                }
            }
        }
    }

    @Override
    public void getImageFiles(List<String> mediaIds) {
        List<String> mediaIdsNotInCache = this.getMediaIdsNotInCache(mediaIds);
        Map<String, Vector<Long>> mediaIdMappingByCollection = this.groupMediaIdsByCollection(mediaIdsNotInCache);
        if (mediaIdMappingByCollection != null) {
            Set<String> collectionIds = mediaIdMappingByCollection.keySet();
            for (String collId : collectionIds) {
                this.log.info((Object)("Trying to get the image data for the collection id = " + collId));
                this.getImageFiles(collId, mediaIdMappingByCollection.get(collId));
                this.log.info((Object)("Got  the image data for the collection id = " + collId));
            }
        }
    }

    private LunaMedia constrcutLunaMediaFromSolr(MediaCollection mc, PublisherMedia pm) {
        if (pm == null || pm.id() == null) {
            return null;
        }
        String mediaId = pm.id();
        LunaMedia media = null;
        if (mc != null && StringUtils.isNotEmpty((String)mediaId)) {
            String logo;
            media = mc instanceof SharedMediaCollection ? new SharedLunaMedia() : new LunaMedia();
            media.setId(mediaId);
            media.setCollection(mc);
            media.setMediaId(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId));
            media.setObjectId(InsightCoreUtils.getObjectIdFromLunaMediaId(mediaId));
            media.setUniqueCollectionId(String.valueOf(mc.getUniqueCollectionId()));
            Vector mediaImageData = null;
            if (this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId()) == null) {
                mediaImageData = this.getLunaMediaImageDataFromSolr(pm);
                this.mediaImageCache.put(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId(), mediaImageData);
            } else {
                mediaImageData = (Vector)this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId());
            }
            ImageInfoUtils.populateMediaImageData(media, mediaImageData);
            List permittedUsers = pm.getFieldValueList("_luna_media_restricted_to");
            media.setPermittedUsers(permittedUsers);
            String uri = pm.getFieldValue(LuceneDocumentFactory.LuceneAttribute.uri.getAttributeName());
            if (uri != null) {
                media.setUri(uri);
            }
            if ((logo = pm.getFieldValue("iiifLogo")) != null && media instanceof SharedLunaMedia) {
                ((SharedLunaMedia)media).addMiscInfo("iiifLogo", logo);
            }
            this.mediaCache.put(mediaId, media);
            if (pm.getLastEditedTime() != null) {
                this.mediaDateCache.put(mediaId, pm.getLastEditedTime());
            }
        }
        return media;
    }

    private LunaMedia constrcutLunaMedia(MediaCollection mc, String mediaId) {
        LunaMedia media = null;
        if (mc != null && StringUtils.isNotEmpty((String)mediaId)) {
            media = mc instanceof SharedMediaCollection ? new SharedLunaMedia() : new LunaMedia();
            media.setId(mediaId);
            media.setCollection(mc);
            media.setMediaId(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId));
            media.setObjectId(InsightCoreUtils.getObjectIdFromLunaMediaId(mediaId));
            media.setUniqueCollectionId(String.valueOf(mc.getUniqueCollectionId()));
            Vector mediaImageData = null;
            if (this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId()) == null) {
                mediaImageData = this.getLunaMediaImageData(media);
                this.mediaImageCache.put(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId(), mediaImageData);
            } else {
                mediaImageData = (Vector)this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId());
            }
            ImageInfoUtils.populateMediaImageData(media, mediaImageData);
            this.mediaCache.put(mediaId, media);
        }
        return media;
    }

    private Vector<ImageFile> getLunaMediaImageDataFromSolr(PublisherMedia pm) {
        ImageFile iFile;
        Dimension imageSize;
        String s;
        Vector<ImageFile> imageFiles = new Vector<ImageFile>();
        Vector<ImageFile> refImageFiles = new Vector<ImageFile>();
        Vector<ImageFile> toReturn = new Vector<ImageFile>();
        if (pm == null || pm.id() == null) {
            return imageFiles;
        }
        int width = 0;
        int height = 0;
        int resolution = 0;
        String url = "";
        int format = 0;
        int mediaType = 0;
        try {
            String typeStr = pm.getFieldValue("mediaType");
            this.log.debug((Object)("getLunaMediaImageDataFromSolr(): mediaType = " + typeStr));
            mediaType = Media.MediaType.toImageFileMediaType(typeStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean found = true;
        int i = 0;
        while (found) {
            url = pm.getFieldValue("urlSize" + i);
            this.log.debug((Object)("getLunaMediaImageDataFromSolr(): urlSize" + i + " = " + url));
            if (url == null) {
                if (mediaType <= 1 || i > 2) {
                    found = false;
                }
            } else {
                s = null;
                try {
                    s = pm.getFieldValue("_luna_resolutionSize_" + i);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): resolution = " + s));
                    resolution = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = pm.getFieldValue("_luna_media_format_" + i);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): format = " + s));
                    format = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = pm.getFieldValue("_luna_media_width_" + i);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): width = " + s));
                    width = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = pm.getFieldValue("_luna_media_height_" + i);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): height = " + s));
                    height = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                imageSize = new Dimension(width, height);
                iFile = new ImageFile(imageSize, resolution, url, format, mediaType);
                imageFiles.add(iFile);
            }
            ++i;
        }
        if (mediaType != 1 && mediaType != 7) {
            width = 0;
            height = 0;
            resolution = 0;
            url = "";
            format = 0;
            for (int j = 0; j <= 4; ++j) {
                url = pm.getFieldValue("refUrlSize" + j);
                this.log.debug((Object)("getLunaMediaImageDataFromSolr(): refUrlSize" + j + " = " + url));
                if (url == null) break;
                s = null;
                try {
                    s = pm.getFieldValue("_luna_ref_resolutionSize_" + j);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): ref media resolution = " + s));
                    resolution = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = pm.getFieldValue("_luna_ref_media_format_" + j);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): ref media format = " + s));
                    format = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = pm.getFieldValue("_luna_ref_media_width_" + j);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): ref media width = " + s));
                    width = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = pm.getFieldValue("_luna_ref_media_height_" + j);
                    this.log.debug((Object)("getLunaMediaImageDataFromSolr(): ref media height = " + s));
                    height = Integer.parseInt(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                imageSize = new Dimension(width, height);
                iFile = new ImageFile(imageSize, resolution, url, format, mediaType);
                refImageFiles.add(iFile);
            }
        }
        toReturn.addAll(refImageFiles);
        toReturn.addAll(imageFiles);
        return toReturn;
    }

    private Vector<ImageFile> getLunaMediaImageData(LunaMedia media) {
        if (media != null && media.getCollection() != null) {
            Date start = new Date();
            InsightSmartClient isc = this.getInsightSmartClient(media.getCollection());
            TrinityCollectionInfo tci = this.constructCollectionInfo(media.getCollection());
            this.log.info((Object)"Going to fetch the image");
            Vector imageFiles = isc.getImageFiles((long)media.getMediaId(), (CollectionKey)tci);
            this.log.debug((Object)("Fetched media getImageFiles in " + (new Date().getTime() - start.getTime()) + "ms for media: " + media));
            return imageFiles;
        }
        return null;
    }

    private MediaCollection getMediaCollection(String mediaCollectionId) {
        if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
            for (MediaCollection mc : this.allMediaCollections) {
                if (!StringUtils.equalsIgnoreCase((String)mc.getId(), (String)mediaCollectionId)) continue;
                return mc;
            }
        }
        return null;
    }

    @Override
    public ExternalMedia getExternalMedia(String id) {
        ExternalMedia media = (ExternalMedia)this.externalObjectDataCache.get(id);
        if (media == null) {
            try {
                media = this.constructExternalObjectData(id);
                if (media != null) {
                    this.externalObjectDataCache.put(id, media);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
                throw new DataAccessResourceFailureException("Unexpected error, unable to retrieve PublisherMedia!", (Throwable)e);
            }
        }
        if (media == null) {
            throw new DataRetrievalFailureException("Unable to locate image! [" + id + "]");
        }
        return media;
    }

    @Override
    public void saveExternalObjectData(ExternalMedia eod) throws DataAccessException {
        try {
            this.saveObject(eod);
            this.externalObjectDataCache.put(eod.getIdentity().toString(), eod);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created ExternalObjectData", (Throwable)e);
        }
    }

    private ExternalMedia constructExternalObjectData(String id) throws SQLException {
        ExternalMedia media = (ExternalMedia)this.constructObjectOnly(ExternalMedia.class, id);
        return media;
    }

    @Override
    public List<ExternalMedia> getExternalMediaByUser(String userId, String mediaSource) throws SQLException {
        String query = "SELECT * FROM EXTERNALMEDIA WHERE OBJECTOWNERID= " + this.convertInput(userId) + " AND MEDIASOURCE='" + mediaSource + "' AND ORIGINATINGURL IS NULL";
        List mediaList = (List)this.constructObjects(ExternalMedia.class, query);
        return mediaList;
    }

    @Override
    public List<ExternalMedia> getExternalMedias(String query) throws SQLException {
        List mediaList = (List)this.constructObjects(ExternalMedia.class, query);
        return mediaList;
    }

    @Override
    public void removeExternalMedia(List<ExternalMedia> mediaList) throws SQLException {
        this.deleteObject(mediaList);
    }

    @Override
    public Vector<String> getExternalMediaExportUrls(String mediaId) throws DataAccessException {
        Vector<String> toReturn = new Vector<String>();
        if (this.mediaExportUrlsCache.contains(mediaId)) {
            return (Vector)this.mediaExportUrlsCache.get(mediaId);
        }
        if (!this.mediaExportUrlsCache.contains(mediaId)) {
            try {
                ExternalMedia em = this.constructExternalObjectData(mediaId);
                ArrayList<String> fullImageUrls = new ArrayList<String>();
                if (em.getMediaType().equalsIgnoreCase("IMAGE")) {
                    fullImageUrls.addAll(em.getFullImageUrls());
                    String[] imageURLs = new String[9];
                    for (int i = 0; i < fullImageUrls.size(); ++i) {
                        imageURLs[i] = (String)fullImageUrls.get(i);
                    }
                    int level = 0;
                    int[] sidLevels = new int[9];
                    for (int sid = imageURLs.length - 1; sid >= 0; --sid) {
                        if (imageURLs[sid] == null) continue;
                        sidLevels[sid] = level++;
                    }
                    if (em.getUrlSize0() != null) {
                        toReturn.add(em.getUrlSize0());
                    }
                    if (em.getUrlSize1() != null) {
                        toReturn.add(em.getUrlSize1());
                    }
                    if (em.getUrlSize2() != null) {
                        toReturn.add(em.getUrlSize2());
                    }
                    if (em.getUrlSize3() != null) {
                        toReturn.add(em.getUrlSize3());
                    }
                    if (em.getUrlSize4() != null) {
                        toReturn.add(em.getUrlSize4());
                    }
                    for (int i = 5; i < fullImageUrls.size(); ++i) {
                        int width;
                        int height;
                        URL image;
                        String imageURL = (String)fullImageUrls.get(i);
                        if (imageURL == null) continue;
                        if (((String)fullImageUrls.get(i)).contains(".jpg") || ((String)fullImageUrls.get(i)).contains(".jpeg")) {
                            image = InsightUtilities.getUrl((String)imageURL);
                        } else if (((String)fullImageUrls.get(i)).contains(".jp2")) {
                            height = NumberUtils.toInt((String)UrlUtils.getParameter((String)fullImageUrls.get(i), "height"));
                            width = NumberUtils.toInt((String)UrlUtils.getParameter((String)fullImageUrls.get(i), "width"));
                            image = InsightUtilities.getUrl((String)Jp2URL.generateJp2URL((String)imageURL, (int)sidLevels[i], (int)0, (int)0, (int)width, (int)height));
                        } else {
                            height = NumberUtils.toInt((String)UrlUtils.getParameter((String)fullImageUrls.get(i), "height"));
                            width = NumberUtils.toInt((String)UrlUtils.getParameter((String)fullImageUrls.get(i), "width"));
                            image = InsightUtilities.getUrl((String)SidURL.generateSidURL((String)imageURL, (int)sidLevels[i], (int)0, (int)0, (int)width, (int)height));
                        }
                        toReturn.add(image.toString());
                    }
                } else {
                    toReturn.add(em.getLargestUrlAvailable());
                }
                this.mediaExportUrlsCache.put(mediaId, toReturn);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    @Override
    public Vector<String> getImageExportUrls(String mediaId) throws DataAccessException {
        Vector<String> toReturn = new Vector<String>();
        if (this.mediaExportUrlsCache.contains(mediaId)) {
            return (Vector)this.mediaExportUrlsCache.get(mediaId);
        }
        if (!this.mediaExportUrlsCache.contains(mediaId)) {
            LunaMedia media = this.getLunaMedia(mediaId);
            Vector mediaImageData = null;
            if (this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId()) == null) {
                mediaImageData = this.getLunaMediaImageData(media);
                this.mediaImageCache.put(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId(), mediaImageData);
            } else {
                mediaImageData = (Vector)this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId());
            }
            if (media.getMediaType().equalsIgnoreCase("IMAGE")) {
                String[] imageURLs = new String[9];
                Dimension[] imageSizes = new Dimension[9];
                for (int i = 0; i < mediaImageData.size(); ++i) {
                    imageURLs[i] = ((ImageFile)mediaImageData.get(i)).getUrl();
                    imageSizes[i] = ((ImageFile)mediaImageData.get(i)).getImageSize();
                }
                int level = 0;
                int[] sidLevels = new int[9];
                for (int sid = imageURLs.length - 1; sid >= 0; --sid) {
                    if (imageURLs[sid] == null) continue;
                    sidLevels[sid] = level++;
                }
                if (media.getUrlSize0() != null) {
                    toReturn.add(media.getUrlSize0());
                }
                if (media.getUrlSize1() != null) {
                    toReturn.add(media.getUrlSize1());
                }
                if (media.getUrlSize2() != null) {
                    toReturn.add(media.getUrlSize2());
                }
                if (media.getUrlSize3() != null) {
                    toReturn.add(media.getUrlSize3());
                }
                if (media.getUrlSize4() != null) {
                    toReturn.add(media.getUrlSize4());
                }
                for (int i = 5; i < mediaImageData.size(); ++i) {
                    URL image;
                    String imageURL = ((ImageFile)mediaImageData.get(i)).getUrl();
                    if (imageURL == null) continue;
                    ImageFile cfr_ignored_0 = (ImageFile)mediaImageData.get(i);
                    if (((ImageFile)mediaImageData.get(i)).getFormat() == 0) {
                        image = InsightUtilities.getUrl((String)imageURL);
                    } else {
                        ImageFile cfr_ignored_1 = (ImageFile)mediaImageData.get(i);
                        image = ((ImageFile)mediaImageData.get(i)).getFormat() == 13 ? InsightUtilities.getUrl((String)Jp2URL.generateJp2URL((String)imageURL, (int)sidLevels[i], (int)0, (int)0, (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getWidth()), (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getHeight()))) : InsightUtilities.getUrl((String)SidURL.generateSidURL((String)imageURL, (int)sidLevels[i], (int)0, (int)0, (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getWidth()), (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getHeight())));
                    }
                    toReturn.add(image.toString());
                }
            } else {
                toReturn.add(media.getLargestUrlAvailable());
            }
            this.mediaExportUrlsCache.put(mediaId, toReturn);
        }
        return toReturn;
    }

    @Override
    public Vector<String> getImageExportUrls(PublisherMedia pm) throws DataAccessException {
        Vector<String> toReturn = new Vector<String>();
        String mediaId = pm.id();
        if (this.mediaExportUrlsCache.contains(mediaId)) {
            return (Vector)this.mediaExportUrlsCache.get(mediaId);
        }
        if (!this.mediaExportUrlsCache.contains(mediaId)) {
            LunaMedia media = this.getLunaMedia(pm);
            Vector mediaImageData = null;
            if (this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId()) == null) {
                mediaImageData = this.getLunaMediaImageDataFromSolr(pm);
                this.mediaImageCache.put(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId(), mediaImageData);
            } else {
                mediaImageData = (Vector)this.mediaImageCache.get(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId) + "~" + media.getMediaId());
            }
            if (media.getMediaType().equalsIgnoreCase("IMAGE")) {
                String[] imageURLs = new String[9];
                Dimension[] imageSizes = new Dimension[9];
                for (int i = 0; i < mediaImageData.size(); ++i) {
                    imageURLs[i] = ((ImageFile)mediaImageData.get(i)).getUrl();
                    imageSizes[i] = ((ImageFile)mediaImageData.get(i)).getImageSize();
                }
                int level = 0;
                int[] sidLevels = new int[9];
                for (int sid = imageURLs.length - 1; sid >= 0; --sid) {
                    if (imageURLs[sid] == null) continue;
                    sidLevels[sid] = level++;
                }
                if (media.getUrlSize0() != null) {
                    toReturn.add(media.getUrlSize0());
                }
                if (media.getUrlSize1() != null) {
                    toReturn.add(media.getUrlSize1());
                }
                if (media.getUrlSize2() != null) {
                    toReturn.add(media.getUrlSize2());
                }
                if (media.getUrlSize3() != null) {
                    toReturn.add(media.getUrlSize3());
                }
                if (media.getUrlSize4() != null) {
                    toReturn.add(media.getUrlSize4());
                }
                for (int i = 5; i < mediaImageData.size(); ++i) {
                    URL image;
                    String imageURL = ((ImageFile)mediaImageData.get(i)).getUrl();
                    if (imageURL == null) continue;
                    ImageFile cfr_ignored_0 = (ImageFile)mediaImageData.get(i);
                    if (((ImageFile)mediaImageData.get(i)).getFormat() == 0) {
                        image = InsightUtilities.getUrl((String)imageURL);
                    } else {
                        ImageFile cfr_ignored_1 = (ImageFile)mediaImageData.get(i);
                        image = ((ImageFile)mediaImageData.get(i)).getFormat() == 13 ? InsightUtilities.getUrl((String)Jp2URL.generateJp2URL((String)imageURL, (int)sidLevels[i], (int)0, (int)0, (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getWidth()), (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getHeight()))) : InsightUtilities.getUrl((String)SidURL.generateSidURL((String)imageURL, (int)sidLevels[i], (int)0, (int)0, (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getWidth()), (int)((int)((ImageFile)mediaImageData.get(i)).getImageSize().getHeight())));
                    }
                    toReturn.add(image.toString());
                }
            } else if (media.getMediaType().equalsIgnoreCase("AUDIO") || media.getMediaType().equalsIgnoreCase("VIDEO")) {
                if (media.getUrlSource() != null) {
                    toReturn.add(media.getUrlSource());
                } else {
                    toReturn.add(media.getLargestUrlAvailable());
                }
            } else if (media.getMediaType().equalsIgnoreCase("MISC")) {
                toReturn.add(media.getUrlSource());
            } else {
                toReturn.add(media.getLargestUrlAvailable());
            }
            boolean saveToCache = true;
            for (String s : toReturn) {
                if (s == null || !s.endsWith(MessageManager.MessageKeys.RESTRICTION_ICON_URL.getValue())) continue;
                saveToCache = false;
            }
            if (saveToCache) {
                this.mediaExportUrlsCache.put(mediaId, toReturn);
            }
        }
        return toReturn;
    }
}

