/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.legacy;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.ObjectKeyWrapper;
import com.luna.insight.server.TrinityCollectionInfo;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.dao.legacy.LegacyCollectionRunner;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.publisher.common.dao.SolrMediaDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LegacyBaseDao
extends JdbcBaseDao {
    protected Log log = LogFactory.getLog(this.getClass());
    protected SolrMediaDAO solrMediaDAO = null;
    protected boolean isLuna6 = false;

    public SolrMediaDAO getSolrMediaDAO() {
        return this.solrMediaDAO;
    }

    public void setSolrMediaDAO(SolrMediaDAO dao) {
        this.solrMediaDAO = dao;
    }

    public InsightSmartClient getInsightSmartClient(MediaCollection mc) {
        TrinityCollectionInfo key = this.constructCollectionInfo(mc);
        LegacyCollectionRunner lcr = new LegacyCollectionRunner();
        lcr.setTci(key);
        Thread t = new Thread(lcr);
        t.start();
        long endTimeMillis = System.currentTimeMillis() + 10000L;
        do {
            if (!t.isAlive() || System.currentTimeMillis() <= endTimeMillis) continue;
            t.interrupt();
            return null;
        } while (t.isAlive());
        InsightSmartClient isc = new InsightSmartClient(key);
        return isc;
    }

    protected GroupInformation getGroupInfo(MediaCollection mc) {
        TrinityCollectionInfo key = this.constructCollectionInfo(mc);
        InsightSmartClient isc = this.getInsightSmartClient(mc);
        key = isc.getConfigurationInfo(key, mc.getStandardName());
        GroupInformation gInfo = isc.getGroupInfo(key.getInitialGroupOpen(), (CollectionKey)key);
        gInfo.setTci(key);
        return gInfo;
    }

    protected TrinityCollectionInfo constructCollectionInfo(MediaCollection mc) {
        TrinityCollectionInfo tci = new TrinityCollectionInfo(mc.getUserId(), mc.getUserName(), mc.getInstitutionId(), mc.getCollectionId(), mc.getServerId(), mc.getCollectionName(), mc.getServerAddress(), mc.getServerPort(), mc.getGroupName(), mc.getGroupKeyCode(), mc.getGroupProfileId());
        tci.setUserCollection(mc.getUserCollection());
        tci.setProfileID(mc.getProfileId());
        tci.setUniqueCollectionID(Integer.valueOf(mc.getUniqueCollectionId()));
        tci.setSessionCodeKey(mc.getSessionCodeKey());
        tci.setSessionGroupName(mc.getSessionGroupName());
        return tci;
    }

    protected ObjectKeyWrapper constrcutObjectKey(LunaMedia media) {
        ObjectKeyWrapper key = null;
        if (media != null && media.getCollection() != null) {
            TrinityCollectionInfo tci = this.constructCollectionInfo(media.getCollection());
            key = new ObjectKeyWrapper((long)media.getObjectId(), (long)media.getMediaId(), false, false, (CollectionKey)tci);
        }
        return key;
    }

    public boolean getLuna6() {
        return this.isLuna6;
    }

    public void setLuna6(boolean b) {
        this.isLuna6 = b;
    }
}

