/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.legacy;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.links.AnnotationLinkData;
import com.luna.insight.server.links.LinkData;
import com.lunaimaging.insight.core.dao.legacy.LegacyBaseDao;
import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import java.awt.Rectangle;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;

public class LegacyAnnotationDao
extends LegacyBaseDao {
    public static final int VIRTUAL_MAXIMUM = 10000;
    protected List<MediaCollection> allMediaCollections;
    private boolean initialized = false;

    public List<Annotation> getAnnotations(String mid) throws DataAccessException {
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        String mediaCollectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(mid);
        int imageId = InsightCoreUtils.getMediaIdFromLunaMediaId(mid);
        if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
            MediaCollection mc = this.getMediaCollection(mediaCollectionId);
            this.log.info((Object)"Reteived the media collection Info");
            InsightSmartClient isc = this.getInsightSmartClient(mc);
            TrinityCollectionInfo tci = this.constructCollectionInfo(mc);
            this.log.info((Object)"Going to fetch the image");
            Vector imageFiles = isc.getImageFiles((long)imageId, (CollectionKey)tci);
            isc.closeConnections();
            Vector linkData = this.getLinkData(imageId, mc);
            ImageFile largestImageFile = this.getLargestResolutionImageFile(imageFiles);
            for (int i = 0; i < linkData.size(); ++i) {
                if (!(linkData.get(i) instanceof AnnotationLinkData)) continue;
                Annotation a = new Annotation();
                a.setId(0);
                a.setMediaId(mid);
                a.setUserId(0);
                a.setAnnotation(((AnnotationLinkData)linkData.get(i)).getText());
                Rectangle actualImageRect = LegacyAnnotationDao.translateToActual(((LinkData)linkData.get(i)).getRegion(), Double.valueOf(largestImageFile.getImageSize().getWidth()).intValue(), Double.valueOf(largestImageFile.getImageSize().getHeight()).intValue());
                a.setImgHeight(Double.valueOf(largestImageFile.getImageSize().getHeight()).intValue());
                a.setImgWidth(Double.valueOf(largestImageFile.getImageSize().getWidth()).intValue());
                a.setxPos(actualImageRect.x);
                a.setyPos(actualImageRect.y);
                a.setMgid(0);
                String color = Integer.toHexString(((LinkData)linkData.get(i)).getColor().getRGB() & 0xFFFFFF);
                if (color.length() < 6) {
                    color = '0' + color;
                }
                a.setColor(color);
                toReturn.add(a);
            }
        }
        return toReturn;
    }

    private Vector getLinkData(int imageId, MediaCollection mc) {
        Date start = new Date();
        InsightSmartClient isc = this.getInsightSmartClient(mc);
        TrinityCollectionInfo tci = this.constructCollectionInfo(mc);
        this.log.info((Object)"Going to fetch the links");
        Vector toReturn = new Vector(0);
        toReturn = isc.getLinks((CollectionKey)tci, (long)imageId, null);
        isc.closeConnections();
        this.log.info((Object)("Fetched media getLinks in " + (new Date().getTime() - start.getTime()) + "ms for media: " + imageId));
        this.log.info((Object)("Links returned: " + toReturn.size()));
        return toReturn;
    }

    private MediaCollection getMediaCollection(String mediaCollectionId) {
        if (StringUtils.isNotEmpty((String)mediaCollectionId)) {
            for (MediaCollection mc : this.allMediaCollections) {
                if (!StringUtils.equalsIgnoreCase((String)mc.getId(), (String)mediaCollectionId)) continue;
                return mc;
            }
        }
        return null;
    }

    public void setAllMediaCollections(List<MediaCollection> allMediaCollections) {
        this.allMediaCollections = allMediaCollections;
    }

    public TrinityCollectionInfo getCollectionInfo(MediaCollection mc) {
        return this.constructCollectionInfo(mc);
    }

    public ImageFile getLargestResolutionImageFile(Vector<ImageFile> imageFiles) {
        ImageFile imf = null;
        if (CollectionUtils.isNotEmpty(imageFiles)) {
            int i = imageFiles.size() - 1;
            while (i >= 0 && i < imageFiles.size()) {
                if ((imf = imageFiles.get(i--)) == null || imf.getFormat() != 1 && imf.getFormat() != 13 && imf.getFormat() != 0) continue;
                return imf;
            }
        }
        return null;
    }

    private static int translateToActual(int virtual, int maximum) {
        return Math.round((float)virtual * (float)maximum / 10000.0f);
    }

    public static Rectangle translateToActual(Rectangle virtualRect, int maxWidth, int maxHeight) {
        return new Rectangle(LegacyAnnotationDao.translateToActual(virtualRect.x, maxWidth), LegacyAnnotationDao.translateToActual(virtualRect.y, maxHeight), LegacyAnnotationDao.translateToActual(virtualRect.width, maxWidth), LegacyAnnotationDao.translateToActual(virtualRect.height, maxHeight));
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.initialized = true;
        }
    }
}

