/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.TinyUrlDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.TinyUrl;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcTinyUrlDao
extends JdbcBaseDao
implements TinyUrlDao,
Maintainable {
    protected int maximumTinyUrlCache = 5000;
    protected LRUCache tinyUrlsCache = new LRUCache();
    private boolean initialized = false;
    protected List<TinyUrl> allTinyUrls;

    public void setMaximumTinyUrlCache(int maximumTinyUrlCache) {
        this.maximumTinyUrlCache = maximumTinyUrlCache;
    }

    public List<TinyUrl> getAllTinyUrls() {
        return (List)this.tinyUrlsCache.getAll();
    }

    @Override
    public TinyUrl getTinyUrl(String token) throws DataAccessException {
        TinyUrl a = null;
        try {
            List result;
            a = (TinyUrl)this.tinyUrlsCache.get(token);
            if (a == null && (result = (List)this.constructObjects(TinyUrl.class, "token", token)).size() > 0) {
                a = (TinyUrl)result.get(0);
                this.tinyUrlsCache.put(token, a);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve tiny url!", (Throwable)e);
        }
        return a;
    }

    @Override
    public TinyUrl getToken(String mappedUrl) throws DataAccessException {
        TinyUrl a = null;
        try {
            List result = (List)this.constructObjects(TinyUrl.class, "mappedUrl", mappedUrl);
            if (result.size() > 0) {
                a = (TinyUrl)result.get(0);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve token for " + mappedUrl + "!", (Throwable)e);
        }
        return a;
    }

    @Override
    public void saveTinyUrl(TinyUrl a) throws DataAccessException {
        try {
            this.saveObject(a);
            this.tinyUrlsCache.put(a.getToken(), a);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created TinyUrl", (Throwable)e);
        }
    }

    protected void updateCache(TinyUrl s) {
    }

    @Override
    public void deleteTinyUrl(TinyUrl tinyUrl) throws DataAccessException {
        try {
            this.tinyUrlsCache.remove(tinyUrl.getToken());
            this.deleteObject(tinyUrl);
        }
        catch (SQLException e) {
            this.log.error((Object)("Trouble deleting tinyUrl: " + tinyUrl), (Throwable)e);
            throw new DataAccessResourceFailureException("Trouble deleting tinyUrl: " + tinyUrl, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Error: ", (Throwable)e);
            throw new DataAccessResourceFailureException("Trouble deleting tinyUrl: ", (Throwable)e);
        }
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing TinyUrl(s)");
            this.initializeTinyUrls();
            this.initialized = true;
        }
    }

    private void initializeTinyUrls() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new tinyUrls cache");
        this.tinyUrlsCache = new LRUCache(this.maximumTinyUrlCache);
        Collection allTinyUrls = this.getAllObjects(TinyUrl.class, this.tinyUrlsCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allTinyUrls)) {
            for (TinyUrl a : allTinyUrls) {
                this.tinyUrlsCache.put(a.getToken(), a);
            }
        }
        this.log.debug((Object)("Completed TinyUrls cache: " + this.tinyUrlsCache.size()));
    }

    @Override
    public boolean isTokenAvailable(String token) throws DataAccessException {
        TinyUrl a = null;
        try {
            List result;
            a = (TinyUrl)this.tinyUrlsCache.get(token);
            if (a == null && (result = (List)this.constructObjects(TinyUrl.class, "token", token)).size() == 0) {
                return true;
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve Tiny URL!", (Throwable)e);
        }
        return false;
    }

    public int getTotalTinyUrl() {
        return this.tinyUrlsCache.size();
    }

    @Override
    public void startMaintenance() throws Exception {
        this.tinyUrlsCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

