/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.luna.webadmin.distribution.PermissionSetupRequester;
import com.lunaimaging.inscribe.domain.LunaCollectionId;
import com.lunaimaging.insight.core.dao.ContentDistributionDao;
import com.lunaimaging.insight.core.dao.MediaCollectionDao;
import com.lunaimaging.insight.core.dao.MediaFieldDao;
import com.lunaimaging.insight.core.dao.MediaSearchDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcContentDistributionDao;
import com.lunaimaging.insight.core.domain.ManifestIdMap;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.SharedExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.SharedMediaField;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.MediaCollectionUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.dao.MediaDAO;
import com.lunaimaging.publisher.distribution.iiif.IiifResourceImporter;
import com.lunaimaging.publisher.distribution.task.IiifTaskLog;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.KeyedHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcResourceDiscoveryDao
extends JdbcContentDistributionDao
implements ContentDistributionDao {
    protected int maximumIdCache = 100000;
    protected LRUCache uriIdCache = new LRUCache(this.maximumIdCache);
    protected LRUCache uriMediaIdCache = new LRUCache(this.maximumIdCache);
    protected LRUCache uriObjectIdCache = new LRUCache(this.maximumIdCache);
    private boolean initialized = false;
    protected static final Log log = LogFactory.getLog(JdbcResourceDiscoveryDao.class);
    protected static final int MAX_DOCS_TO_DELETE = 500000;
    private static final String TABLE_NAME_URIMEDIAMAP = "URIMEDIAMAP";
    private static final String TABLE_NAME_URIOBJECTMAP = "URIOBJECTMAP";
    protected MediaCollectionDao mediaCollectionDao = null;
    protected MediaFieldDao mediaFieldDao = null;
    protected MediaDAO publicMediaDAO = null;
    protected PermissionSetupRequester permissionSetupRequester;
    protected List<MediaCollection> allLocalMediaCollections;
    protected Set<IiifTaskLog> progressLogs = null;
    protected String collectionName = null;
    protected String institutionName = null;
    protected String collectionType = null;
    protected Map<String, Object> defaultTermLists;
    protected int commitThreshold = -1;

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            log.debug((Object)"initializing Cache(s)");
            this.initializeCaches();
            this.initialized = true;
        }
    }

    private void initializeCaches() {
        this.uriIdCache = new LRUCache(this.maximumIdCache);
        this.uriMediaIdCache = new LRUCache(this.maximumIdCache);
        this.uriObjectIdCache = new LRUCache(this.maximumIdCache);
    }

    private void populateCaches(String collectionId) {
        Map objectIdMap;
        log.debug((Object)"Populate Caches");
        long startTime = System.currentTimeMillis();
        this.uriMediaIdCache.purge();
        this.uriObjectIdCache.purge();
        Map mediaIdMap = this.getMediaIdsByCollection(collectionId);
        if (mediaIdMap != null) {
            for (String uri : mediaIdMap.keySet()) {
                this.uriMediaIdCache.put(uri, mediaIdMap.get(uri));
            }
        }
        if ((objectIdMap = this.getObjectIdsByCollection(collectionId)) != null) {
            for (String uri : objectIdMap.keySet()) {
                this.uriObjectIdCache.put(uri, objectIdMap.get(uri));
            }
        }
        log.debug((Object)("uriMediaIdCache size:" + this.uriMediaIdCache.size()));
        log.debug((Object)("uriObjectIdCache size:" + this.uriObjectIdCache.size()));
        log.debug((Object)("Finished populate caches in " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    @Override
    public void publishConsolidatedExternalPublicContent(List<String> sourceUrls) throws DataAccessException {
    }

    @Override
    public synchronized void fetchExternalPublicContent(List<String> sourceUrls) throws DataAccessException {
        log.debug((Object)"fetchExternalPublicContent(.)");
        Maintainable m = (Maintainable)((Object)this.mediaCollectionDao);
        SharedMediaCollection smc = null;
        SharedExtendedCollectionProperties sprops = null;
        boolean isNew = true;
        try {
            m.startMaintenance();
            m.endMaintenance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        SharedMediaCollection existingCol = this.mediaCollectionDao.getSharedCollection(sourceUrls.get(0));
        if (existingCol != null) {
            isNew = false;
            List<MediaField> mfs = this.mediaFieldDao.getAllMediaFields(existingCol);
            if (mfs != null) {
                existingCol.setMediaFields(mfs);
            }
            if (existingCol.getMediaFields() == null) {
                log.debug((Object)"----------------------null fields!");
            }
        }
        IiifResourceImporter iiif = new IiifResourceImporter(sourceUrls.get(0), this.publicMediaDAO);
        iiif.initializeCollection((MediaCollection)existingCol);
        iiif.setCollectionDao(this.mediaCollectionDao);
        iiif.setResourceDiscoveryDao(this);
        iiif.setDefaultTermList(this.defaultTermLists);
        if (this.commitThreshold > 0) {
            iiif.setBatchSize(this.commitThreshold);
        }
        MediaCollection mc = iiif.getThisCollection();
        this.populateCaches(mc.getId());
        try {
            smc = !(mc instanceof SharedMediaCollection) ? MediaCollectionUtils.constructSharedMediaCollection(mc) : (SharedMediaCollection)mc;
            sprops = (SharedExtendedCollectionProperties)smc.getExtendedCollectionProperties();
            if (iiif.isLunaCollection) {
                List<MediaField> mfs = mc.getMediaFields();
                log.debug((Object)("Transferring " + mfs.size() + " Fields"));
                for (MediaField mf : mfs) {
                    log.debug((Object)("MediaField[name,previewsort,summarysort,order,w4type]: [" + mf.getFieldName() + "," + mf.getPreviewFieldSort() + "," + mf.getSummaryDescriptionFieldSort() + "," + mf.getDisplayOrder() + "," + mf.getW4Type() + "]"));
                    log.debug((Object)("Sorable? " + mf.isSortable()));
                }
                smc.setMediaFields(mfs);
                sprops.setUri(sourceUrls.get(0));
                if (StringUtils.isNotBlank((String)this.collectionName)) {
                    smc.setCollectionName(this.collectionName);
                }
                if (StringUtils.isNotBlank((String)this.institutionName)) {
                    smc.setInstitutionName(this.institutionName);
                }
            } else if (existingCol == null) {
                List<MediaCollection> mcs = this.mediaCollectionDao.getPublicMediaCollections();
                int collectionId = MediaCollectionUtils.getCollectionMaxIdByInstitution(mcs, smc.getInstitutionId());
                LunaCollectionId lcid = new LunaCollectionId(smc.getInstitutionId(), String.valueOf(++collectionId), collectionId);
                smc.setCollectionId(lcid.getCollectionId());
                smc.setUniqueCollectionId(lcid.getUniqueCollectionId());
                smc.setId(lcid.toString());
                smc.setAbbreviatedName(lcid.toString());
                if (StringUtils.isNotBlank((String)this.collectionName)) {
                    smc.setCollectionName(this.collectionName);
                }
                if (StringUtils.isNotBlank((String)this.institutionName)) {
                    smc.setInstitutionName(this.institutionName);
                }
                sprops.setCollectionId(lcid.toString());
                sprops.setMaxMediaId(0);
                sprops.setMaxObjectId(0);
                sprops.setUri(sourceUrls.get(0));
            }
            if (existingCol == null) {
                try {
                    m.startMaintenance();
                    this.saveSharedMediaCollection(smc);
                    m.endMaintenance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (smc != null && this.permissionSetupRequester != null) {
                if (this.permissionSetupRequester.login()) {
                    this.permissionSetupRequester.requestPermissionSetup((MediaCollection)smc, "");
                } else {
                    log.error((Object)"Failed logging in. Could not set up permission in WebAdmin. Check username or password.");
                }
            }
            iiif.setThisCollection((MediaCollection)smc);
            if (sprops.getLastCrawl() != null) {
                iiif.setLastCrawl(sprops.getLastCrawl());
            }
            iiif.run();
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sprops != null) {
            if (iiif.getLastCrawl() != null) {
                sprops.setLastCrawl(iiif.getLastCrawl());
            }
            sprops.setMaxObjectId(this.getMaxObjectId(sprops.getCollectionId()));
            sprops.setMaxMediaId(this.getMaxMediaId(sprops.getCollectionId()));
            try {
                if (smc.getMediaFields() == null) {
                    log.error((Object)"Saving no fields to databases!");
                }
                m.startMaintenance();
                this.updateOrSaveMediaCollection(smc);
                m.endMaintenance();
            }
            catch (InvalidParameterException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void purgeCollection(String lunaCollectionId) {
        try {
            String[] result = ParsingUtils.splitIgnoreCaseTrim(lunaCollectionId, "~");
            if (result == null || result.length != 3) {
                throw new Exception("Invalid luna collection id: " + lunaCollectionId);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("INSTITUTIONID", result[0]);
            params.put("COLLECTIONID", result[1]);
            params.put("UNIQUECOLLECTIONID", result[2]);
            this.deleteObjects(SharedMediaField.class, params);
            this.deleteObjects(SharedExtendedCollectionProperties.class, "COLLECTIONID", lunaCollectionId);
            this.deleteObjects(SharedMediaCollection.class, "ID", lunaCollectionId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveMediaCollection(MediaCollection smc) throws SQLException {
        if (smc == null || !(smc instanceof SharedMediaCollection)) {
            throw new InvalidParameterException("No Shared PublisherMedia Collection to save!");
        }
        this.insertOnly(smc, true);
        if (smc.getExtendedCollectionProperties() != null) {
            this.insertOnly(smc.getExtendedCollectionProperties(), true);
        }
        List<MediaField> mfs = smc.getMediaFields();
        ArrayList<SharedMediaField> smfs = new ArrayList<SharedMediaField>();
        if (mfs != null) {
            for (MediaField mf : mfs) {
                try {
                    SharedMediaField smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    smfs.add(smf);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(smfs)) {
            this.batchInsert(smfs);
        } else {
            log.debug((Object)("No PublisherMedia Fields found for " + smc));
        }
    }

    @Override
    public void updateOrSaveMediaCollection(MediaCollection mc) throws SQLException, InvalidParameterException {
        this.purgeCollection(mc.getId());
        this.saveMediaCollection(mc);
    }

    @Override
    public void publishPublicContent(List<MediaCollection> mcs) throws DataAccessException {
        this.publishPublicContent(mcs, null);
    }

    private SharedMediaCollection constrcutSharedMediaCollection(MediaCollection mc) throws IOException, IllegalAccessException, InvocationTargetException {
        SharedMediaCollection smc = null;
        if (mc != null) {
            SharedMediaField smf;
            ArrayList<MediaField> mfs;
            smc = new SharedMediaCollection();
            BeanUtils.copyProperties((Object)smc, (Object)mc);
            if (mc.getExtendedCollectionProperties() != null) {
                SharedExtendedCollectionProperties secp = new SharedExtendedCollectionProperties();
                BeanUtils.copyProperties((Object)secp, (Object)mc.getExtendedCollectionProperties());
                secp.setCollectionId(mc.getId());
                secp.setDefaultGroupId(0);
                smc.setExtendedCollectionProperties(secp);
            }
            if (mc.getPreviewMediaFields() != null) {
                mfs = new ArrayList<MediaField>();
                for (MediaField mf : mc.getPreviewMediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setPreviewMediaFields(mfs);
            }
            if (mc.getSummaryDescriptionMediaFields() != null) {
                mfs = new ArrayList();
                for (MediaField mf : mc.getSummaryDescriptionMediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setSummaryDescriptionMediaFields(mfs);
            }
            if (mc.getW4MediaFields() != null) {
                mfs = new ArrayList();
                for (MediaField mf : mc.getW4MediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setW4MediaFields(mfs);
            }
        }
        return smc;
    }

    private List<SharedMediaCollection> constrcutSharedMediaCollections(List<MediaCollection> mcs) throws IOException, IllegalAccessException, InvocationTargetException {
        ArrayList<SharedMediaCollection> smcs = new ArrayList<SharedMediaCollection>();
        for (MediaCollection mc : mcs) {
            SharedMediaCollection smc = this.constrcutSharedMediaCollection(mc);
            if (smc == null) continue;
            smcs.add(smc);
        }
        return smcs;
    }

    public int getMaxMediaId(String collectionId) {
        return (Integer)this.getMaxId(collectionId, "mediaid", TABLE_NAME_URIMEDIAMAP);
    }

    public int getMaxObjectId(String collectionId) {
        return (Integer)this.getMaxId(collectionId, "objectid", TABLE_NAME_URIOBJECTMAP);
    }

    private Object getMaxId(String collectionId, String idColName, String tableName) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((String)collectionId)) {
            return -1;
        }
        StringBuilder query = new StringBuilder("SELECT max(" + idColName + ") FROM " + tableName + " where collectionid = '" + collectionId + "'");
        try {
            List result = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new ArrayListHandler());
            log.debug((Object)("getMaxId(): " + (System.currentTimeMillis() - startTime) + "ms"));
            if (result != null && result.get(0) != null && ((Object[])result.get(0))[0] != null) {
                return (Integer)((Object[])result.get(0))[0];
            }
            return 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve  for this media", (Throwable)e);
        }
    }

    public Object getObjectIdByUri(String uri, String collectionId) throws DataAccessException {
        Integer toReturn = (Integer)this.uriObjectIdCache.get(uri);
        if (toReturn != null || this.uriObjectIdCache.size() >= this.uriObjectIdCache.getMaximumSize()) {
            return toReturn;
        }
        Map result = this.getIdByUri(uri, collectionId, "objectid", TABLE_NAME_URIOBJECTMAP);
        return result == null || (Integer)result.get("objectid") == null ? null : Integer.valueOf((Integer)result.get("objectid"));
    }

    public Object getMediaIdByUri(String uri, String collectionId) throws DataAccessException {
        Integer toReturn = (Integer)this.uriMediaIdCache.get(uri);
        if (toReturn != null || this.uriMediaIdCache.size() >= this.uriMediaIdCache.getMaximumSize()) {
            return toReturn;
        }
        Map result = this.getIdByUri(uri, collectionId, "mediaid", TABLE_NAME_URIMEDIAMAP);
        return result == null || (Integer)result.get("mediaid") == null ? null : Integer.valueOf((Integer)result.get("mediaid"));
    }

    public synchronized ManifestIdMap saveMapping(ManifestIdMap mapping) {
        long startTime;
        if (mapping == null) {
            return null;
        }
        if (mapping.getMediaId() < 0) {
            startTime = System.currentTimeMillis();
            Object mediaIdInt = this.getMediaIdByUri(mapping.getUri(), mapping.getCollectionId());
            log.debug((Object)("getMediaIdByUri:" + (System.currentTimeMillis() - startTime) + "ms"));
            if (mediaIdInt != null) {
                mapping.setMediaId((Integer)mediaIdInt);
            } else {
                try {
                    mapping.setMediaId(this.getMaxMediaId(mapping.getCollectionId()) + 1);
                    startTime = System.currentTimeMillis();
                    this.addMediaId(mapping.getUri(), mapping.getCollectionId(), mapping.getMediaId());
                    log.debug((Object)("addMediaId:" + (System.currentTimeMillis() - startTime) + "ms"));
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        if (mapping.getObjectId() < 0) {
            startTime = System.currentTimeMillis();
            Object objectIdInt = this.getObjectIdByUri(mapping.getUri(), mapping.getCollectionId());
            log.debug((Object)("getObjectIdByUri:" + (System.currentTimeMillis() - startTime) + "ms"));
            if (objectIdInt != null) {
                mapping.setObjectId((Integer)objectIdInt);
            } else {
                try {
                    mapping.setObjectId(this.getMaxObjectId(mapping.getCollectionId()) + 1);
                    startTime = System.currentTimeMillis();
                    this.addObjectId(mapping.getUri(), mapping.getCollectionId(), mapping.getObjectId());
                    log.debug((Object)("addObjectId:" + (System.currentTimeMillis() - startTime) + "ms"));
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        startTime = System.currentTimeMillis();
        this.updateStatus(mapping);
        log.debug((Object)("updateStatus:" + (System.currentTimeMillis() - startTime) + "ms"));
        this.uriIdCache.put(mapping.getCollectionId() + ":" + mapping.getUri(), mapping);
        return mapping;
    }

    public ManifestIdMap getMappingByUri(String uri, String collectionId) {
        if (StringUtils.isBlank((String)uri) || StringUtils.isBlank((String)collectionId)) {
            return null;
        }
        ManifestIdMap midm = (ManifestIdMap)this.uriIdCache.get(collectionId + ":" + uri);
        if (midm == null) {
            Map objResult = this.getIdByUri(uri, collectionId, "objectid", TABLE_NAME_URIOBJECTMAP);
            Map mediaResult = this.getIdByUri(uri, collectionId, "mediaid", TABLE_NAME_URIMEDIAMAP);
            midm = new ManifestIdMap(collectionId, uri);
            try {
                if (mediaResult != null && mediaResult.containsKey("mediaId")) {
                    midm.setMediaId((Integer)mediaResult.get("mediaId"));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            try {
                if (objResult != null && objResult.containsKey("objectid")) {
                    midm.setObjectId((Integer)objResult.get("objectid"));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            try {
                if (mediaResult != null && mediaResult.containsKey("status")) {
                    midm.setStatus((Integer)mediaResult.get("status"));
                }
                if (objResult != null && objResult.containsKey("status") && ((Integer)objResult.get("status")).intValue() == ManifestIdMap.Status.INACTIVE.getCode()) {
                    midm.setStatus(ManifestIdMap.Status.INACTIVE.getCode());
                }
                this.uriIdCache.put(collectionId + ":" + uri, midm);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return midm;
    }

    public List<String> getInactiveUris(String collectionId) {
        Set<String> inactiveMediaList = this.getUriByStatus(ManifestIdMap.Status.INACTIVE.getCode(), collectionId, TABLE_NAME_URIMEDIAMAP);
        Set<String> inactiveObjectList = this.getUriByStatus(ManifestIdMap.Status.INACTIVE.getCode(), collectionId, TABLE_NAME_URIOBJECTMAP);
        if (inactiveMediaList == null) {
            inactiveMediaList = new HashSet<String>();
        }
        HashSet<String> mainSet = new HashSet<String>();
        mainSet.addAll(inactiveMediaList);
        mainSet.addAll(inactiveObjectList);
        ArrayList<String> mainList = new ArrayList<String>();
        mainList.addAll(mainSet);
        return mainList;
    }

    public List<String> getActiveUris(String collectionId) {
        Set<String> inactiveMediaList = this.getUriByStatus(ManifestIdMap.Status.ACTIVE.getCode(), collectionId, TABLE_NAME_URIMEDIAMAP);
        Set<String> inactiveObjectList = this.getUriByStatus(ManifestIdMap.Status.ACTIVE.getCode(), collectionId, TABLE_NAME_URIOBJECTMAP);
        HashSet<String> mainSet = new HashSet<String>();
        mainSet.addAll(inactiveMediaList);
        mainSet.addAll(inactiveObjectList);
        ArrayList<String> mainList = new ArrayList<String>();
        mainList.addAll(mainSet);
        return mainList;
    }

    private Set<String> getUriByStatus(int status, String collectionId, String tableName) {
        if (StringUtils.isBlank((String)collectionId)) {
            return null;
        }
        StringBuilder query = new StringBuilder("SELECT uri FROM " + tableName + " where collectionid = '" + collectionId + "' AND status=" + status);
        try {
            Map found = (Map)this.constructObject((CharSequence)query, (ResultSetHandler)new KeyedHandler("uri"));
            if (found != null) {
                return found.keySet();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to get uris", (Throwable)e);
        }
        catch (NullPointerException ne) {
            return null;
        }
        return null;
    }

    private Map getIdByUri(String uri, String collectionId, String idColName, String tableName) throws DataAccessException {
        if (StringUtils.isBlank((String)uri) || StringUtils.isBlank((String)collectionId)) {
            return null;
        }
        StringBuilder query = new StringBuilder("SELECT status, uri, " + idColName + " FROM " + tableName + " where collectionid = '" + collectionId + "' AND uri='" + uri + "'");
        try {
            Map found = (Map)this.constructObject((CharSequence)query, (ResultSetHandler)new KeyedHandler("uri"));
            Map result = (Map)found.get(uri);
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to id for this uri", (Throwable)e);
        }
        catch (NullPointerException ne) {
            return null;
        }
    }

    public void addMediaId(String uri, String collectionId, int idValue) throws SQLException {
        this.uriMediaIdCache.put(uri, idValue);
        this.addId(uri, collectionId, "mediaid", TABLE_NAME_URIMEDIAMAP, idValue);
    }

    public void addObjectId(String uri, String collectionId, int idValue) throws SQLException {
        this.uriObjectIdCache.put(uri, idValue);
        this.addId(uri, collectionId, "objectid", TABLE_NAME_URIOBJECTMAP, idValue);
    }

    private void addId(String uri, String collectionId, String idColName, String tableName, int idValue) throws SQLException {
        StringBuilder query = new StringBuilder("INSERT INTO " + tableName + " (collectionid, uri, " + idColName + " ) VALUES ( '" + collectionId + "', '" + this.escapeForSql(uri) + "', " + idValue + ")");
        QueryRunner run = new QueryRunner(this.dataSource);
        run.update(query.toString());
    }

    public void updateStatus(ManifestIdMap mapping) {
        if (mapping == null) {
            return;
        }
        QueryRunner run = new QueryRunner(this.dataSource);
        StringBuilder query = new StringBuilder("UPDATE URIOBJECTMAP SET STATUS = " + mapping.getStatus() + " WHERE collectionid='" + mapping.getCollectionId() + "' AND objectid=" + mapping.getObjectId() + " AND uri='" + this.escapeForSql(mapping.getUri()) + "'");
        try {
            run.update(query.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        query = new StringBuilder("UPDATE URIMEDIAMAP SET STATUS = " + mapping.getStatus() + " WHERE collectionid='" + mapping.getCollectionId() + "' AND mediaid=" + mapping.getMediaId() + " AND uri='" + this.escapeForSql(mapping.getUri()) + "'");
        try {
            run.update(query.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Map getMediaIdsByCollection(String collectionId) throws DataAccessException {
        if (StringUtils.isBlank((String)collectionId)) {
            return null;
        }
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        StringBuilder query = new StringBuilder("SELECT mediaid, uri FROM URIMEDIAMAP where collectionid = '" + collectionId + "'");
        try {
            Map found = (Map)this.constructObject((CharSequence)query, (ResultSetHandler)new KeyedHandler("uri"));
            for (String uri : found.keySet()) {
                toReturn.put(uri, (Integer)((Map)found.get(uri)).get("mediaid"));
            }
            return toReturn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to id for this uri", (Throwable)e);
        }
        catch (NullPointerException ne) {
            return null;
        }
    }

    private Map getObjectIdsByCollection(String collectionId) throws DataAccessException {
        if (StringUtils.isBlank((String)collectionId)) {
            return null;
        }
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        StringBuilder query = new StringBuilder("SELECT objectid, uri FROM URIOBJECTMAP where collectionid = '" + collectionId + "'");
        try {
            Map found = (Map)this.constructObject((CharSequence)query, (ResultSetHandler)new KeyedHandler("uri"));
            for (String uri : found.keySet()) {
                toReturn.put(uri, (Integer)((Map)found.get(uri)).get("objectid"));
            }
            return toReturn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to id for this uri", (Throwable)e);
        }
        catch (NullPointerException ne) {
            return null;
        }
    }

    @Override
    public void setMediaSearchDao(MediaSearchDao mediaSearchDao) {
        this.mediaSearchDao = mediaSearchDao;
    }

    @Override
    public String getPathToPublicContent() throws DataAccessException {
        return null;
    }

    public void setPublicMediaDAO(MediaDAO publicMediaDAO) {
        this.publicMediaDAO = publicMediaDAO;
    }

    public MediaCollectionDao getMediaCollectionDao() {
        return this.mediaCollectionDao;
    }

    public void setMediaCollectionDao(MediaCollectionDao mediaCollectionDao) {
        this.mediaCollectionDao = mediaCollectionDao;
    }

    public Set<IiifTaskLog> getProgressLogs() {
        return this.progressLogs;
    }

    public void setProgressLogs(Set<IiifTaskLog> progressLogs) {
        this.progressLogs = progressLogs;
    }

    public void setMediaFieldDao(MediaFieldDao mediaFieldDao) {
        this.mediaFieldDao = mediaFieldDao;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public void setPermissionSetupRequester(PermissionSetupRequester permissionSetupRequester) {
        this.permissionSetupRequester = permissionSetupRequester;
    }

    public void setDefaultTermLists(Map<String, Object> defaultTermLists) {
        this.defaultTermLists = defaultTermLists;
    }

    @Override
    public void setAllLocalMediaCollections(List<MediaCollection> allLocalMediaCollections) {
        this.allLocalMediaCollections = allLocalMediaCollections;
    }

    public void setMaximumIdCache(int maximumIdCache) {
        this.maximumIdCache = maximumIdCache;
    }

    public void setCommitThreshold(int commitThreshold) {
        this.commitThreshold = commitThreshold;
    }
}

