/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.PresentationDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.Presentation;
import com.lunaimaging.insight.core.domain.Slide;
import com.lunaimaging.insight.core.domain.SlideImage;
import com.lunaimaging.insight.core.domain.SlideMedia;
import com.lunaimaging.insight.core.domain.SlideVideo;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.SearchCriteria;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcPresentationDao
extends JdbcBaseDao
implements PresentationDao,
Maintainable {
    protected int maximumPresentaitonCache = 5000;
    protected LRUCache presentationsCache = new LRUCache();
    protected LRUCache slidesCache = new LRUCache();
    private boolean initialized = false;

    public void setMaximumPresentaitonCache(int maximumPresentaitonCache) {
        this.maximumPresentaitonCache = maximumPresentaitonCache;
    }

    @Override
    public List<Presentation> getPresentations(int sampleSize) throws DataAccessException {
        ArrayList<Presentation> toReturn = new ArrayList<Presentation>();
        toReturn.addAll(this.presentationsCache.getSome(sampleSize));
        return toReturn;
    }

    @Override
    public List<Presentation> getAllPresentations() {
        return (List)this.presentationsCache.getAll();
    }

    @Override
    public List<Presentation> getPresentations(User user) throws DataAccessException {
        ArrayList<Presentation> toReturn = new ArrayList<Presentation>();
        try {
            List ps;
            if (user != null && (ps = (List)this.constructObjects(Presentation.class, "userId", user.getId())) != null) {
                toReturn.addAll(ps);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve Presentaitons for user: " + user, (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public Presentation getPresentation(int id) throws DataAccessException {
        Presentation p = null;
        try {
            p = (Presentation)this.presentationsCache.get(id);
            if (p == null && (p = (Presentation)this.constructObject(Presentation.class, id)) != null) {
                this.presentationsCache.put(id, p);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve getPresentations!", (Throwable)e);
        }
        return p;
    }

    @Override
    public List<Presentation> getPresentations(SearchCriteria presentationSearchCriteria, User user) {
        Presentation p = new Presentation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(p.getClass()).getTableName() + " WHERE ");
        ArrayList<User> uList = presentationSearchCriteria.getUsers();
        boolean addAnd = false;
        if (user != null || uList != null) {
            if (user != null && !user.equals(uList.get(0)) || user == null && uList != null) {
                query.append(" (publiclyViewable = 1) AND ");
            }
            query.append(" (userId IN ( ");
            String userIdAppendPrefix = "";
            for (User u : uList) {
                query.append(userIdAppendPrefix + u.getId());
                userIdAppendPrefix = ", ";
            }
            query.append(" ) ) ");
            addAnd = true;
        } else if (user == null && uList == null) {
            query.append(" (publiclyViewable = 1) AND ");
        }
        if (!presentationSearchCriteria.getSearchText().trim().equals("")) {
            if (addAnd) {
                query.append(" AND ");
            }
            addAnd = true;
            query.append(" ( ");
            query.append(" ( displayName LIKE '%" + this.escapeForSql(presentationSearchCriteria.getSearchText().trim()) + "%' ");
            query.append("  ) OR ( ");
            query.append(" description LIKE '%" + this.escapeForSql(presentationSearchCriteria.getSearchText().trim()) + "%' ");
            query.append(" ) ) ");
        }
        if (!presentationSearchCriteria.isIncludeLocked()) {
            if (addAnd) {
                query.append(" AND ");
            }
            query.append(" (password IS NULL OR password = '') ");
        }
        query.append(" ORDER BY displayName ");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(Presentation.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve Presentations for this presentationSearchCriteria", (Throwable)e);
        }
    }

    @Override
    public List<Slide> getSlides(Presentation p) throws DataAccessException {
        ArrayList<Slide> slides = new ArrayList<Slide>();
        try {
            this.initialize();
            int key = p.getId();
            if (this.slidesCache.contains(key)) {
                slides.addAll((List)this.slidesCache.get(key));
            } else {
                Collection theSlides = this.constructObjects(Slide.class, "presentationId", key);
                if (!CollectionUtils.isEmpty((Collection)theSlides)) {
                    slides.addAll(theSlides);
                    for (Slide s : slides) {
                        if (s == null) continue;
                        s.addAll((List)this.constructObjects(SlideImage.class, "slideId", s.getId()));
                        s.addAll((List)this.constructObjects(SlideVideo.class, "slideId", s.getId()));
                    }
                    this.slidesCache.put(key, slides);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve getSlides!", (Throwable)e);
        }
        return slides;
    }

    @Override
    public void savePresentation(Presentation p) throws DataAccessException {
        try {
            this.saveObject(p);
            this.presentationsCache.put(p.getId(), p);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created Presentation", (Throwable)e);
        }
    }

    @Override
    public void saveSlideMedia(Slide s) throws DataAccessException {
        try {
            ArrayList<SlideMedia> sms = new ArrayList<SlideMedia>(s.getSlideImages());
            this.deleteAllSlideMedia(s);
            for (SlideMedia sm : sms) {
                if (sm == null) continue;
                sm.setId(0);
                this.saveObjectOnly(sm);
                s.add(sm);
            }
            this.updateCache(s);
        }
        catch (SQLException e) {
            this.log.error((Object)("Unable to save SlideImages: " + s), (Throwable)e);
            throw new DataAccessResourceFailureException("Unable to save SlideImages: " + s, (Throwable)e);
        }
    }

    @Override
    public void saveSlide(Slide s) throws DataAccessException {
        try {
            this.saveObjectOnly(s);
            this.updateCache(s);
        }
        catch (SQLException e) {
            this.log.error((Object)("Unable to save Slide: " + s), (Throwable)e);
            throw new DataAccessResourceFailureException("Unable to save Slide: " + s, (Throwable)e);
        }
    }

    protected void updateCache(Slide s) {
        List slides;
        int key;
        if (s != null && this.slidesCache.contains(key = s.getPresentationId()) && (slides = (List)this.slidesCache.get(key)) != null) {
            slides.remove(s);
            slides.add(s);
            this.slidesCache.put(key, slides);
        }
    }

    @Override
    public void deletePresentation(Presentation pres) throws DataAccessException {
        try {
            ArrayList<Slide> slides = new ArrayList<Slide>(this.getSlides(pres));
            for (Slide s : slides) {
                this.deleteAllSlideMedia(s);
                this.deleteSlide(s);
            }
            this.presentationsCache.remove(pres.getId());
            this.deleteObject(pres);
        }
        catch (SQLException e) {
            this.log.error((Object)("Trouble deleting presentation: " + pres), (Throwable)e);
            throw new DataAccessResourceFailureException("Trouble deleting presentation: " + pres, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Error: ", (Throwable)e);
            throw new DataAccessResourceFailureException("Trouble deleting presentation: ", (Throwable)e);
        }
    }

    @Override
    public void deleteSlide(Slide slide) throws DataAccessException {
        try {
            this.deleteObject(slide);
            int key = slide.getPresentationId();
            if (this.slidesCache.contains(key)) {
                List slides = (List)this.slidesCache.get(key);
                slides.remove(slide);
                this.slidesCache.put(key, slides);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Unable to delete Slide: " + slide), (Throwable)e);
            throw new DataAccessResourceFailureException("Unable to save Slide: " + slide, (Throwable)e);
        }
    }

    @Override
    public void deleteSlideImage(Slide slide, SlideMedia sm) throws DataAccessException {
        try {
            this.deleteObject(sm);
            if (slide != null) {
                List slides;
                slide.getSlideImages().remove(sm);
                int key = slide.getPresentationId();
                if (this.slidesCache.contains(key) && (slides = (List)this.slidesCache.get(key)).contains(slide)) {
                    Slide theSlide = (Slide)slides.get(slides.indexOf(slide));
                    theSlide.getSlideImages().remove(sm);
                    this.slidesCache.put(key, slides);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Unable to delete SlideImage: " + sm), (Throwable)e);
            throw new DataAccessResourceFailureException("Unable to dekete SlideImage: " + sm, (Throwable)e);
        }
    }

    @Override
    public void deleteAllSlideMedia(Slide slide) throws DataAccessException {
        if (slide != null) {
            try {
                if (slide != null) {
                    List slides;
                    this.deleteObjects(SlideImage.class, "slideId", slide.getId());
                    this.deleteObjects(SlideVideo.class, "slideId", slide.getId());
                    slide.getSlideImages().clear();
                    int key = slide.getPresentationId();
                    if (this.slidesCache.contains(key) && (slides = (List)this.slidesCache.get(key)).contains(slide)) {
                        Slide theSlide = (Slide)slides.get(slides.indexOf(slide));
                        this.slidesCache.put(key, slides);
                    }
                }
            }
            catch (SQLException e) {
                this.log.error((Object)("Unable to delete SlideImage for slide: " + slide), (Throwable)e);
                throw new DataAccessResourceFailureException("Unable to delete SlideImages for slide: " + slide, (Throwable)e);
            }
        }
    }

    @Override
    public void deleteSlideImagesByMediaId(String mediaId) throws DataAccessException {
        try {
            ArrayList presentationIds = (ArrayList)this.getObjectsAsList("SELECT PRESENTATIONID AS ID FROM SLIDES WHERE ID IN (SELECT SLIDEID FROM SLIDEIMAGES  WHERE MEDIAID= " + this.convertInput(mediaId) + ")");
            Iterator iterator = presentationIds.iterator();
            while (iterator.hasNext()) {
                Object[] presentationId;
                Object[] rowData = presentationId = (Object[])iterator.next();
                int id = Integer.parseInt(rowData[0].toString());
                this.slidesCache.remove(id);
            }
            this.doUpdateOrSimpleInsert("DELETE FROM SLIDEIMAGES  WHERE MEDIAID = " + this.convertInput(mediaId));
        }
        catch (SQLException e) {
            this.log.error((Object)("Unable to delete SlideImage for mediaId: " + mediaId), (Throwable)e);
            throw new DataAccessResourceFailureException("Unable to dekete SlideImage for mediaId: " + mediaId, (Throwable)e);
        }
    }

    public synchronized void purgeCollectionSlideMedia(String collectionId) {
        try {
            this.initializePresentations();
            this.initializeSlides();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        List<Presentation> presentations = this.getAllPresentations();
        for (Presentation p : presentations) {
            List<Slide> slides = this.getSlides(p);
            for (Slide s : slides) {
                List<SlideMedia> sms = s.getSlideImages();
                Iterator<SlideMedia> iter = sms.iterator();
                while (iter.hasNext()) {
                    SlideMedia sm = iter.next();
                    if (!InsightCoreUtils.getCollectionIdFromLunaMediaId(sm.getMediaId()).equals(collectionId)) continue;
                    iter.remove();
                    this.deleteSlideImage(s, sm);
                }
            }
        }
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.initializePresentations();
            this.initializeFolders();
            this.initializeSlides();
            this.initialized = true;
        }
    }

    private void initializePresentations() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new presentations cache");
        this.presentationsCache = new LRUCache(this.maximumPresentaitonCache);
        Collection allPresentations = this.getAllObjects(Presentation.class, this.presentationsCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allPresentations)) {
            for (Presentation p : allPresentations) {
                this.presentationsCache.put(p.getId(), p);
            }
        }
        this.log.debug((Object)("Completed presentations cache: " + this.presentationsCache.size()));
    }

    private void initializeFolders() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new folders cache");
        ArrayList allFolders = new ArrayList();
        this.log.debug((Object)"Completed folder cache");
    }

    private void initializeSlides() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new slides cache");
        ArrayList allSlides = new ArrayList();
        this.slidesCache.purge();
        this.log.debug((Object)"Completed slides cache");
    }

    @Override
    public int getTotalPresentation() {
        return this.presentationsCache.size();
    }

    @Override
    public void startMaintenance() throws Exception {
        this.presentationsCache.purge();
        this.slidesCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

