/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaStandardFieldDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.MediaStandardField;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcMediaStandardFieldDao
extends JdbcBaseDao
implements MediaStandardFieldDao,
Maintainable {
    protected int maximumMediaStandardFieldCache = 1000;
    protected LRUCache mediaStandardFieldCache = new LRUCache();
    private boolean initialized = false;

    @Override
    public List<MediaStandardField> getAllMediaStandardFields(int standardId) throws DataAccessException {
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(MediaStandardField.class).getTableName());
        query.append(" WHERE STANDARDID IN (" + standardId + ")");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaStandardField.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media standard field for this field", (Throwable)e);
        }
    }

    @Override
    public MediaStandardField getMediaFieldStandard(String standardFieldName, int standardId) throws DataAccessException {
        MediaStandardField msf = null;
        msf = (MediaStandardField)this.mediaStandardFieldCache.get(standardId + ":" + standardFieldName.toLowerCase());
        if (msf == null) {
            StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(MediaStandardField.class).getTableName());
            query.append(" WHERE ( STANDARDID = " + standardId + ")");
            query.append(" AND ( STANDARDFIELDNAME = '" + standardFieldName + "')");
            try {
                msf = (MediaStandardField)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaStandardField.class));
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                e.printStackTrace();
                throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media standard field", (Throwable)e);
            }
            if (msf != null) {
                this.mediaStandardFieldCache.put(standardId + ":" + standardFieldName.toLowerCase(), msf);
            }
        }
        return msf;
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.initializeMediaStandardFields();
            this.initialized = true;
        }
    }

    private void initializeMediaStandardFields() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new media standard fields cache");
        this.mediaStandardFieldCache = new LRUCache(this.maximumMediaStandardFieldCache);
        Collection allMediaStandardFields = this.getAllObjects(MediaStandardField.class, this.mediaStandardFieldCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allMediaStandardFields)) {
            for (MediaStandardField msf : allMediaStandardFields) {
                this.mediaStandardFieldCache.put(msf.getStandardId() + ":" + msf.getStandardFieldName().toLowerCase(), msf);
            }
        }
        this.log.debug((Object)"Completed media standard fields cache.");
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaStandardFieldCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

