/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaManifestDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.MediaManifest;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcMediaManifestDao
extends JdbcBaseDao
implements MediaManifestDao,
Maintainable {
    protected int maximumManifestCache = 5000;
    protected LRUCache manifestsCache = new LRUCache();
    private boolean initialized = false;

    public void setMaximumManifestCache(int maxManifestsCache) {
        this.maximumManifestCache = maxManifestsCache;
    }

    @Override
    public MediaManifest getToken(String mappedUrl) throws DataAccessException {
        MediaManifest a = null;
        try {
            List result = (List)this.constructObjects(MediaManifest.class, "sourceUrl", mappedUrl);
            if (result.size() > 0) {
                a = (MediaManifest)result.get(0);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve token for " + mappedUrl + "!", (Throwable)e);
        }
        return a;
    }

    public MediaManifest getMediaManifest(int manifestId) throws DataAccessException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        MediaManifest manifest = null;
        try {
            String query = "SELECT *  FROM " + this.getMetadataBean(MediaManifest.class).getTableName() + " WHERE " + this.getMetadataBean(MediaManifest.class).getIdColumnName() + "=?";
            this.log.debug((Object)query);
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(query);
            stmt.setInt(1, manifestId);
            stmt.executeQuery();
            rs = stmt.getResultSet();
            if (rs != null && rs.next()) {
                InputStream in = rs.getClob("MANIFESTDATA").getAsciiStream();
                StringWriter w = new StringWriter();
                IOUtils.copy((InputStream)in, (Writer)w);
                String manifestData = w.toString();
                manifest = new MediaManifest(manifestId, rs.getString("TOKEN"), rs.getString("DISPLAYNAME"), rs.getString("DESCRIPTION"), rs.getString("MANIFESTURL"), manifestData, rs.getString("SOURCEURL"), rs.getInt("USERID"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to read Manifest data", (Throwable)e);
            this.log.error((Object)e);
            e.printStackTrace();
            System.out.println(e.toString());
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media manifest!", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return manifest;
    }

    @Override
    public MediaManifest getManifestByToken(String token) throws DataAccessException {
        MediaManifest a = (MediaManifest)this.manifestsCache.get(token);
        if (a != null) {
            return a;
        }
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        MediaManifest manifest = null;
        try {
            String query = "SELECT *  FROM " + this.getMetadataBean(MediaManifest.class).getTableName() + " WHERE TOKEN = ?";
            this.log.debug((Object)query);
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(query);
            stmt.setString(1, token);
            stmt.executeQuery();
            rs = stmt.getResultSet();
            if (rs != null && rs.next()) {
                InputStream in = rs.getClob("MANIFESTDATA").getAsciiStream();
                StringWriter w = new StringWriter();
                IOUtils.copy((InputStream)in, (Writer)w);
                String manifestData = w.toString();
                manifest = new MediaManifest(rs.getInt("ID"), token, rs.getString("DISPLAYNAME"), rs.getString("DESCRIPTION"), rs.getString("MANIFESTURL"), manifestData, rs.getString("SOURCEURL"), rs.getInt("USERID"));
                this.manifestsCache.put(token, manifest);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to read Manifest data", (Throwable)e);
            this.log.error((Object)e);
            e.printStackTrace();
            System.out.println(e.toString());
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media manifest!", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return manifest;
    }

    @Override
    public void saveMediaManifest(MediaManifest manifest) throws DataAccessException {
        try {
            this.insertOnly(manifest, false);
            this.manifestsCache.put(manifest.getToken(), manifest);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created manifest", (Throwable)e);
        }
    }

    @Override
    public boolean isTokenAvailable(String token) throws DataAccessException {
        try {
            List result;
            MediaManifest a = (MediaManifest)this.manifestsCache.get(token);
            if (a == null && (result = (List)this.constructObjects(MediaManifest.class, "token", token)).size() == 0) {
                return true;
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve manifest!", (Throwable)e);
        }
        return false;
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Manifest(s)");
            this.initializeManifests();
            this.initialized = true;
        }
    }

    private void initializeManifests() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new manifest cache");
        this.manifestsCache = new LRUCache(this.maximumManifestCache);
        Collection allManifests = this.getAllObjects(MediaManifest.class, this.manifestsCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allManifests)) {
            for (MediaManifest a : allManifests) {
                this.manifestsCache.put(a.getToken(), a);
            }
        }
        this.log.debug((Object)("Completed manifest cache: " + this.manifestsCache.size()));
    }

    @Override
    public void startMaintenance() throws Exception {
        this.manifestsCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

