/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaGroupsDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.MediaGroup;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.SearchCriteria;
import com.techempower.ReflectiveComparator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcMediaGroupsDao
extends JdbcBaseDao
implements MediaGroupsDao,
Maintainable {
    protected LRUCache mediaGroupsCache = new LRUCache();
    protected boolean initialized = false;

    protected synchronized void initialize() throws DataRetrievalFailureException {
        if (!this.initialized) {
            this.log.debug((Object)"initialize()");
            try {
                this.constructMediaGroupsCache();
                this.initialized = true;
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                e.printStackTrace();
                throw new DataRetrievalFailureException("Unexpected error, unable to load PublisherMedia Groups Cache! ", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteMediaGroup(MediaGroup mg) {
        try {
            this.mediaGroupsCache.remove(mg.getId());
            this.deleteObject(mg);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to delete PublisherMedia Group, id=" + mg.getId(), (Throwable)e);
        }
    }

    @Override
    public MediaGroup getMediaGroup(int groupId) {
        try {
            MediaGroup mg = (MediaGroup)this.mediaGroupsCache.get(groupId);
            if (mg == null) {
                mg = (MediaGroup)this.constructObject(MediaGroup.class, groupId);
            }
            return mg;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve PublisherMedia Groups for id=" + groupId, (Throwable)e);
        }
    }

    @Override
    public List<MediaGroup> getMediaGroups(int sampleSize) {
        return (List)this.mediaGroupsCache.getSome(sampleSize);
    }

    @Override
    public List<MediaGroup> getAllMediaGroups() {
        return (List)this.mediaGroupsCache.getAll();
    }

    @Override
    public List<MediaGroup> getMediaGroups(SearchCriteria groupSearchCriteria, boolean includeNonPublicGroups) {
        String concat;
        boolean firstEntry = true;
        MediaGroup mg = new MediaGroup();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(mg.getClass()).getTableName());
        if (!includeNonPublicGroups) {
            query.append(" WHERE (publiclyViewable = 1) ");
            firstEntry = false;
        }
        if (groupSearchCriteria.getUsers() != null && groupSearchCriteria.getUsers().size() > 0) {
            concat = firstEntry ? " WHERE " : " AND ";
            firstEntry = false;
            query.append(concat + " (userId IN ( ");
            String userIdAppendPrefix = "";
            for (User u : groupSearchCriteria.getUsers()) {
                query.append(userIdAppendPrefix + u.getId());
                userIdAppendPrefix = ", ";
            }
            query.append(" ) ) ");
        }
        if (!groupSearchCriteria.getSearchText().trim().equals("")) {
            concat = firstEntry ? " WHERE " : " AND ";
            firstEntry = false;
            query.append(concat + " ( ");
            query.append(" ( displayName LIKE '%" + this.escapeForSql(groupSearchCriteria.getSearchText().trim()) + "%' ");
            query.append("  ) OR ( ");
            query.append(" description LIKE '%" + this.escapeForSql(groupSearchCriteria.getSearchText().trim()) + "%' ");
            query.append(" ) ) ");
        }
        if (!groupSearchCriteria.isIncludeLocked()) {
            concat = firstEntry ? " WHERE " : " AND ";
            firstEntry = false;
            query.append(concat + " (password IS NULL OR password = '') ");
        }
        query.append(" ORDER BY displayName ");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaGroup.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve PublisherMedia Groups for this groupSearchCriteria", (Throwable)e);
        }
    }

    @Override
    public List<MediaGroup> getMediaGroups(User user) {
        try {
            List myGroups = (List)this.constructObject((CharSequence)("SELECT * FROM MEDIAGROUPS WHERE userId=" + user.getId()), (ResultSetHandler)new BeanListHandler(MediaGroup.class));
            Collections.sort(myGroups, new ReflectiveComparator("getDisplayName", 2));
            return myGroups;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve PublisherMedia Groups for User id=" + user.getId(), (Throwable)e);
        }
    }

    @Override
    public synchronized void saveMediaGroup(MediaGroup mediaGroup) throws DataAccessException {
        try {
            this.saveObject(mediaGroup);
            mediaGroup = (MediaGroup)this.constructObject(MediaGroup.class, mediaGroup.getId());
            this.mediaGroupsCache.put(mediaGroup.getId(), mediaGroup);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Error saving media group: displayName=" + mediaGroup.getDisplayName(), (Throwable)e);
        }
    }

    @Override
    public void deleteMediaGroupsMedia(String mediaId) {
        try {
            ArrayList mediaGroups = (ArrayList)this.getObjectsAsList("SELECT MEDIAGROUPID AS ID FROM MEDIAGROUPMEDIAMAP WHERE MEDIAID= " + this.convertInput(mediaId));
            Iterator iterator = mediaGroups.iterator();
            while (iterator.hasNext()) {
                Object[] mg;
                Object[] rowData = mg = (Object[])iterator.next();
                int id = Integer.parseInt(rowData[0].toString());
                this.mediaGroupsCache.remove(id);
            }
            this.doUpdateOrSimpleInsert("DELETE FROM MEDIAGROUPMEDIAMAP WHERE MEDIAID = " + this.convertInput(mediaId));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.log.error((Object)("Deleting mediaId = " + mediaId + " from mediaGroup failed"), (Throwable)e);
        }
    }

    public synchronized void purgeCollectionMedia(String collectionId) {
        try {
            this.constructMediaGroupsCache();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        List<Object> mgs = new ArrayList();
        ArrayList<String> mediaIdsToDelete = new ArrayList<String>();
        mgs = this.getAllMediaGroups();
        for (MediaGroup mediaGroup : mgs) {
            mediaIdsToDelete.addAll(mediaGroup.getMediaGroupMediaIdsByCollectionId(collectionId));
        }
        HashMap uniqueMediaIds = new HashMap();
        for (String mediaId : mediaIdsToDelete) {
            if (mediaId == null) continue;
            uniqueMediaIds.put(mediaId, null);
        }
        for (String mediaIdToDelete : uniqueMediaIds.keySet()) {
            this.deleteMediaGroupsMedia(mediaIdToDelete);
        }
    }

    private void constructMediaGroupsCache() throws SQLException {
        this.log.debug((Object)"Start constructing PublisherMedia Groups cache.");
        Collection allMediaGroups = new ArrayList();
        allMediaGroups = this.getAllObjects(MediaGroup.class, this.mediaGroupsCache.getMaximumSize());
        int count = 0;
        for (MediaGroup mg : allMediaGroups) {
            this.mediaGroupsCache.put(new Integer(mg.getId()), mg);
            if (!this.log.isDebugEnabled() || ++count % 50 != 1) continue;
            this.log.info((Object)("Adding MediaGroup: " + mg.getDisplayName() + ", # " + count + " of " + allMediaGroups.size() + " total PublisherMedia Groups."));
        }
        this.log.debug((Object)"Finished constructing PublisherMedia Groups cache.");
    }

    @Override
    public int getTotalMediaGroup() {
        return this.mediaGroupsCache.size();
    }

    public void setMediaGroupsCacheMaxSize(int mediaGroupsCacheMaxSize) {
        this.mediaGroupsCache.setMaximumSize(mediaGroupsCacheMaxSize);
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaGroupsCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

