/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaFieldStandardDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.MediaFieldStandard;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcMediaFieldStandardDao
extends JdbcBaseDao
implements MediaFieldStandardDao,
Maintainable {
    protected int maximumMediaFieldStandardCache = 20;
    protected LRUCache mediaFieldStandardCache = new LRUCache();
    private boolean initialized = false;

    @Override
    public List<MediaFieldStandard> getAllMediaFieldStandards() throws DataAccessException {
        MediaFieldStandard msf = new MediaFieldStandard();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(msf.getClass()).getTableName());
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldStandard.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field standard", (Throwable)e);
        }
    }

    @Override
    public MediaFieldStandard getMediaFieldStandard(String standardName) throws DataAccessException {
        MediaFieldStandard mfs = null;
        mfs = (MediaFieldStandard)this.mediaFieldStandardCache.get(standardName.toLowerCase());
        if (mfs == null) {
            StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(MediaFieldStandard.class).getTableName());
            query.append(" WHERE (STANDARDNAME = '" + standardName + "')");
            try {
                List list = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldStandard.class));
                if (list == null) {
                    return null;
                }
                mfs = (MediaFieldStandard)list.get(0);
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                e.printStackTrace();
                throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field standard", (Throwable)e);
            }
            if (mfs != null) {
                this.mediaFieldStandardCache.put(standardName.toLowerCase(), mfs);
            }
        }
        return mfs;
    }

    public MediaFieldStandard getMediaFieldStandardByNamespace(String namespace) throws DataAccessException {
        MediaFieldStandard mfs = null;
        mfs = (MediaFieldStandard)this.mediaFieldStandardCache.get(namespace.toLowerCase());
        if (mfs == null) {
            StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(MediaFieldStandard.class).getTableName());
            query.append(" WHERE (NAMESPACE = '" + namespace + "')");
            try {
                List list = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldStandard.class));
                if (list == null) {
                    return null;
                }
                mfs = (MediaFieldStandard)list.get(0);
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                e.printStackTrace();
                throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field standard", (Throwable)e);
            }
            if (mfs != null) {
                this.mediaFieldStandardCache.put(namespace.toLowerCase(), mfs);
            }
        }
        return mfs;
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.initializeMediaFieldStandards();
            this.initialized = true;
        }
    }

    private void initializeMediaFieldStandards() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new media field standards cache");
        this.mediaFieldStandardCache = new LRUCache(this.maximumMediaFieldStandardCache);
        Collection allMediaFieldStandards = this.getAllObjects(MediaFieldStandard.class, this.mediaFieldStandardCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allMediaFieldStandards)) {
            for (MediaFieldStandard mfs : allMediaFieldStandards) {
                this.mediaFieldStandardCache.put(mfs.getStandardName().toLowerCase(), mfs);
            }
        }
        this.log.debug((Object)"Completed media field standards cache.");
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaFieldStandardCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

