/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaFieldRelationDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaFieldRelation;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcMediaFieldRelationDao
extends JdbcBaseDao
implements MediaFieldRelationDao,
Maintainable {
    protected int maximumMediaFieldRelationCache = 1000;
    protected LRUCache mediaFieldRelationsCache = new LRUCache();
    private boolean initialized = false;

    @Override
    public List<MediaFieldRelation> getAllMediaFieldRelations(MediaCollection mc, String destStandardName) throws DataAccessException {
        MediaFieldRelation mfr = new MediaFieldRelation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(mfr.getClass()).getTableName());
        query.append(" WHERE SOURCESTANDARDID IN ('" + mc.getId() + "')");
        query.append(" AND ( DESTSTANDARDNAME = '" + destStandardName + "')");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldRelation.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field relations for this field", (Throwable)e);
        }
    }

    @Override
    public List<MediaFieldRelation> getAllMediaFieldRelations(MediaCollection mc, int destStandardId) throws DataAccessException {
        MediaFieldRelation mfr = new MediaFieldRelation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(mfr.getClass()).getTableName());
        query.append(" WHERE SOURCESTANDARDID IN ('" + mc.getId() + "')");
        query.append(" AND ( DESTSTANDARDID = " + destStandardId + ")");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldRelation.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field relations for this field", (Throwable)e);
        }
    }

    @Override
    public List<MediaFieldRelation> getAllMediaFieldRelations(List<MediaCollection> mcs, String standardName) throws DataAccessException {
        return this.getAllMediaFieldRelations(mcs, this.getStandardId(standardName));
    }

    @Override
    public List<MediaFieldRelation> getAllMediaFieldRelations(List<MediaCollection> mcs, int destStandardId) throws DataAccessException {
        if (mcs == null || mcs.size() == 0) {
            return null;
        }
        boolean firstEntry = true;
        MediaFieldRelation mfr = new MediaFieldRelation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(mfr.getClass()).getTableName());
        query.append(" WHERE ( SOURCESTANDARDID IN (");
        for (MediaCollection mc : mcs) {
            if (!firstEntry) {
                query.append(",");
            }
            query.append("'" + mc.getId() + "'");
            firstEntry = false;
        }
        query.append(" ) ) ");
        query.append(" AND ( DESTSTANDARDID = " + destStandardId + ")");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldRelation.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field relations for this collection", (Throwable)e);
        }
    }

    public int getStandardId(String destStandardName) throws DataAccessException {
        StringBuilder query = new StringBuilder("SELECT DISTINCT STANDARDID FROM MEDIAFIELDSTANDARDS");
        query.append(" WHERE ( STANDARDNAME = '" + destStandardName + "' )");
        try {
            Object searchResult = this.constructObject((CharSequence)query, (ResultSetHandler)new ScalarHandler(1));
            return Integer.parseInt(searchResult.toString());
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field relations for this field", (Throwable)e);
        }
    }

    public String getStandardName(int standardId) throws DataAccessException {
        StringBuilder query = new StringBuilder("SELECT DISTINCT STANDARDNAME FROM MEDIAFIELDSTANDARDS");
        query.append(" WHERE ( STANDARDID = " + standardId + " )");
        try {
            Object searchResult = this.constructObject((CharSequence)query, (ResultSetHandler)new ScalarHandler(1));
            return searchResult.toString();
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field relations for this field", (Throwable)e);
        }
    }

    @Override
    public MediaFieldRelation getMediaFieldRelation(MediaCollection mc, String sourceFieldName, String destStandardName) throws DataAccessException {
        MediaFieldRelation mfr = null;
        mfr = (MediaFieldRelation)this.mediaFieldRelationsCache.get(mc.getId().toLowerCase() + ":" + sourceFieldName.toLowerCase() + ":" + destStandardName.toLowerCase());
        if (mfr == null && (mfr = this.getMediaFieldRelation(mc, sourceFieldName, this.getStandardId(destStandardName))) != null) {
            this.mediaFieldRelationsCache.put(mc.getId().toLowerCase() + ":" + sourceFieldName.toLowerCase() + ":" + destStandardName.toLowerCase(), mfr);
        }
        return mfr;
    }

    @Override
    public MediaFieldRelation getMediaFieldRelation(MediaCollection mc, String sourceFieldName, int destStandardId) throws DataAccessException {
        MediaFieldRelation mfr = new MediaFieldRelation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(mfr.getClass()).getTableName());
        query.append(" WHERE ( SOURCESTANDARDID = '" + mc.getId() + "')");
        query.append(" AND ( SOURCEFIELDNAME = '" + sourceFieldName + "')");
        query.append(" AND ( DESTSTANDARDID = " + destStandardId + ")");
        try {
            MediaFieldRelation searchResult = (MediaFieldRelation)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(MediaFieldRelation.class));
            return searchResult;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve media field relations for this field", (Throwable)e);
        }
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.initializeMediaFieldRelations();
            this.initialized = true;
        }
    }

    private void initializeMediaFieldRelations() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new media field relations cache");
        this.mediaFieldRelationsCache = new LRUCache(this.maximumMediaFieldRelationCache);
        HashMap<Integer, String> standardIdNameMap = new HashMap<Integer, String>();
        Collection allMediaFieldRelations = this.getAllObjects(MediaFieldRelation.class, this.mediaFieldRelationsCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allMediaFieldRelations)) {
            for (MediaFieldRelation mfr : allMediaFieldRelations) {
                if (!standardIdNameMap.containsKey(mfr.getDestStandardId())) {
                    standardIdNameMap.put(mfr.getDestStandardId(), this.getStandardName(mfr.getDestStandardId()));
                }
                this.mediaFieldRelationsCache.put(mfr.getSourceStandardId().toLowerCase() + ":" + mfr.getSourceFieldName().toLowerCase() + ":" + ((String)standardIdNameMap.get(mfr.getDestStandardId())).toLowerCase(), mfr);
            }
        }
        this.log.debug((Object)"Completed media field relations cache.");
    }

    @Override
    public void startMaintenance() throws Exception {
        this.mediaFieldRelationsCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public void updateOrSaveMediaFieldRelations(List<MediaFieldRelation> mfrs) throws SQLException, InvalidParameterException {
        if (mfrs != null && mfrs.size() > 0) {
            this.purgeMediaFieldRelations(mfrs.get(0).getSourceStandardId());
        }
        this.saveMediaFieldRelations(mfrs);
    }

    @Override
    public void saveMediaFieldRelations(List<MediaFieldRelation> mfrs) throws DataAccessException {
        if (!CollectionUtils.isEmpty(mfrs)) {
            try {
                this.batchInsert(mfrs);
            }
            catch (SQLException e) {
                this.log.debug((Object)"Unexpected error, unable to insert media field relations into table.");
                e.printStackTrace();
            }
        } else {
            this.log.debug((Object)"No MediaFieldRelations found");
        }
    }

    public void purgeMediaFieldRelations(String lunaCollectionId) {
        try {
            String[] result = ParsingUtils.splitIgnoreCaseTrim(lunaCollectionId, "~");
            if (result == null || result.length != 3) {
                throw new Exception("Invalid luna collection id: " + lunaCollectionId);
            }
            this.deleteObjects(MediaFieldRelation.class, "SOURCESTANDARDID", lunaCollectionId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

