/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.ExternalMedia;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.SharedLunaMedia;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.jdbc.MediaBeanHandler;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.dbutils.ResultSetHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcMediaDao
extends JdbcBaseDao
implements MediaDao {
    private boolean initialized = false;
    protected LRUCache mediaCache = new LRUCache();
    protected LRUCache externalObjectDataCache = new LRUCache();
    protected String mediaTitleColumnName;

    public void setMediaCacheMaxSize(int mediaCacheMaxSize) {
        this.mediaCache.setMaximumSize(mediaCacheMaxSize);
    }

    public void setMediaTitleColumnName(String mediaTitleColumnName) {
        this.mediaTitleColumnName = mediaTitleColumnName;
    }

    @Override
    public void setAllMediaCollections(List<MediaCollection> allMediaCollections) {
    }

    @Override
    public LunaMedia getLunaMedia(String id, boolean updateCache) {
        if (updateCache) {
            this.mediaCache.remove(id);
        }
        return this.getLunaMedia(id);
    }

    @Override
    public LunaMedia getLunaMedia(PublisherMedia pm, boolean updateCache) {
        return null;
    }

    @Override
    public LunaMedia getLunaMedia(String id) {
        LunaMedia media = (LunaMedia)this.mediaCache.get(id);
        if (media == null) {
            try {
                media = this.constructLunaMedia(id);
                if (media != null) {
                    this.mediaCache.put(id, media);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
                throw new DataAccessResourceFailureException("Unexpected error, unable to retrieve PublisherMedia!", (Throwable)e);
            }
        }
        if (media == null) {
            throw new DataRetrievalFailureException("Unable to locate image! [" + id + "]");
        }
        return media;
    }

    @Override
    public ExternalMedia getExternalMedia(String id) {
        ExternalMedia media = (ExternalMedia)this.externalObjectDataCache.get(id);
        if (media == null) {
            try {
                media = this.constructExternalObjectData(id);
                if (media != null) {
                    this.externalObjectDataCache.put(id, media);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
                throw new DataAccessResourceFailureException("Unexpected error, unable to retrieve PublisherMedia!", (Throwable)e);
            }
        }
        if (media == null) {
            throw new DataRetrievalFailureException("Unable to locate image! [" + id + "]");
        }
        return media;
    }

    private synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.info((Object)"initializing Cache(s)");
            this.initialized = true;
        }
    }

    private LunaMedia constructLunaMedia(String id) throws SQLException {
        MediaBeanHandler mediaBeanHandler = new MediaBeanHandler(this.mediaTitleColumnName);
        LunaMedia media = (LunaMedia)this.constructObjectOnly(LunaMedia.class, id, (ResultSetHandler)mediaBeanHandler);
        if (media == null) {
            media = (LunaMedia)this.constructObjectOnly(SharedLunaMedia.class, id, (ResultSetHandler)mediaBeanHandler);
        }
        return media;
    }

    private ExternalMedia constructExternalObjectData(String id) throws SQLException {
        ExternalMedia media = (ExternalMedia)this.constructObjectOnly(ExternalMedia.class, id);
        return media;
    }

    @Override
    public void saveExternalObjectData(ExternalMedia eod) throws DataAccessException {
        try {
            this.saveObject(eod);
            this.externalObjectDataCache.put(eod.getIdentity(), eod);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created ExternalObjectData", (Throwable)e);
        }
    }

    @Override
    public void getImageFiles(List<String> mediaIds) {
    }

    @Override
    public List<ExternalMedia> getExternalMediaByUser(String userId, String mediaSource) throws SQLException {
        String query = "SELECT * FROM EXTERNALMEDIA WHERE OBJECTOWNERID= " + this.convertInput(userId) + " AND MEDIASOURCE='" + mediaSource + "' AND ORIGINATINGURL IS NULL";
        List mediaList = (List)this.constructObjects(ExternalMedia.class, query);
        return mediaList;
    }

    @Override
    public List<ExternalMedia> getExternalMedias(String query) throws SQLException {
        List mediaList = (List)this.constructObjects(ExternalMedia.class, query);
        return mediaList;
    }

    @Override
    public void removeExternalMedia(List<ExternalMedia> mediaList) throws SQLException {
        this.deleteObject(mediaList);
    }

    @Override
    public Vector<String> getImageExportUrls(String mediaId) throws DataAccessException {
        return null;
    }

    @Override
    public Vector<String> getExternalMediaExportUrls(String mediaId) throws DataAccessException {
        return null;
    }

    @Override
    public Vector<String> getImageExportUrls(PublisherMedia pm) throws DataAccessException {
        return null;
    }
}

