/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.inscribe.domain.LunaCollectionId;
import com.lunaimaging.insight.core.dao.ContentDistributionDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcResourceDiscoveryDao;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.SharedExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.MediaCollectionUtils;
import com.lunaimaging.publisher.distribution.iiif.IiifCollection3Importer;
import com.lunaimaging.publisher.distribution.iiif.IiifCollectionImporter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.dao.DataAccessException;

public class JdbcIiifCollectionsDao
extends JdbcResourceDiscoveryDao
implements ContentDistributionDao {
    protected static final Log log = LogFactory.getLog(JdbcIiifCollectionsDao.class);

    @Override
    public void fetchExternalPublicContent(List<String> sourceUrls) throws DataAccessException {
        log.debug((Object)"fetchExternalPublicContent(.)");
        Maintainable m = (Maintainable)((Object)this.mediaCollectionDao);
        SharedMediaCollection smc = null;
        SharedExtendedCollectionProperties sprops = null;
        boolean isNew = true;
        try {
            m.startMaintenance();
            m.endMaintenance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        SharedMediaCollection existingCol = this.mediaCollectionDao.getSharedCollection(sourceUrls.get(0));
        if (existingCol != null) {
            isNew = false;
            List<MediaField> mfs = this.mediaFieldDao.getAllMediaFields(existingCol);
            if (mfs != null) {
                existingCol.setMediaFields(mfs);
            }
            if (existingCol.getMediaFields() == null) {
                log.debug((Object)"----------------------null fields!");
            }
        }
        Object importer = null;
        boolean isV3Collection = false;
        try {
            isV3Collection = this.isV3Collection(sourceUrls.get(0));
        }
        catch (IOException | JSONException e1) {
            log.error((Object)e1);
        }
        importer = isV3Collection ? new IiifCollection3Importer(sourceUrls.get(0), this.publicMediaDAO) : new IiifCollectionImporter(sourceUrls.get(0), this.publicMediaDAO);
        importer.initializeCollection((MediaCollection)existingCol);
        importer.setCollectionDao(this.mediaCollectionDao);
        importer.setResourceDiscoveryDao((JdbcResourceDiscoveryDao)this);
        importer.setDefaultTermList(this.defaultTermLists);
        MediaCollection mc = importer.getThisCollection();
        try {
            smc = !(mc instanceof SharedMediaCollection) ? MediaCollectionUtils.constructSharedMediaCollection(mc) : (SharedMediaCollection)mc;
            sprops = (SharedExtendedCollectionProperties)smc.getExtendedCollectionProperties();
            if (importer.isLunaCollection) {
                List<MediaField> mfs = mc.getMediaFields();
                log.debug((Object)("Transferring " + mfs.size() + " Fields"));
                for (MediaField mf : mfs) {
                    log.debug((Object)("MediaField[name,previewsort,summarysort,order,w4type]: [" + mf.getFieldName() + "," + mf.getPreviewFieldSort() + "," + mf.getSummaryDescriptionFieldSort() + "," + mf.getDisplayOrder() + "," + mf.getW4Type() + "]"));
                }
                smc.setMediaFields(mfs);
                sprops.setUri(sourceUrls.get(0));
                if (StringUtils.isNotBlank((String)this.collectionName)) {
                    smc.setCollectionName(this.collectionName);
                }
                if (StringUtils.isNotBlank((String)this.institutionName)) {
                    smc.setInstitutionName(this.institutionName);
                }
            } else if (existingCol == null) {
                List<MediaCollection> mcs = this.mediaCollectionDao.getPublicMediaCollections();
                int collectionId = MediaCollectionUtils.getCollectionMaxIdByInstitution(mcs, smc.getInstitutionId());
                LunaCollectionId lcid = new LunaCollectionId(smc.getInstitutionId(), String.valueOf(++collectionId), collectionId);
                smc.setCollectionId(lcid.getCollectionId());
                smc.setUniqueCollectionId(lcid.getUniqueCollectionId());
                smc.setId(lcid.toString());
                smc.setAbbreviatedName(lcid.toString());
                if (StringUtils.isNotBlank((String)this.collectionName)) {
                    smc.setCollectionName(this.collectionName);
                }
                if (StringUtils.isNotBlank((String)this.institutionName)) {
                    smc.setInstitutionName(this.institutionName);
                }
                sprops.setCollectionId(lcid.toString());
                sprops.setMaxMediaId(0);
                sprops.setMaxObjectId(0);
                sprops.setUri(sourceUrls.get(0));
            }
            if (existingCol == null) {
                try {
                    m.startMaintenance();
                    this.saveSharedMediaCollection(smc);
                    m.endMaintenance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (smc != null && this.permissionSetupRequester != null) {
                if (this.permissionSetupRequester.login()) {
                    this.permissionSetupRequester.requestPermissionSetup((MediaCollection)smc, this.permissionSetupRequester.getAuthUsername());
                } else {
                    log.error((Object)"Failed logging in. Could not set up permission in WebAdmin. Check username or password.");
                }
            }
            importer.setThisCollection((MediaCollection)smc);
            if (sprops.getLastCrawl() != null) {
                importer.setLastCrawl(sprops.getLastCrawl());
            }
            importer.run();
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sprops != null) {
            if (importer.getLastCrawl() != null) {
                sprops.setLastCrawl(importer.getLastCrawl());
            }
            sprops.setMaxObjectId(this.getMaxObjectId(sprops.getCollectionId()));
            sprops.setMaxMediaId(this.getMaxMediaId(sprops.getCollectionId()));
            try {
                if (smc.getMediaFields() == null) {
                    log.error((Object)"Saving no fields to databases!");
                }
                m.startMaintenance();
                this.updateOrSaveMediaCollection(smc);
                m.endMaintenance();
            }
            catch (InvalidParameterException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isV3Collection(String uri) throws IOException, JSONException {
        URL url = new URL(uri);
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "LUNA IIIF");
        InputStream inputStream = urlConnection.getInputStream();
        String contentBody = IOUtils.toString((InputStream)inputStream);
        JSONObject json = new JSONObject(contentBody);
        return json != null && json.has("items") && json.has("type") && "Collection".equals(json.get("type"));
    }
}

