/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.FoldersDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.Folder;
import com.lunaimaging.insight.core.domain.User;
import java.sql.SQLException;
import java.util.List;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcFoldersDao
extends JdbcBaseDao
implements FoldersDao {
    @Override
    public List<Folder> getFolders(User user) {
        try {
            return (List)this.constructObjects(Folder.class, "userId", user.getId());
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve Folders for User id=" + user.getId(), (Throwable)e);
        }
    }

    @Override
    public void deleteFolder(Folder folder) {
        try {
            this.deleteObject(folder);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to delete folder with id=" + folder.getId(), (Throwable)e);
        }
    }

    @Override
    public void saveFolder(Folder folder) {
        try {
            this.saveObject(folder);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to save folder with id=" + folder.getId(), (Throwable)e);
        }
    }
}

