/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.ContentDistributionDao;
import com.lunaimaging.insight.core.dao.MediaSearchDao;
import com.lunaimaging.insight.core.dao.lucene.LuceneBaseDao;
import com.lunaimaging.insight.core.domain.ContentDistributionDescriptor;
import com.lunaimaging.insight.core.domain.ExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.SharedExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.SharedLunaMedia;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.SharedMediaField;
import com.lunaimaging.insight.core.lucene.LuceneConnectorFactory;
import com.lunaimaging.insight.core.utils.FileUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.insight.core.utils.WebUtils;
import com.lunaimaging.insight.core.utils.XmlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class JdbcContentDistributionDao
extends LuceneBaseDao
implements ContentDistributionDao {
    protected static final Log log = LogFactory.getLog(JdbcContentDistributionDao.class);
    protected static final String DISTRIBUTED_CONTENT_DIRECTORY_NAME = "contentDistribution";
    protected static final String DESCRIPTOR_FILE_NAME = "Descriptor.xml";
    protected static final String INDEX_DIRECTORY = "index";
    protected static final DocType XML_DOC_TYPE = new DocType("beans", "-//SPRING//DTD BEAN 2.0//EN", "http://www.springframework.org/dtd/spring-beans-2.0.dtd");
    protected static final XMLOutputter XML_OUTPUTTER = new XMLOutputter(Format.getPrettyFormat());
    protected MediaSearchDao mediaSearchDao = null;
    protected static final String[] DESCRIPTOR_SKIP_PROPERTIES = new String[]{"identity", "mediaFields", "largestUrlAvailable", "maxLevel", "maxWidth", "maxHeight", "collection", "fieldValues", "summaryFieldValues", "description", "type", "image", "video", "audio", "insightMediaFields"};
    protected static final String[] MEDIA_SKIP_PROPERTIES = new String[]{"collection", "identity", "mediaId", "fieldValues", "summaryFieldValues", "description", "displayName", "type", "image", "video", "audio"};
    protected static final int MAX_DOCS_TO_DELETE = 500000;
    protected String contentDistributionDirectoy;
    protected boolean useCompression;
    protected List<MediaCollection> allLocalMediaCollections;

    public void setContentDistributionDirectoy(String contentDistributionDirectoy) {
        this.contentDistributionDirectoy = contentDistributionDirectoy;
    }

    @Override
    public void setLuceneConnectorFactory(LuceneConnectorFactory luceneConnectorFactory) {
        this.luceneConnectorFactory = luceneConnectorFactory;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Override
    public void setAllLocalMediaCollections(List<MediaCollection> allLocalMediaCollections) {
        this.allLocalMediaCollections = allLocalMediaCollections;
    }

    @Override
    public String getPathToPublicContent() throws DataAccessException {
        String path = this.contentDistributionDirectoy + DescriptorFileProperties.lunaContent.getFileName();
        return path;
    }

    @Override
    @Deprecated
    public void publishConsolidatedExternalPublicContent(List<String> sourceUrls) throws DataAccessException {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fetchExternalPublicContent(List<String> sourceUrls) throws DataAccessException {
        File workingDirectory = null;
        try {
            this.luceneConnectorFactory.closeReader();
            File publicContentDirectory = new File(this.luceneConnectorFactory.getPublicIndexPhysicalDirectory());
            if (publicContentDirectory.exists()) {
                FileUtils.deleteFolderContent(publicContentDirectory);
            } else {
                publicContentDirectory.mkdir();
            }
            this.purgeExistingContent(true);
            workingDirectory = new File(publicContentDirectory, "contentDistributionWorking");
            workingDirectory.mkdir();
            Map<String, File> distributedFileDirectories = this.getContent(workingDirectory, sourceUrls);
            this.processDescriptorFiles(distributedFileDirectories);
            this.processPublicIndexes(distributedFileDirectories);
            if (workingDirectory == null) return;
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Error fetching public content! ", (Throwable)e);
                throw new DataRetrievalFailureException("Error publish public content!", (Throwable)e);
                catch (IOException e2) {
                    log.error((Object)"Error fetching public content! ", (Throwable)e2);
                    throw new InvalidDataAccessResourceUsageException("Error publish public content!", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (workingDirectory == null) throw throwable;
                FileUtils.deleteFolderRecursive(workingDirectory);
                throw throwable;
            }
        }
        FileUtils.deleteFolderRecursive(workingDirectory);
    }

    public void purgeExistingContent(boolean shared) throws SQLException {
        this.deleteAllObjects(shared ? SharedMediaField.class : MediaField.class);
        this.deleteAllObjects(shared ? SharedMediaCollection.class : MediaCollection.class);
        this.deleteAllObjects(shared ? SharedExtendedCollectionProperties.class : ExtendedCollectionProperties.class);
    }

    public void purgeCollection(String lunaCollectionId) {
        try {
            String[] result = ParsingUtils.splitIgnoreCaseTrim(lunaCollectionId, "~");
            if (result == null || result.length != 3) {
                throw new Exception("Invalid luna collection id: " + lunaCollectionId);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("INSTITUTIONID", result[0]);
            params.put("COLLECTIONID", result[1]);
            params.put("UNIQUECOLLECTIONID", result[2]);
            this.deleteObjects(MediaField.class, params);
            this.deleteObjects(ExtendedCollectionProperties.class, "COLLECTIONID", lunaCollectionId);
            this.deleteObjects(MediaCollection.class, "ID", lunaCollectionId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, File> getContent(File workingDirectory, List<String> sourceUrls) throws IOException {
        HashMap<String, File> toReturn = new HashMap<String, File>();
        File[] distributedFiles = WebUtils.saveUrlToDirectory(sourceUrls.toArray(new String[0]), workingDirectory, DISTRIBUTED_CONTENT_DIRECTORY_NAME, ".zip");
        for (int i = 0; i < distributedFiles.length; ++i) {
            File f = distributedFiles[i];
            if (f != null && f.exists()) {
                File saveDirectory = new File(workingDirectory, DISTRIBUTED_CONTENT_DIRECTORY_NAME + toReturn.size());
                saveDirectory.mkdir();
                toReturn.put(sourceUrls.get(i), saveDirectory);
                FileUtils.unzipFile(f, saveDirectory);
                f.delete();
                continue;
            }
            log.info((Object)("ContentDistribution: Downloaded file not found." + f));
        }
        return toReturn;
    }

    @Deprecated
    private void processPublicIndexes(Map<String, File> distributedFileDirectories) throws IOException {
    }

    @Deprecated
    private void deleteLocalMediaFromPublicIndex() throws IOException {
        log.info((Object)("deleteLocalMediaFromPublicIndex::Top of: " + this.allLocalMediaCollections));
    }

    @Deprecated
    private String generateRemoveLocalCollectionsQuery() {
        StringBuilder toReturn = new StringBuilder();
        return toReturn.toString();
    }

    private void processDescriptorFiles(File distributedFileDirectory) throws SQLException {
        ArrayList<String> descriptorFilePaths;
        if (distributedFileDirectory != null && distributedFileDirectory.exists() && CollectionUtils.isNotEmpty(descriptorFilePaths = FileUtils.fetchFileList(distributedFileDirectory, null, DESCRIPTOR_FILE_NAME))) {
            File descritorFile = null;
            for (String path : descriptorFilePaths) {
                ContentDistributionDescriptor cdd;
                descritorFile = new File(path);
                if (!descritorFile.exists() || (cdd = this.constrcutDescriptorFile(descritorFile)) == null) continue;
                this.saveSharedMediaCollection(cdd.getSharedMediaCollection());
            }
        }
    }

    private void processDescriptorFiles(Map<String, File> distributedFileDirectories) throws SQLException {
        if (distributedFileDirectories != null) {
            for (String key : distributedFileDirectories.keySet()) {
                File dir = distributedFileDirectories.get(key);
                this.processDescriptorFiles(dir);
            }
        }
    }

    @Override
    public void updateOrSaveMediaCollection(MediaCollection mc) throws SQLException, InvalidParameterException {
        this.purgeCollection(mc.getId());
        this.saveMediaCollection(mc);
    }

    @Override
    public void saveMediaCollection(MediaCollection smc) throws SQLException {
        List<MediaField> mfs;
        if (smc == null) {
            throw new InvalidParameterException("No Shared PublisherMedia Collection to save!");
        }
        this.insertOnly(smc, true);
        if (smc.getExtendedCollectionProperties() != null) {
            this.insertOnly(smc.getExtendedCollectionProperties(), true);
        }
        if (CollectionUtils.isNotEmpty(mfs = smc.getMediaFields())) {
            this.batchInsert(mfs);
        } else {
            log.debug((Object)("No PublisherMedia Fields found for " + smc));
        }
    }

    @Override
    public void saveSharedMediaCollection(MediaCollection smc) throws SQLException, InvalidParameterException {
        if (smc == null) {
            throw new InvalidParameterException("No Shared PublisherMedia Collection to save!");
        }
        if (CollectionUtils.isNotEmpty(this.allLocalMediaCollections) && this.allLocalMediaCollections.contains(smc)) {
            log.info((Object)("Skipping local media collection: " + smc));
        } else {
            this.saveMediaCollection(smc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentDistributionDescriptor constrcutDescriptorFile(File f) {
        ContentDistributionDescriptor toReturn = null;
        try (AbstractApplicationContext ctx = null;){
            ctx = this.createApplicationContext(f);
            ctx.refresh();
            toReturn = (ContentDistributionDescriptor)ctx.getBean(DescriptorFileProperties.contentDescriptor.toString());
        }
        return toReturn;
    }

    protected AbstractApplicationContext createApplicationContext(File f) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        FileSystemResource cpr = new FileSystemResource(f);
        xmlReader.loadBeanDefinitions((Resource)cpr);
        return ctx;
    }

    @Override
    public void publishPublicContent(List<MediaCollection> mcs) throws DataAccessException {
        this.publishPublicContent(mcs, null);
    }

    @Override
    public void publishPublicContent(List<MediaCollection> mcs, List<SharedLunaMedia> mediaToPublish) throws DataAccessException {
        if (!CollectionUtils.isEmpty(mcs)) {
            File workingDirectory = null;
            try {
                File distributionDirectory = new File(this.contentDistributionDirectoy);
                if (distributionDirectory.exists()) {
                    FileUtils.deleteFolderContent(distributionDirectory);
                } else {
                    distributionDirectory.mkdir();
                }
                workingDirectory = new File(distributionDirectory, DISTRIBUTED_CONTENT_DIRECTORY_NAME);
                workingDirectory.mkdir();
                this.generateDescriptorFile(mcs, workingDirectory);
                this.generateIndexForDistribution(mcs, workingDirectory);
                this.compressWorkingDirectory(workingDirectory);
                FileUtils.deleteFolderRecursive(workingDirectory);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error publish public content! ", (Throwable)e);
                throw new DataAccessResourceFailureException("Error publish public content!", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Error publish public content! ", (Throwable)e);
                throw new DataAccessResourceFailureException("Error publish public content!", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"Error publish public content! ", (Throwable)e);
                throw new DataAccessResourceFailureException("Error publish public content!", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error publish public content! ", (Throwable)e);
                throw new InvalidDataAccessResourceUsageException("Error publish public content!", (Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"Error publish public content! ", (Throwable)e);
                throw new DataRetrievalFailureException("Error publish public content!", (Throwable)e);
            }
        } else {
            log.info((Object)"No media collections were given to publish!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressWorkingDirectory(File workingDirectory) throws IOException {
        OutputStream out = null;
        DeflaterOutputStream zipOut = null;
        try {
            out = new FileOutputStream(new File(this.contentDistributionDirectoy + File.separatorChar + DescriptorFileProperties.lunaContent.getFileName()));
            zipOut = new ZipOutputStream(out);
            ((ZipOutputStream)zipOut).setLevel(this.useCompression ? -1 : 0);
            FileUtils.writeFilesToZip(workingDirectory, this.contentDistributionDirectoy, workingDirectory.getName(), (ZipOutputStream)zipOut);
        }
        finally {
            if (zipOut != null) {
                zipOut.flush();
                ((ZipOutputStream)zipOut).close();
            }
            if (out != null) {
                out.flush();
                ((FileOutputStream)out).close();
            }
        }
    }

    @Deprecated
    private void generateIndexForDistribution(List<MediaCollection> mcs, File workingDirectory) throws IOException, SQLException {
    }

    private List<MediaField> getStorableMediaFields(List<MediaCollection> mcs) {
        ArrayList<MediaField> storableMediaFields = new ArrayList<MediaField>();
        if (CollectionUtils.isNotEmpty(storableMediaFields)) {
            for (MediaCollection mc : mcs) {
                for (MediaField mf : mc.getMediaFields()) {
                    if (!mf.isPreviewField() && !mf.isSummaryDescriptionField() && mf.getType() == null && mf.getDefaultCollectionSort() <= 0) continue;
                    storableMediaFields.add(mf);
                }
            }
        }
        return storableMediaFields;
    }

    private SharedMediaCollection constrcutSharedMediaCollection(MediaCollection mc) throws IOException, IllegalAccessException, InvocationTargetException {
        SharedMediaCollection smc = null;
        if (mc != null) {
            SharedMediaField smf;
            ArrayList<MediaField> mfs;
            smc = new SharedMediaCollection();
            BeanUtils.copyProperties((Object)smc, (Object)mc);
            if (mc.getExtendedCollectionProperties() != null) {
                SharedExtendedCollectionProperties secp = new SharedExtendedCollectionProperties();
                BeanUtils.copyProperties((Object)secp, (Object)mc.getExtendedCollectionProperties());
                secp.setCollectionId(mc.getId());
                secp.setDefaultGroupId(0);
                smc.setExtendedCollectionProperties(secp);
            }
            if (mc.getPreviewMediaFields() != null) {
                mfs = new ArrayList<MediaField>();
                for (MediaField mf : mc.getPreviewMediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setPreviewMediaFields(mfs);
            }
            if (mc.getSummaryDescriptionMediaFields() != null) {
                mfs = new ArrayList();
                for (MediaField mf : mc.getSummaryDescriptionMediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setSummaryDescriptionMediaFields(mfs);
            }
            if (mc.getW4MediaFields() != null) {
                mfs = new ArrayList();
                for (MediaField mf : mc.getW4MediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setW4MediaFields(mfs);
            }
        }
        return smc;
    }

    private List<SharedMediaCollection> constrcutSharedMediaCollections(List<MediaCollection> mcs) throws IOException, IllegalAccessException, InvocationTargetException {
        ArrayList<SharedMediaCollection> smcs = new ArrayList<SharedMediaCollection>();
        for (MediaCollection mc : mcs) {
            SharedMediaCollection smc = this.constrcutSharedMediaCollection(mc);
            if (smc == null) continue;
            smcs.add(smc);
        }
        return smcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDescriptorFile(List<MediaCollection> mcs, File workingDirectory) throws IOException, IllegalAccessException, InvocationTargetException {
        try (FileOutputStream out = null;){
            List<SharedMediaCollection> smcs = this.constrcutSharedMediaCollections(mcs);
            ContentDistributionDescriptor descriptor = null;
            String beanName = DescriptorFileProperties.contentDescriptor.toString();
            int count = 1;
            for (SharedMediaCollection smc : smcs) {
                descriptor = new ContentDistributionDescriptor(smc);
                Document doc = new Document();
                doc.setDocType((DocType)XML_DOC_TYPE.clone());
                Element root = new Element("beans");
                XmlUtils.constrcutXmlElement(descriptor, beanName, root, DESCRIPTOR_SKIP_PROPERTIES, true);
                doc.setRootElement(root);
                out = new FileOutputStream(new File(workingDirectory, count + DESCRIPTOR_FILE_NAME));
                XML_OUTPUTTER.output(doc, (OutputStream)out);
                out.flush();
                out.close();
                ++count;
            }
        }
    }

    public void setMediaSearchDao(MediaSearchDao mediaSearchDao) {
        this.mediaSearchDao = mediaSearchDao;
    }

    public static enum DescriptorFileProperties {
        contentDescriptor,
        lunaContent("lunaContent.zip");

        protected String fileName = null;

        private DescriptorFileProperties(String fileName) {
            this.fileName = fileName;
        }

        private DescriptorFileProperties() {
            this(null);
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

